/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.util.Comparator;
import phex.prefs.core.BandwidthPrefs;
import phex.upload.UploadQueueState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HrrnQueueComparator
implements Comparator<UploadQueueState> {
    private long baseTime;

    public HrrnQueueComparator(long baseTime) {
        this.baseTime = baseTime;
    }

    @Override
    public int compare(UploadQueueState q1, UploadQueueState q2) {
        double ratio2;
        if (q1 == q2) {
            return 0;
        }
        double ratio1 = HrrnQueueComparator.calcRatio(q1, this.baseTime);
        if (ratio1 > (ratio2 = HrrnQueueComparator.calcRatio(q2, this.baseTime))) {
            return -1;
        }
        if (ratio1 < ratio2) {
            return 1;
        }
        int timeDiff = (int)(q1.getFirstQueueTime() - q2.getFirstQueueTime());
        if (timeDiff != 0) {
            return timeDiff;
        }
        int indexDiff = q1.getUploadState().hashCode() - q2.getUploadState().hashCode();
        assert (indexDiff != 0) : "UploadState hashCode matches.";
        return indexDiff;
    }

    public static double calcRatio(UploadQueueState state, long baseTime) {
        long fileSize = state.getLastRequestedFile().getFileSize();
        float uploadSpeed = BandwidthPrefs.MaxUploadBandwidth.get().floatValue();
        double estimatedTimeSec = (float)fileSize / uploadSpeed;
        double waitTimeSec = Math.max((double)(baseTime - state.getFirstQueueTime()) / 1000.0, 1.0);
        double ratio = 1.0 + Math.max(1.0, waitTimeSec) / estimatedTimeSec;
        return ratio;
    }
}

