/*
 * Decompiled with CFR 0.152.
 */
package phex.update;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.common.Environment;
import phex.common.LongObj;
import phex.common.OpenPgpToolkit;
import phex.common.PhexVersion;
import phex.event.UpdateNotificationListener;
import phex.gui.common.GUIRegistry;
import phex.prefs.core.ConnectionPrefs;
import phex.prefs.core.PhexCorePrefs;
import phex.prefs.core.StatisticPrefs;
import phex.prefs.core.UpdatePrefs;
import phex.servent.Servent;
import phex.share.SharedFilesService;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticsManager;
import phex.utils.IOUtil;
import phex.utils.Localizer;
import phex.utils.VersionUtils;
import phex.xml.sax.DPhex;
import phex.xml.sax.DUpdateRequest;
import phex.xml.sax.DUpdateResponse;
import phex.xml.sax.XMLBuilder;

public class UpdateCheckRunner
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCheckRunner.class);
    private static final String UPDATE_CHECK_URL = "http://www.phex.org/update/update34.php";
    public static final String PUBLIC_KEY_ID = "0x0EE3F089E5CC3925";
    private Throwable updateCheckError;
    private UpdateNotificationListener listener;
    private String releaseVersion;
    private String betaVersion;
    private boolean isBetaInfoShown;

    public UpdateCheckRunner(UpdateNotificationListener updateListener, boolean showBetaInfo) {
        this.listener = updateListener;
        this.isBetaInfoShown = showBetaInfo;
    }

    public static void triggerAutoBackgroundCheck(UpdateNotificationListener updateListener, boolean showBetaInfo) {
        if (UpdatePrefs.LastUpdateCheckTime.get() > System.currentTimeMillis() - 604800000L) {
            logger.debug("No update check necessary.");
            return;
        }
        logger.debug("Triggering update check.");
        UpdateCheckRunner runner = new UpdateCheckRunner(updateListener, showBetaInfo);
        Environment.getInstance().executeOnThreadPool(runner, "UpdateCheckRunner");
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getBetaVersion() {
        return this.betaVersion;
    }

    public Throwable getUpdateCheckError() {
        return this.updateCheckError;
    }

    public void run() {
        try {
            this.performUpdateCheck();
        }
        catch (Throwable exp) {
            this.updateCheckError = exp;
            logger.warn(exp.toString(), exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performUpdateCheck() {
        DPhex dPhex;
        Environment env = Environment.getInstance();
        try {
            byte[] data = this.buildXMLUpdateRequest();
            if (data == null) {
                throw new IOException("Missing XML update data");
            }
            if (logger.isDebugEnabled()) {
                logger.debug(new String(data));
            }
            URL url = new URL(UPDATE_CHECK_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            connection.setRequestProperty("User-Agent", env.getPhexVendor());
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
            OutputStream outStream = connection.getOutputStream();
            outStream.write(data);
            UpdatePrefs.LastUpdateCheckTime.set(System.currentTimeMillis());
            InputStream inStream = connection.getInputStream();
            UpdateResponseParts parts = this.createResponseParts(inStream);
            this.verifySignature(parts);
            dPhex = XMLBuilder.readDPhexFromStream(new ByteArrayInputStream(parts.xml.getBytes("UTF-8")));
        }
        catch (MalformedURLException exp) {
            this.updateCheckError = exp;
            logger.error(exp.toString(), (Throwable)exp);
            assert (false);
            throw new RuntimeException();
        }
        catch (UnknownHostException exp) {
            this.updateCheckError = exp;
            logger.warn(exp.toString(), (Throwable)exp);
            return;
        }
        catch (SocketException exp) {
            this.updateCheckError = exp;
            logger.warn(exp.toString(), (Throwable)exp);
            return;
        }
        catch (IOException exp) {
            this.updateCheckError = exp;
            logger.warn(exp.toString(), (Throwable)exp);
            return;
        }
        finally {
            PhexCorePrefs.save(false);
        }
        DUpdateResponse response = dPhex.getUpdateResponse();
        List<DUpdateResponse.VersionType> versionList = response.getVersionList();
        DUpdateResponse.VersionType latestReleaseVersion = null;
        DUpdateResponse.VersionType latestBetaVersion = null;
        for (DUpdateResponse.VersionType currentVersion : versionList) {
            if (currentVersion.isBeta()) {
                if (latestBetaVersion != null && VersionUtils.compare(currentVersion.getId(), latestBetaVersion.getId()) <= 0) continue;
                latestBetaVersion = currentVersion;
                continue;
            }
            if (latestReleaseVersion != null && VersionUtils.compare(currentVersion.getId(), latestReleaseVersion.getId()) <= 0) continue;
            latestReleaseVersion = currentVersion;
        }
        this.betaVersion = "0";
        this.releaseVersion = "0";
        if (latestBetaVersion != null) {
            this.betaVersion = latestBetaVersion.getId();
        }
        if (latestReleaseVersion != null) {
            this.releaseVersion = latestReleaseVersion.getId();
        }
        int releaseCompare = 0;
        int betaCompare = 0;
        betaCompare = VersionUtils.compare(this.betaVersion, PhexVersion.getFullVersion());
        releaseCompare = VersionUtils.compare(this.releaseVersion, PhexVersion.getFullVersion());
        if (releaseCompare <= 0 && betaCompare <= 0) {
            return;
        }
        betaCompare = VersionUtils.compare(this.betaVersion, UpdatePrefs.LastBetaUpdateCheckVersion.get());
        releaseCompare = VersionUtils.compare(this.releaseVersion, UpdatePrefs.LastUpdateCheckVersion.get());
        int verDiff = VersionUtils.compare(this.betaVersion, this.releaseVersion);
        boolean triggerUpdateNotification = false;
        if (releaseCompare > 0) {
            UpdatePrefs.LastUpdateCheckVersion.set(this.releaseVersion);
            triggerUpdateNotification = true;
        }
        if (betaCompare > 0) {
            UpdatePrefs.LastBetaUpdateCheckVersion.set(this.betaVersion);
            triggerUpdateNotification = true;
        }
        if (verDiff > 0) {
            this.releaseVersion = null;
        } else {
            this.betaVersion = null;
        }
        if (triggerUpdateNotification) {
            PhexCorePrefs.save(false);
            this.fireUpdateNotification();
        }
    }

    private void verifySignature(UpdateResponseParts parts) throws IOException {
        OpenPgpToolkit pgpKit = new OpenPgpToolkit();
        String keyServer = pgpKit.getRandomKeyserver();
        PGPPublicKey pubKey = pgpKit.lookupKeyById(keyServer, PUBLIC_KEY_ID);
        if (pubKey.isRevoked()) {
            throw new IOException("Public key revoked");
        }
        PGPObjectFactory pgpFact = new PGPObjectFactory((InputStream)new ArmoredInputStream((InputStream)new ByteArrayInputStream(parts.sig.getBytes("US-ASCII"))));
        PGPSignatureList list = (PGPSignatureList)pgpFact.nextObject();
        PGPSignature sig = list.get(0);
        try {
            sig.initVerify(pubKey, "BC");
            sig.update(parts.xml.getBytes("UTF-8"));
            if (!sig.verify()) {
                throw new IOException("Invalid signature.");
            }
        }
        catch (PGPException exp) {
            logger.error(exp.toString(), (Throwable)exp);
            throw new IOException("PGPException: " + exp.getMessage());
        }
        catch (GeneralSecurityException exp) {
            logger.error(exp.toString(), (Throwable)exp);
            throw new IOException(exp.toString());
        }
    }

    private void fireUpdateNotification() {
        this.listener.updateNotification(this);
    }

    private byte[] buildXMLUpdateRequest() {
        Servent servent = Servent.getInstance();
        try {
            DPhex dPhex = new DPhex();
            DUpdateRequest dRequest = new DUpdateRequest();
            dPhex.setUpdateRequest(dRequest);
            dRequest.setCurrentVersion(PhexVersion.getFullVersion());
            dRequest.setStartupCount(StatisticPrefs.TotalStartupCounter.get());
            dRequest.setLafUsed(GUIRegistry.getInstance().getUsedLAFClass());
            dRequest.setLanguage(Localizer.getUsedLocale().toString());
            dRequest.setJavaVersion(System.getProperty("java.version"));
            dRequest.setOperatingSystem(SystemUtils.OS_NAME);
            dRequest.setHostid(servent.getServentGuid().toHexString());
            dRequest.setShowBetaInfo(this.isBetaInfoShown);
            dRequest.setLastInfoId(UpdatePrefs.LastShownUpdateInfoId.get());
            String lastCheckVersion = VersionUtils.compare(UpdatePrefs.LastUpdateCheckVersion.get(), UpdatePrefs.LastBetaUpdateCheckVersion.get()) > 0 ? UpdatePrefs.LastUpdateCheckVersion.get() : UpdatePrefs.LastBetaUpdateCheckVersion.get();
            dRequest.setLastCheckVersion(lastCheckVersion);
            int lupStatus = 0;
            if (servent.isShieldedLeafNode()) {
                lupStatus = ConnectionPrefs.AllowToBecomeUP.get().booleanValue() ? 2 : 1;
            } else if (servent.isUltrapeer()) {
                lupStatus = ConnectionPrefs.ForceToBeUltrapeer.get() != false ? 4 : 3;
            }
            dRequest.setLeafUltrapeerStatus(lupStatus);
            StatisticsManager statMgr = servent.getStatisticsService();
            StatisticProvider uptimeProvider = statMgr.getStatisticProvider("UptimeProvider");
            dRequest.setAvgUptime(((LongObj)uptimeProvider.getAverageValue()).value);
            StatisticProvider dailyUptimeProvider = statMgr.getStatisticProvider("DailyUptimeProvider");
            dRequest.setDailyAvgUptime((Integer)dailyUptimeProvider.getValue());
            StatisticProvider downloadProvider = statMgr.getStatisticProvider("TotalDownloadCountProvider");
            dRequest.setDownloadCount((int)((LongObj)downloadProvider.getValue()).value);
            StatisticProvider uploadProvider = statMgr.getStatisticProvider("TotalUploadCountProvider");
            dRequest.setUploadCount((int)((LongObj)uploadProvider.getValue()).value);
            SharedFilesService sharedFilesService = Servent.getInstance().getSharedFilesService();
            dRequest.setSharedFiles(sharedFilesService.getFileCount());
            dRequest.setSharedSize(sharedFilesService.getTotalFileSizeInKb());
            dRequest.setErrorLog(this.getErrorLogFileTail());
            return XMLBuilder.serializeToBytes(dPhex);
        }
        catch (IOException exp) {
            logger.error(exp.toString(), (Throwable)exp);
            return null;
        }
    }

    private String getErrorLogFileTail() {
        try {
            File logFile = Environment.getInstance().getPhexConfigFile("phex.error.log");
            if (!logFile.exists()) {
                return null;
            }
            RandomAccessFile raf = new RandomAccessFile(logFile, "r");
            long pos = Math.max(raf.length() - 10240L, 0L);
            raf.seek(pos);
            byte[] buffer = new byte[(int)Math.min(10240L, raf.length())];
            int lenRead = raf.read(buffer);
            return new String(buffer, 0, lenRead);
        }
        catch (IOException exp) {
            logger.error(exp.toString(), (Throwable)exp);
            return exp.toString();
        }
    }

    private UpdateResponseParts createResponseParts(InputStream stream) throws IOException {
        int pgpIdx;
        InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
        String dataStr = IOUtil.toString(reader);
        for (pgpIdx = dataStr.indexOf("-BEGIN PGP"); dataStr.charAt(pgpIdx) == '-' && pgpIdx > 0; --pgpIdx) {
        }
        int xmlIdx = pgpIdx;
        while (dataStr.charAt(xmlIdx) != '>' && pgpIdx > 0) {
            --xmlIdx;
        }
        UpdateResponseParts parts = new UpdateResponseParts();
        parts.xml = dataStr.substring(0, xmlIdx + 1);
        parts.sig = dataStr.substring(pgpIdx);
        logger.debug(parts.xml);
        logger.debug(parts.sig);
        return parts;
    }

    private class UpdateResponseParts {
        String xml;
        String sig;

        private UpdateResponseParts() {
        }
    }
}

