/*
 * Decompiled with CFR 0.152.
 */
package phex.statistic;

import phex.common.HorizonTracker;
import phex.statistic.StatisticProvider;

public class HorizonStatisticProvider
implements StatisticProvider {
    private final HorizonTracker horizonTracker;
    private final Type type;

    public HorizonStatisticProvider(Type type, HorizonTracker horizonTracker) {
        this.horizonTracker = horizonTracker;
        this.type = type;
    }

    public Object getValue() {
        switch (this.type) {
            case HOST_COUNT: {
                return this.horizonTracker.getTotalHostCount();
            }
            case FILE_COUNT: {
                return this.horizonTracker.getTotalFileCount();
            }
            case FILE_SIZE: {
                return this.horizonTracker.getTotalFileSize();
            }
        }
        return null;
    }

    public Object getAverageValue() {
        switch (this.type) {
            case FILE_SIZE: {
                long count = this.horizonTracker.getTotalFileCount();
                if (count == 0L) break;
                int val = (int)((double)this.horizonTracker.getTotalFileSize() / (double)count);
                return val;
            }
            case FILE_COUNT: {
                int hostCount = this.horizonTracker.getTotalHostCount();
                if (hostCount == 0) break;
                int val = (int)((double)this.horizonTracker.getTotalFileCount() / (double)hostCount);
                return val;
            }
        }
        return null;
    }

    public Object getMaxValue() {
        return null;
    }

    public String toStatisticString(Object value) {
        return value.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        HOST_COUNT,
        FILE_COUNT,
        FILE_SIZE;

    }
}

