/*
 * Decompiled with CFR 0.152.
 */
package phex.share.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.share.ShareFile;
import phex.utils.IOUtil;
import phex.utils.URLCodecUtils;
import phex.utils.URLUtil;
import phex.xml.XMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedFilesPipeFiller
implements Runnable {
    private final DestAddress serventAddress;
    private Writer utf8Writer;
    private List<ShareFile> exportData;
    private Map<String, String> exportOptions;

    public SharedFilesPipeFiller(DestAddress serventAddress, OutputStream outStream, List<ShareFile> exportData, Map<String, String> options) {
        block3: {
            this.serventAddress = serventAddress;
            if (exportData == null) {
                throw new NullPointerException("No exportData given.");
            }
            this.exportData = exportData;
            try {
                this.utf8Writer = new OutputStreamWriter(outStream, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        this.exportOptions = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.utf8Writer.write("<shared-file-export>");
            if (this.exportOptions != null && this.exportOptions.size() > 0) {
                this.utf8Writer.write("<export-options>");
                for (String optionName : this.exportOptions.keySet()) {
                    this.utf8Writer.write("<option name='" + optionName + "'>");
                    this.utf8Writer.write(this.exportOptions.get(optionName));
                    this.utf8Writer.write("</option>");
                }
                this.utf8Writer.write("</export-options>");
            }
            this.utf8Writer.write("<shared-file-list>");
            for (ShareFile file : this.exportData) {
                URN urn = file.getURN();
                if (urn == null) continue;
                this.utf8Writer.write("<shared-file>");
                this.utf8Writer.write("<index>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(file.getFileIndex()));
                this.utf8Writer.write("</index>");
                this.utf8Writer.write("<name>");
                XMLUtils.writeEncoded(this.utf8Writer, file.getFileName());
                this.utf8Writer.write("</name>");
                this.utf8Writer.write("<name-urlenc>");
                XMLUtils.writeEncoded(this.utf8Writer, URLCodecUtils.encodeURL(file.getFileName()));
                this.utf8Writer.write("</name-urlenc>");
                this.utf8Writer.write("<search-count>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(file.getSearchCount()));
                this.utf8Writer.write("</search-count>");
                this.utf8Writer.write("<sha1>");
                XMLUtils.writeEncoded(this.utf8Writer, file.getSha1());
                this.utf8Writer.write("</sha1>");
                this.utf8Writer.write("<upload-count>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(file.getUploadCount()));
                this.utf8Writer.write("</upload-count>");
                this.utf8Writer.write("<file-size>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(file.getFileSize()));
                this.utf8Writer.write("</file-size>");
                this.utf8Writer.write("<urn>");
                XMLUtils.writeEncoded(this.utf8Writer, urn.getAsString());
                this.utf8Writer.write("</urn>");
                if (file.getAltLocCount() > 0) {
                    Set<DestAddress> locs = file.getAltLocContainer().getAltLocsForExport(this.serventAddress);
                    for (DestAddress add : locs) {
                        this.utf8Writer.write("<alt-loc>");
                        XMLUtils.writeEncoded(this.utf8Writer, add.getFullHostName());
                        this.utf8Writer.write("</alt-loc>");
                    }
                }
                this.utf8Writer.write("<magnet-url>");
                if (this.exportOptions != null && "true".equals(this.exportOptions.get("UseMagnetURLWithXS"))) {
                    XMLUtils.writeEncoded(this.utf8Writer, URLUtil.buildMagnetURLWithXS(file.getSha1(), file.getFileName(), this.serventAddress));
                } else {
                    XMLUtils.writeEncoded(this.utf8Writer, URLUtil.buildMagnetURL(file.getSha1(), file.getFileName()));
                }
                this.utf8Writer.write("</magnet-url>");
                this.utf8Writer.write("<name2res-url>");
                XMLUtils.writeEncoded(this.utf8Writer, URLUtil.buildFullName2ResourceURL(this.serventAddress, urn));
                this.utf8Writer.write("</name2res-url>");
                this.utf8Writer.write("</shared-file>");
            }
            this.utf8Writer.write("</shared-file-list>");
            this.utf8Writer.write("</shared-file-export>");
        }
        catch (IOException exp) {
            NLogger.error(SharedFilesPipeFiller.class, exp, exp);
        }
        finally {
            IOUtil.closeQuietly(this.utf8Writer);
        }
    }
}

