/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.List;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.download.RemoteFile;
import phex.msg.GUID;
import phex.query.QueryHitHost;

public class SearchResultHolder {
    private List<RemoteFile> queryHitList = new ArrayList<RemoteFile>();

    protected SearchResultHolder() {
    }

    public void addQueryHit(RemoteFile remoteFile) {
        this.queryHitList.add(remoteFile);
    }

    public int getQueryHitCount() {
        return this.queryHitList.size();
    }

    public RemoteFile getQueryHit(int index) {
        if (index < 0 || index >= this.queryHitList.size()) {
            return null;
        }
        return this.queryHitList.get(index);
    }

    public RemoteFile[] getQueryHits(int[] indices) {
        RemoteFile[] results = new RemoteFile[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            results[i] = this.queryHitList.get(indices[i]);
        }
        return results;
    }

    public RemoteFile findQueryHit(QueryHitHost qhh, URN urn, String fileName, long fileSize, int fileIndex) {
        GUID hostGUID = qhh.getHostGUID();
        DestAddress hostAddress = qhh.getHostAddress();
        int size = this.queryHitList.size();
        for (int i = 0; i < size; ++i) {
            DestAddress fileHostAddress;
            RemoteFile file = this.queryHitList.get(i);
            GUID fileHostGUID = file.getRemoteClientID();
            boolean foundMatch = false;
            if (fileHostGUID != null && hostGUID != null && fileHostGUID.equals(hostGUID)) {
                foundMatch = true;
            }
            if (!foundMatch && (fileHostAddress = file.getHostAddress()).equals(hostAddress)) {
                foundMatch = true;
            }
            if (!foundMatch || !(urn != null && file.getURN() != null ? urn.equals(file.getURN()) : fileIndex == file.getFileIndex() && fileSize == file.getFileSize() && fileName.equals(file.getFilename()))) continue;
            return file;
        }
        return null;
    }
}

