/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.common.address.DestAddress;
import phex.msg.InvalidMessageException;
import phex.msg.QueryResponseMsg;
import phex.msg.vendor.OOBReplyCountVMsg;
import phex.query.QHDFlag;
import phex.query.Search;
import phex.servent.Servent;
import phex.utils.IOUtil;
import phex.utils.RandomUtils;

public abstract class QuerySearch
extends Search {
    private static final Logger logger = LoggerFactory.getLogger(QuerySearch.class);
    private HashMap<Long, OOBQueryToken> queryTokens;
    private volatile int totalExpectedResults;

    public QuerySearch(Servent servent) {
        super(servent);
    }

    public int getProgress() {
        if (this.searchProgress == null) {
            return 0;
        }
        if (this.searchProgress.isSearchFinished()) {
            return 100;
        }
        int progress = this.searchProgress.getProgress();
        logger.debug("Search progress: {}", (Object)progress);
        if (this.queryEngine != null) {
            int qeProgress = this.queryEngine.getProgress();
            logger.debug("Query engine progress: {}", (Object)qeProgress);
            progress = Math.max(progress, qeProgress);
        }
        logger.debug("QuerySearch progress: {}", (Object)progress);
        return progress;
    }

    protected byte[] generateSecurityToken(int expectedResults, DestAddress address) {
        byte[] secToken = RandomUtils.getBytes(8);
        long sec = IOUtil.deserializeLong(secToken, 0);
        if (this.queryTokens == null) {
            this.queryTokens = new HashMap();
        }
        this.queryTokens.put(sec, new OOBQueryToken(address, expectedResults));
        this.totalExpectedResults += expectedResults;
        return secToken;
    }

    protected boolean isValid(QueryResponseMsg msg, DestAddress recAddress) throws InvalidMessageException {
        if (this.queryTokens == null) {
            logger.debug("Drop OOB response no tokens given yet.");
            return false;
        }
        byte[] securityToken = msg.getSecurityToken();
        if (securityToken == null) {
            logger.debug("Drop OOB response msg has no tokens.");
            return false;
        }
        if (securityToken.length != 8) {
            logger.debug("Drop OOB response wrong tokens length.");
            return false;
        }
        long sec = IOUtil.deserializeLong(securityToken, 0);
        Long secObj = sec;
        OOBQueryToken token = this.queryTokens.get(secObj);
        if (token == null) {
            logger.debug("Drop OOB response no tokens found.");
            return false;
        }
        if (!token.isAcceptableResponse(msg, recAddress)) {
            return false;
        }
        this.totalExpectedResults -= msg.getRecordCount();
        if (token.isResponseReceived()) {
            this.queryTokens.remove(secObj);
        }
        return true;
    }

    public void processOOBReplyCountResponse(OOBReplyCountVMsg msg, DestAddress sourceAddress) {
        if (this.isSearchFinished()) {
            return;
        }
        if (!msg.getHeader().getMsgID().equals(this.queryMsg.getHeader().getMsgID())) {
            return;
        }
        logger.debug("Handling oob message from {}.", (Object)sourceAddress);
        int resultOpen = this.searchProgress.getDesiredResultsCount() - this.searchProgress.getReceivedResultsCount();
        if (this.totalExpectedResults > resultOpen * 4) {
            logger.debug("Already expeting enough results: {}/{}", (Object)this.totalExpectedResults, (Object)resultOpen);
            return;
        }
        logger.debug("Prepare UDP response for {}.", (Object)sourceAddress);
        byte[] secToken = this.generateSecurityToken(msg.getResultCount(), sourceAddress);
        this.servent.getMessageService().sendUdpMessageAcknowledgementVMsg(msg.getHeader().getMsgID(), msg.getResultCount(), secToken, sourceAddress);
    }

    public void processOOBResponse(QueryResponseMsg msg, DestAddress sourceAddress) throws InvalidMessageException {
        if (!msg.getHeader().getMsgID().equals(this.queryMsg.getHeader().getMsgID())) {
            return;
        }
        if (!this.isValid(msg, sourceAddress)) {
            return;
        }
        if (!(msg.getDestAddress().getIpAddress().equals(sourceAddress.getIpAddress()) || msg.getPushNeededFlag() != QHDFlag.QHD_TRUE_FLAG && msg.getDestAddress().isSiteLocalAddress())) {
            msg.setDestAddressFromOOB(sourceAddress);
        }
        this.processResponse(msg);
    }

    private static class OOBQueryToken {
        private DestAddress expectedAddress;
        private int expectedResults;
        private int receivedResults;

        public OOBQueryToken(DestAddress expectedAddress, int expectedResults) {
            this.expectedAddress = expectedAddress;
            this.expectedResults = expectedResults;
            this.receivedResults = 0;
        }

        public boolean isAcceptableResponse(QueryResponseMsg msg, DestAddress sourceAddress) {
            if (!this.expectedAddress.equals(sourceAddress)) {
                logger.debug("Drop OOB response from invalid address.");
                return false;
            }
            short responses = msg.getRecordCount();
            if (this.receivedResults + responses > this.expectedResults) {
                logger.debug("Drop OOB response too many responses.");
                return false;
            }
            this.receivedResults += responses;
            return true;
        }

        public boolean isResponseReceived() {
            return this.receivedResults >= this.expectedResults;
        }
    }
}

