/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.query.SearchProgress;

public class DefaultSearchProgress
implements SearchProgress {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSearchProgress.class);
    public static final int DEFAULT_QUERY_TIMEOUT = 300000;
    public static final int DESIRED_RESULTS = 200;
    public static final int DESIRED_HASH_RESULTS = 20;
    private long startTime;
    private long lifetime;
    private int desiredResultsCount;
    protected volatile int receivedResultsCount;

    protected DefaultSearchProgress(long lifetime, int desiredResultsCount) {
        this.lifetime = lifetime;
        this.desiredResultsCount = desiredResultsCount;
        this.receivedResultsCount = 0;
        this.startTime = 0L;
    }

    public int getProgress() {
        if (this.isSearchFinished()) {
            return 100;
        }
        if (this.startTime <= 0L) {
            return 0;
        }
        int resultsProgress = 0;
        if (this.getDesiredResultsCount() > 0) {
            resultsProgress = (int)((double)this.getReceivedResultsCount() / (double)this.getDesiredResultsCount() * 100.0);
        }
        int timeProgress = 0;
        if (this.lifetime > 0L) {
            long currentTime = System.currentTimeMillis();
            long timeLeft = this.startTime + this.lifetime - currentTime;
            timeProgress = (int)(100.0 - Math.max(0.0, (double)timeLeft) / (double)this.lifetime * 100.0);
        }
        int totalProgress = Math.min(Math.max(resultsProgress, timeProgress), 100);
        logger.debug("Search progress: r{}, t{}, ={}", new Object[]{resultsProgress, timeProgress, totalProgress});
        return totalProgress;
    }

    public void searchStarted() {
        this.startTime = System.currentTimeMillis();
    }

    public int getDesiredResultsCount() {
        return this.desiredResultsCount;
    }

    public int getReceivedResultsCount() {
        return this.receivedResultsCount;
    }

    public void incReceivedResultsCount(int inc) {
        this.receivedResultsCount += inc;
    }

    public boolean isSearchFinished() {
        long currentTime;
        if (this.getDesiredResultsCount() > 0 && this.getReceivedResultsCount() >= this.getDesiredResultsCount()) {
            return true;
        }
        return this.lifetime > 0L && (currentTime = System.currentTimeMillis()) > this.startTime + this.lifetime;
    }

    public static DefaultSearchProgress createForForMeProgress(boolean isUrnQuery) {
        return new DefaultSearchProgress(300000L, isUrnQuery ? 20 : 200);
    }
}

