/*
 * Decompiled with CFR 0.152.
 */
package phex.net.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.TimerTask;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.Environment;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.address.LocalServentAddress;
import phex.common.log.NLogger;
import phex.event.ChangeEvent;
import phex.event.PhexEventService;
import phex.host.NetworkHostsContainer;
import phex.msghandling.MessageService;
import phex.prefs.core.ConnectionPrefs;
import phex.prefs.core.NetworkPrefs;
import phex.prefs.core.ProxyPrefs;
import phex.servent.Servent;

public abstract class Server
implements Runnable {
    protected final Servent servent;
    private FirewallCheckTimer firewallCheckTimer;
    protected LocalServentAddress localAddress;
    protected ServerSocket serverSocket;
    protected volatile boolean isRunning;
    protected boolean hasConnectedIncomming;
    protected long lastInConnectionTime;

    public Server(Servent servent) {
        this.servent = servent;
        this.hasConnectedIncomming = ConnectionPrefs.HasConnectedIncomming.get();
        this.lastInConnectionTime = -1L;
        this.isRunning = false;
        this.localAddress = new LocalServentAddress(this, servent.getEventService());
        if (ProxyPrefs.ForcedIp.get().length() > 0) {
            IpAddress ip = new IpAddress(AddressUtils.parseIP(ProxyPrefs.ForcedIp.get()));
            this.localAddress.setForcedHostIP(ip);
        }
    }

    public synchronized void startup() throws IOException {
        if (this.isRunning) {
            return;
        }
        NLogger.debug(Server.class, "Starting listener");
        this.isRunning = true;
        this.firewallCheckTimer = new FirewallCheckTimer(this.servent.getHostService().getNetworkHostsContainer(), this.servent.getMessageService(), this.servent.getEventService());
        Environment.getInstance().scheduleTimerTask(this.firewallCheckTimer, 300000L, 300000L);
        this.bind(NetworkPrefs.ListeningPort.get());
        Environment.getInstance().executeOnThreadPool(this, "IncommingListener-" + Integer.toHexString(this.hashCode()));
    }

    protected abstract void bind(int var1) throws IOException;

    protected abstract void closeServer();

    public synchronized void restart() throws IOException {
        this.shutdown(true);
        this.startup();
    }

    public synchronized void shutdown(boolean waitForCompleted) {
        if (!this.isRunning) {
            return;
        }
        NLogger.debug(Server.class, "Shutting down listener");
        this.firewallCheckTimer.cancel();
        this.firewallCheckTimer = null;
        ConnectionPrefs.HasConnectedIncomming.set(this.hasConnectedIncomming);
        this.closeServer();
        if (waitForCompleted) {
            while (this.isRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean hasConnectedIncoming() {
        return this.hasConnectedIncomming;
    }

    public IpAddress resolveLocalHostIP() {
        byte[] ip = null;
        InetAddress addr = this.serverSocket.getInetAddress();
        ip = addr.getAddress();
        IpAddress ipAddress = ip[0] == 0 && ip[1] == 0 && ip[2] == 0 && ip[3] == 0 ? IpAddress.LOCAL_HOST_IP : new IpAddress(ip);
        return ipAddress;
    }

    public LocalServentAddress getLocalAddress() {
        return this.localAddress;
    }

    public void updateLocalAddress(DestAddress newAddress) {
        this.localAddress.updateLocalAddress(newAddress);
    }

    public int getListeningLocalPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return NetworkPrefs.ListeningPort.get();
    }

    private class IncommingCheckRunner
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private IncommingCheckRunner() {
        }

        public void run() {
            try {
                long now = System.currentTimeMillis();
                if (now - Server.this.lastInConnectionTime > 60000L) {
                    Server.this.hasConnectedIncomming = false;
                }
            }
            catch (Throwable th) {
                NLogger.error(Server.class, th, th);
            }
        }
    }

    public class FirewallCheckTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 300000L;
        private static final long CHECK_TIME = 1800000L;
        private final NetworkHostsContainer netHostsContainer;
        private final MessageService messageService;
        private long lastFirewallCheckTime;

        FirewallCheckTimer(NetworkHostsContainer netHostsContainer, MessageService messageService, PhexEventService eventService) {
            this.netHostsContainer = netHostsContainer;
            this.messageService = messageService;
            eventService.processAnnotations(this);
        }

        public void run() {
            try {
                long now = System.currentTimeMillis();
                if (Server.this.hasConnectedIncomming && now - Server.this.lastInConnectionTime > 1800000L || !Server.this.hasConnectedIncomming && now - this.lastFirewallCheckTime > 1800000L) {
                    if (this.netHostsContainer.getUltrapeerConnectionCount() <= 2) {
                        return;
                    }
                    boolean isRequestSent = this.messageService.requestTCPConnectBack();
                    if (isRequestSent) {
                        this.lastFirewallCheckTime = now;
                        Environment.getInstance().scheduleTimerTask(new IncommingCheckRunner(), 60000L);
                    }
                }
            }
            catch (Throwable th) {
                NLogger.error(Server.class, th, th);
            }
        }

        @EventTopicSubscriber(topic="phex:servent/localAddress")
        public void onLocaleAddressEvent(String topic, ChangeEvent event) {
            this.lastFirewallCheckTime = 0L;
        }
    }
}

