/*
 * Decompiled with CFR 0.152.
 */
package phex.net.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import phex.common.bandwidth.BandwidthController;
import phex.common.log.NLogger;
import phex.connection.ConnectionClosedException;
import phex.io.buffer.ByteBuffer;
import phex.io.channels.BandwidthByteChannel;
import phex.net.repres.SocketFacade;
import phex.utils.GnutellaInputStream;
import phex.utils.GnutellaOutputStream;
import phex.utils.IOUtil;

public class Connection {
    protected SocketFacade socket;
    private BandwidthController bandwidthController;
    private BandwidthByteChannel bandwidthByteChannel;
    protected GnutellaInputStream inputStream;
    private GnutellaOutputStream outputStream;

    public Connection(SocketFacade socket, BandwidthController bandwidthController) {
        if (socket == null) {
            throw new IllegalArgumentException("SocketFacade required.");
        }
        if (bandwidthController == null) {
            throw new IllegalArgumentException("Bandwidth controller required.");
        }
        this.socket = socket;
        this.bandwidthController = bandwidthController;
    }

    protected Connection() {
    }

    public void setBandwidthController(BandwidthController bandwidthController) {
        this.bandwidthController = bandwidthController;
        if (this.bandwidthByteChannel != null) {
            this.bandwidthByteChannel.setBandwidthController(bandwidthController);
        }
    }

    private synchronized void initBandwidthByteChannel() throws IOException {
        if (this.bandwidthByteChannel == null) {
            this.bandwidthByteChannel = new BandwidthByteChannel(this.socket.getChannel(), this.bandwidthController);
        }
    }

    public SocketFacade getSocket() {
        return this.socket;
    }

    @Deprecated
    public GnutellaInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            if (this.socket == null) {
                throw new ConnectionClosedException("Connection already closed");
            }
            this.initBandwidthByteChannel();
            InputStream inStream = Channels.newInputStream(this.bandwidthByteChannel);
            this.inputStream = new GnutellaInputStream(inStream);
        }
        return this.inputStream;
    }

    @Deprecated
    public int readPeek() throws IOException {
        return this.getInputStream().peek();
    }

    @Deprecated
    public String readLine() throws IOException {
        String line = this.getInputStream().readLine();
        return line;
    }

    @Deprecated
    public GnutellaOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            if (this.socket == null) {
                throw new ConnectionClosedException("Connection already closed");
            }
            this.initBandwidthByteChannel();
            OutputStream outStream = Channels.newOutputStream(this.bandwidthByteChannel);
            this.outputStream = new GnutellaOutputStream(outStream);
        }
        return this.outputStream;
    }

    public void write(ByteBuffer buffer) throws IOException {
        int pos = buffer.position();
        int limit = buffer.limit();
        if (buffer.hasArray()) {
            byte[] bufferSrc = buffer.array();
            this.getOutputStream().write(bufferSrc, pos, limit - pos);
            buffer.position(limit);
        } else {
            byte[] buf = new byte[limit - pos];
            buffer.get(buf);
            this.getOutputStream().write(buf);
        }
    }

    public void read(ByteBuffer buffer) throws IOException {
        int pos = buffer.position();
        int limit = buffer.limit();
        if (buffer.hasArray()) {
            byte[] bufferSrc = buffer.array();
            int length = this.getInputStream().read(bufferSrc, pos, limit - pos);
            buffer.skip(length);
        } else {
            byte[] buf = new byte[limit - pos];
            int length = this.getInputStream().read(buf);
            buffer.put(buf, 0, length);
        }
    }

    public void flush() throws IOException {
        this.getOutputStream().flush();
    }

    public void disconnect() {
        NLogger.debug(Connection.class, "Disconnecting socket " + this.socket);
        IOUtil.closeQuietly(this.inputStream);
        IOUtil.closeQuietly(this.outputStream);
        IOUtil.closeQuietly(this.socket);
        this.inputStream = null;
        this.outputStream = null;
        this.socket = null;
    }
}

