/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.common.Environment;
import phex.connection.ConnectionStatusEvent;
import phex.event.ChangeEvent;
import phex.host.HostFetchingStrategy;
import phex.host.NetworkHostsContainer;
import phex.prefs.core.ConnectionPrefs;
import phex.servent.OnlineStatus;
import phex.servent.Servent;

public class OnlineObserver {
    private static final Logger logger = LoggerFactory.getLogger(OnlineObserver.class);
    private AtomicInteger failedConnections;
    private final Servent servent;
    private final HostFetchingStrategy fetchingStrategy;
    private AutoReconnectTimer autoReconnectTimer;
    private long lastOfflineTime;
    private long lastHostFetchTime;

    public OnlineObserver(Servent servent, HostFetchingStrategy fetchingStrategy) {
        this.fetchingStrategy = fetchingStrategy;
        this.servent = servent;
        this.failedConnections = new AtomicInteger(0);
        servent.getEventService().processAnnotations(this);
    }

    @EventTopicSubscriber(topic="phex:net/connectionStatus")
    public void onConnectionStatusEvent(String topic, ConnectionStatusEvent event) {
        if (event.getStatus() == ConnectionStatusEvent.Status.CONNECTION_FAILED) {
            NetworkHostsContainer networkHostsContainer = this.servent.getHostService().getNetworkHostsContainer();
            if (networkHostsContainer.getTotalConnectionCount() > 0) {
                this.failedConnections.set(0);
                return;
            }
            int fc = this.failedConnections.incrementAndGet();
            if (logger.isDebugEnabled() && fc % 5 == 0) {
                logger.debug("Observed " + this.failedConnections + " failed connections.");
            }
            if (fc % 15 == 0 && System.currentTimeMillis() - this.lastHostFetchTime > 15000L) {
                logger.info("Started fetching new hosts due to increasing failed connections");
                this.lastHostFetchTime = System.currentTimeMillis();
                this.fetchingStrategy.fetchNewHosts(HostFetchingStrategy.FetchingReason.UpdateHosts);
            }
            if (fc >= ConnectionPrefs.OfflineConnectionFailureCount.get()) {
                logger.debug("Too many connections failed.. disconnecting network.");
                this.triggerReconnectTimer();
            }
        } else {
            this.resetAutoReconnect();
        }
    }

    private synchronized void triggerReconnectTimer() {
        OnlineStatus oldStatus = this.servent.getOnlineStatus();
        this.servent.setOnlineStatus(OnlineStatus.OFFLINE);
        if (this.autoReconnectTimer != null) {
            this.autoReconnectTimer.setOfflineTime(this.lastOfflineTime);
            return;
        }
        this.autoReconnectTimer = new AutoReconnectTimer();
        this.autoReconnectTimer.setReconnectStatus(oldStatus);
        this.autoReconnectTimer.setOfflineTime(this.lastOfflineTime);
        Environment.getInstance().scheduleTimerTask(this.autoReconnectTimer, 60000L, 120000L);
    }

    private synchronized void autoReconnectTry(OnlineStatus status) {
        logger.debug("Triggering auto-reconnect");
        this.failedConnections.set(0);
        this.servent.setOnlineStatus(status);
    }

    private synchronized void resetAutoReconnect() {
        if (this.autoReconnectTimer != null) {
            logger.debug("Reset auto-reconnect");
            this.autoReconnectTimer.cancel();
            this.autoReconnectTimer = null;
        }
        this.failedConnections.set(0);
    }

    @EventTopicSubscriber(topic="phex:servent/onlineStatus")
    public void onOnlineStatusEvent(String topic, ChangeEvent event) {
        OnlineStatus oldStatus = (OnlineStatus)((Object)event.getOldValue());
        OnlineStatus newStatus = (OnlineStatus)((Object)event.getNewValue());
        if (oldStatus == OnlineStatus.OFFLINE && newStatus != OnlineStatus.OFFLINE) {
            this.failedConnections.set(0);
        } else if (oldStatus != OnlineStatus.OFFLINE && newStatus == OnlineStatus.OFFLINE) {
            this.lastOfflineTime = System.currentTimeMillis();
        }
    }

    public class AutoReconnectTimer
    extends TimerTask {
        private OnlineStatus reconnectStatus;
        private long offlineTime;

        public void run() {
            if (OnlineObserver.this.lastOfflineTime != this.offlineTime) {
                this.cancel();
                return;
            }
            if (!OnlineObserver.this.servent.getOnlineStatus().isNetworkOnline()) {
                OnlineObserver.this.autoReconnectTry(this.reconnectStatus);
            }
        }

        public void setReconnectStatus(OnlineStatus reconnectStatus) {
            this.reconnectStatus = reconnectStatus;
        }

        public void setOfflineTime(long offlineTime) {
            this.offlineTime = offlineTime;
        }

        public long getOfflineTime() {
            return this.offlineTime;
        }
    }
}

