/*
 * Decompiled with CFR 0.152.
 */
package phex.msghandling;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xsocket.IDataSource;
import phex.common.address.DestAddress;
import phex.host.HostManager;
import phex.io.buffer.ByteBuffer;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.msg.PingMsg;
import phex.msg.PongFactory;
import phex.msg.PongMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.vendor.MessageAcknowledgementVMsg;
import phex.msg.vendor.OOBReplyCountVMsg;
import phex.msg.vendor.UdpHeadPingVMsg;
import phex.msg.vendor.VendorMsg;
import phex.msghandling.MessageService;
import phex.net.UdpDataHandler;
import phex.net.UdpService;
import phex.security.AccessType;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;
import phex.share.SharedFilesService;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticsManager;
import phex.udp.UdpGuidRoutingTable;

public class UdpMessageDataHandler
implements UdpDataHandler {
    private static final Logger logger = LoggerFactory.getLogger(UdpMessageDataHandler.class);
    private final Servent servent;
    private final StatisticsManager statsService;
    private final SharedFilesService sharedFilesService;
    private final PongFactory pongFactory;
    private final PhexSecurityManager securityService;
    private final HostManager hostService;
    private final MessageService messageService;
    private final UdpService udpService;
    private final UdpGuidRoutingTable pingRoutingTable;

    public UdpMessageDataHandler(Servent servent, StatisticsManager statsService, SharedFilesService sharedFilesService, PongFactory pongFactory, PhexSecurityManager securityService, HostManager hostService, MessageService messageService, UdpService udpService) {
        this.servent = servent;
        this.statsService = statsService;
        this.sharedFilesService = sharedFilesService;
        this.pongFactory = pongFactory;
        this.securityService = securityService;
        this.hostService = hostService;
        this.messageService = messageService;
        this.udpService = udpService;
        this.pingRoutingTable = new UdpGuidRoutingTable(30000L);
    }

    public void handleUdpData(IDataSource dataSource, DestAddress orgin) {
        try {
            java.nio.ByteBuffer headerBuffer = java.nio.ByteBuffer.allocate(23);
            dataSource.read(headerBuffer);
            headerBuffer.flip();
            MsgHeader msgHeader = MessageProcessor.parseMessageHeader(headerBuffer);
            java.nio.ByteBuffer bodyBuffer = java.nio.ByteBuffer.allocate(msgHeader.getDataLength());
            dataSource.read(bodyBuffer);
            bodyBuffer.flip();
            try {
                Message msg = MessageProcessor.createMessageFromBody(msgHeader, bodyBuffer.array(), this.securityService);
                msg.setUdpMsg(true);
                AccessType access = this.securityService.controlHostAddressAccess(orgin);
                if (access == AccessType.ACCESS_STRONGLY_DENIED) {
                    this.dropMessage(msg, orgin, "IP access strongly denied.");
                    return;
                }
                msgHeader.countHop();
                switch (msgHeader.getPayload()) {
                    case 0: {
                        this.handlePing((PingMsg)msg, orgin);
                        break;
                    }
                    case 1: {
                        this.handlePong((PongMsg)msg, orgin);
                        break;
                    }
                    case -127: {
                        this.handleQueryResponse((QueryResponseMsg)msg, orgin);
                        break;
                    }
                    case 49: 
                    case 50: {
                        this.handleVendorMessage((VendorMsg)msg, orgin);
                        break;
                    }
                    default: {
                        logger.debug("Rcv unrecognized Msg from: {}", (Object)orgin);
                        break;
                    }
                }
            }
            catch (InvalidMessageException exp) {
                logger.warn(exp.toString(), (Throwable)exp);
            }
        }
        catch (IOException exp) {
            logger.warn(exp.toString(), (Throwable)exp);
        }
    }

    private void handlePing(PingMsg pingMsg, DestAddress orgin) throws IOException {
        MsgHeader header = pingMsg.getHeader();
        if (header.getHopsTaken() > 1) {
            this.dropMessage(pingMsg, orgin, "Udp Ping traveled more then 1 hop.");
            return;
        }
        logger.debug("Rcv UDP PingMsg {} from {}", (Object)pingMsg, (Object)orgin);
        StatisticProvider uptimeProvider = this.statsService.getStatisticProvider("DailyUptimeProvider");
        int avgDailyUptime = (Integer)uptimeProvider.getValue();
        int shareFileCount = this.sharedFilesService.getFileCount();
        int shareFileSize = this.sharedFilesService.getTotalFileSizeInKb();
        DestAddress localAddress = this.servent.getLocalAddress();
        boolean isUdpHostCache = this.servent.isUdpHostCache();
        PongMsg pong = this.pongFactory.createUdpPongMsg(pingMsg, localAddress, isUdpHostCache, avgDailyUptime, shareFileCount, shareFileSize, this.servent.isUltrapeer());
        this.udpService.sendDatagram(pong.getbytes(), orgin);
    }

    private void handlePong(PongMsg pongMsg, DestAddress orgin) {
        logger.debug("Rcv PongMsg {} from: {}", (Object)pongMsg, (Object)orgin);
        MsgHeader header = pongMsg.getHeader();
        if (header.getHopsTaken() > 1) {
            this.dropMessage(pongMsg, orgin, "Udp Pong traveled more then 1 hop.");
            return;
        }
        GUID guid = header.getMsgID();
        DestAddress address = this.pingRoutingTable.getAndRemoveRouting(guid);
        if (address == null) {
            logger.warn("Recieved not requested UDP Pong from {}", (Object)orgin);
            return;
        }
        DestAddress pongAddress = pongMsg.getPongAddress();
        boolean isNew = this.hostService.catchHosts(pongMsg);
        if (isNew) {
            this.messageService.addPongToCache(pongMsg);
        }
    }

    private void handleQueryResponse(QueryResponseMsg msg, DestAddress orgin) throws InvalidMessageException {
        this.messageService.dispatchToUdpSubscribers(msg, orgin);
    }

    private void handleVendorMessage(VendorMsg msg, DestAddress orgin) throws InvalidMessageException {
        if (msg instanceof OOBReplyCountVMsg) {
            this.handleOOBReplyCountVMsg((OOBReplyCountVMsg)msg, orgin);
        } else if (msg instanceof UdpHeadPingVMsg) {
            UdpHeadPingVMsg headPing = (UdpHeadPingVMsg)msg;
            logger.warn("Possible UdpHeadPing spam from {}: Features: {}, URN: {}, GUID: {}", new Object[]{orgin, headPing.getFeatures(), headPing.getUrn().getAsString(), headPing.getGuid()});
        }
    }

    private void handleOOBReplyCountVMsg(OOBReplyCountVMsg msg, DestAddress orgin) throws InvalidMessageException {
        this.messageService.dispatchToUdpSubscribers(msg, orgin);
    }

    private void dropMessage(Message msg, DestAddress orgin, String reason) {
        logger.info("Dropping UDP message: {} from {}.", (Object)reason, (Object)orgin);
        if (logger.isDebugEnabled()) {
            logger.debug("Header: [" + msg.getHeader().toString() + "] - Message: [" + msg.toString() + "].");
        }
    }

    public void sendUdpPing(PingMsg pingMsg, DestAddress destination) {
        GUID guid = pingMsg.getHeader().getMsgID();
        if (!this.pingRoutingTable.checkAndAddRouting(guid, destination)) {
            logger.warn("Ping with duplicate guid not sent {} for message: {}", (Object)guid, (Object)pingMsg);
            return;
        }
        logger.debug("guid: {} successfully added to routing table for udp ping: \n {}", (Object)guid, (Object)pingMsg);
        byte[] data = pingMsg.getBytes();
        try {
            this.udpService.sendDatagram(data, destination);
        }
        catch (IOException exp) {
            logger.warn(exp.toString(), (Throwable)exp);
        }
    }

    public void sendMessageAcknowledgementVMsg(MessageAcknowledgementVMsg respMsg, DestAddress destination) {
        ByteBuffer headerBuf = respMsg.createHeaderBuffer();
        ByteBuffer messageBuf = respMsg.createMessageBuffer();
        int len = headerBuf.remaining();
        byte[] data = new byte[len + messageBuf.remaining()];
        headerBuf.get(data, 0, len);
        messageBuf.get(data, len, messageBuf.remaining());
        try {
            this.udpService.sendDatagram(data, destination);
        }
        catch (IOException exp) {
            logger.warn(exp.toString(), (Throwable)exp);
        }
    }
}

