/*
 * Decompiled with CFR 0.152.
 */
package phex.msg.vendor;

import phex.common.URN;
import phex.msg.GGEPBlock;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.MsgHeader;
import phex.msg.vendor.VendorMsg;

public class UdpHeadPingVMsg
extends VendorMsg {
    public static final int VERSION = 2;
    private static final int FEATURE_MASK = 31;
    private static final int PLAIN = 0;
    private static final int INTERVALS = 1;
    private static final int ALT_LOCS = 2;
    private static final int PUSH_ALTLOCS = 4;
    private static final int FWT_PUSH_ALTLOCS = 8;
    private static final int GGEP_PING = 16;
    private byte features;
    private URN urn;
    private GUID guid;

    public UdpHeadPingVMsg(MsgHeader header, byte[] vendorId, int subSelector, int version, byte[] data) throws InvalidMessageException {
        super(header, vendorId, subSelector, version, data);
        GGEPBlock[] ggepBlocks;
        if (version != 2) {
            throw new InvalidMessageException("Vendor Message 'UdpHeadPingVMsg' with invalid version: " + version);
        }
        if (data.length < 42) {
            throw new InvalidMessageException("Vendor Message 'UdpHeadPingVMsg' with invalid data length: " + data.length);
        }
        this.features = (byte)(data[0] & 0x1F);
        String urnStr = new String(data, 1, 41);
        if (!URN.isValidURN(urnStr)) {
            throw new InvalidMessageException("Vendor Message 'UdpHeadPingVMsg' with invalid URN.");
        }
        this.urn = new URN(urnStr);
        if ((this.features & 0x10) == 16 && GGEPBlock.isExtensionHeaderInBlocks(ggepBlocks = GGEPBlock.parseGGEPBlocks(data, 42), "PUSH")) {
            byte[] guidArr = GGEPBlock.getExtensionDataInBlocks(ggepBlocks, "PUSH");
            this.guid = new GUID(guidArr);
        }
    }

    public byte getFeatures() {
        return this.features;
    }

    public URN getUrn() {
        return this.urn;
    }

    public GUID getGuid() {
        return this.guid;
    }
}

