/*
 * Decompiled with CFR 0.152.
 */
package phex.msg.vendor;

import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.MsgHeader;
import phex.msg.vendor.VendorMsg;
import phex.utils.IOUtil;

public class OOBReplyCountVMsg
extends VendorMsg {
    public static final int VERSION = 3;
    public int resultCount;

    public OOBReplyCountVMsg(MsgHeader header, byte[] vendorId, int subSelector, int version, byte[] data) throws InvalidMessageException {
        super(header, vendorId, subSelector, version, data);
        if (version != 3) {
            throw new InvalidMessageException("Vendor Message 'OOBReplyCountVMsg' with invalid version: " + version);
        }
        if (data.length < 2) {
            throw new InvalidMessageException("Vendor Message 'OOBReplyCountVMsg' with invalid data length: " + data.length);
        }
        this.resultCount = IOUtil.unsignedByte2int(data[0]);
    }

    public int getResultCount() {
        return this.resultCount;
    }

    public OOBReplyCountVMsg(GUID guid, int resultCount) {
        super(VENDORID_LIME, 12, 3, OOBReplyCountVMsg.buildDataBody(resultCount));
        this.resultCount = resultCount;
        this.getHeader().setMsgID(guid);
    }

    private static byte[] buildDataBody(int resultCount) {
        if (resultCount < 1 || resultCount > 255) {
            throw new IllegalArgumentException("Invalid number of results: " + resultCount);
        }
        byte[] resultBytes = new byte[2];
        IOUtil.serializeShortLE((short)resultCount, resultBytes, 0);
        resultBytes[1] = 0;
        return resultBytes;
    }
}

