/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.QRPatchTableMsg;
import phex.msg.QRResetTableMsg;

public abstract class RouteTableUpdateMsg
extends Message {
    public static final byte RESET_TABLE_VARIANT = 0;
    public static final byte PATCH_TABLE_VARIANT = 1;
    protected byte variant;

    public RouteTableUpdateMsg(byte aVariant, int length) {
        super(new MsgHeader(48, 1, length));
        this.variant = aVariant;
    }

    public RouteTableUpdateMsg(byte aVariant, MsgHeader aHeader) {
        super(aHeader);
        this.variant = aVariant;
    }

    public byte getVariant() {
        return this.variant;
    }

    public static RouteTableUpdateMsg parseMessage(MsgHeader header, byte[] aBody) throws InvalidMessageException {
        byte variant = aBody[0];
        switch (variant) {
            case 0: {
                return new QRResetTableMsg(header, aBody);
            }
            case 1: {
                return new QRPatchTableMsg(header, aBody);
            }
        }
        throw new InvalidMessageException("Unknown RouteTableUpdateMsg variant");
    }
}

