/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.msg.GGEPBlock;
import phex.msg.GGEPExtension;
import phex.msg.InvalidGGEPBlockException;
import phex.msg.InvalidMessageException;
import phex.security.PhexSecurityManager;
import phex.share.ShareFile;
import phex.utils.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResponseRecord {
    private static final Logger logger = LoggerFactory.getLogger(QueryResponseRecord.class);
    private static final int DROP_PACKAGE_ALT_LOCATION_LIMIT = 20;
    private int fileIndex = 0;
    private String fileName;
    private byte[] fileNameBytes;
    private String pathInfo;
    private long fileSize;
    private URN urn;
    private String metaData;
    private DestAddress[] alternateLocations;
    private long creationTime;

    public QueryResponseRecord() {
        this.pathInfo = "";
        this.creationTime = -1L;
    }

    public QueryResponseRecord(int fileIndex, URN fileURN, long fileSize, String aFileName, long creationTime, Set<DestAddress> altLocSet) {
        if (fileSize < 0L) {
            throw new IllegalArgumentException("Invalid file size: " + fileSize);
        }
        this.fileIndex = fileIndex;
        this.fileSize = fileSize;
        this.fileName = aFileName;
        this.creationTime = creationTime;
        if (altLocSet != null && altLocSet.size() > 0) {
            assert (altLocSet.size() <= 10);
            this.alternateLocations = new DestAddress[altLocSet.size()];
            altLocSet.toArray(this.alternateLocations);
        }
        try {
            this.fileNameBytes = this.fileName.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException exp) {
            logger.error(exp.toString(), (Throwable)exp);
            throw new RuntimeException(exp);
        }
        this.urn = fileURN;
        this.pathInfo = "";
    }

    public static QueryResponseRecord createFromShareFile(ShareFile shareFile, DestAddress localAddress) {
        int fileIndex = shareFile.getFileIndex();
        URN urn = shareFile.getURN();
        long fileSize = shareFile.getFileSize();
        if (fileSize < 0L) {
            logger.error("Invalid file size: " + fileSize);
            throw new IllegalArgumentException("Invalid file size: " + fileSize);
        }
        String fileName = shareFile.getFileName();
        long networkCreateTime = shareFile.getNetworkCreateTime();
        Set<DestAddress> altLocSet = null;
        if (shareFile.getAltLocCount() > 0) {
            altLocSet = shareFile.getAltLocContainer().getAltLocForQueryResponseRecord(localAddress);
        }
        QueryResponseRecord record = new QueryResponseRecord(fileIndex, urn, fileSize, fileName, networkCreateTime, altLocSet);
        return record;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getFilename() {
        return this.fileName;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public URN getURN() {
        return this.urn;
    }

    public DestAddress[] getAlternateLocations() {
        return this.alternateLocations;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void copy(QueryResponseRecord b) {
        this.fileIndex = b.fileIndex;
        this.fileSize = b.fileSize;
        this.fileName = b.fileName;
        this.fileNameBytes = b.fileNameBytes;
        this.pathInfo = b.pathInfo;
    }

    public void write(OutputStream outStream) throws IOException {
        IOUtil.serializeIntLE(this.fileIndex, outStream);
        if (this.fileSize > Integer.MAX_VALUE) {
            IOUtil.serializeIntLE(-1, outStream);
        } else {
            IOUtil.serializeIntLE((int)this.fileSize, outStream);
        }
        outStream.write(this.fileNameBytes);
        outStream.write(0);
        byte[] ggepData = GGEPBlock.getQueryReplyRecordGGEPBlock(this.creationTime, this.alternateLocations, this.fileSize);
        if (this.urn != null) {
            outStream.write(this.urn.getAsString().getBytes());
            if (ggepData.length > 0) {
                outStream.write(28);
            }
        }
        if (ggepData.length > 0) {
            outStream.write(ggepData);
        }
        outStream.write(0);
    }

    protected int deserialize(byte[] inbuf, int offset, PhexSecurityManager securityService) throws InvalidMessageException {
        long tmpFileIndex = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(inbuf, offset));
        if ((tmpFileIndex & 0xFFFFFFFF00000000L) != 0L) {
            throw new InvalidMessageException("Invalid file index: " + tmpFileIndex);
        }
        this.fileIndex = (int)tmpFileIndex;
        long tmpFileSize = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(inbuf, offset += 4));
        if (tmpFileSize < 0L) {
            throw new InvalidMessageException("Invalid file size: " + tmpFileSize);
        }
        this.fileSize = tmpFileSize;
        int firstTerminatorIdx = offset += 4;
        try {
            while (inbuf[firstTerminatorIdx] != 0) {
                ++firstTerminatorIdx;
            }
        }
        catch (IndexOutOfBoundsException exp) {
            logger.debug(exp.toString(), (Throwable)exp);
            throw new InvalidMessageException(exp.getMessage(), exp);
        }
        try {
            this.fileName = new String(inbuf, offset, firstTerminatorIdx - offset, "UTF-8");
        }
        catch (UnsupportedEncodingException exp) {
            logger.error(exp.toString(), (Throwable)exp);
            throw new RuntimeException(exp);
        }
        int secondTerminatorIdx = firstTerminatorIdx + 1;
        try {
            while (inbuf[secondTerminatorIdx] != 0) {
                ++secondTerminatorIdx;
            }
        }
        catch (IndexOutOfBoundsException exp) {
            logger.debug(exp.toString(), (Throwable)exp);
            throw new InvalidMessageException(exp.getMessage(), exp);
        }
        byte[] extensionArea = new byte[secondTerminatorIdx - firstTerminatorIdx - 1];
        System.arraycopy(inbuf, firstTerminatorIdx + 1, extensionArea, 0, secondTerminatorIdx - firstTerminatorIdx - 1);
        this.parseExtensionArea(extensionArea, securityService);
        offset = secondTerminatorIdx + 1;
        return offset;
    }

    private void parseExtensionArea(byte[] extensionArea, PhexSecurityManager securityService) throws InvalidMessageException {
        try {
            PushbackInputStream inStream = new PushbackInputStream(new ByteArrayInputStream(extensionArea));
            StringBuffer buffer = new StringBuffer();
            GGEPBlock[] ggepBlocks = null;
            GGEPBlock ggepBlock = null;
            while (true) {
                byte b;
                if ((b = (byte)inStream.read()) == -1) break;
                if (b == -61 && buffer.length() == 0) {
                    inStream.unread(b);
                    try {
                        ggepBlocks = GGEPBlock.parseGGEPBlocks(inStream);
                        ggepBlock = GGEPBlock.mergeGGEPBlocks(ggepBlocks);
                    }
                    catch (InvalidGGEPBlockException exp) {
                        logger.error(exp.toString(), (Throwable)exp);
                    }
                    continue;
                }
                if (b == 28) {
                    this.evaluateExtensionToken(buffer.toString());
                    buffer.setLength(0);
                    continue;
                }
                buffer.append((char)b);
            }
            this.evaluateExtensionToken(buffer.toString());
            if (ggepBlocks != null) {
                this.alternateLocations = GGEPExtension.parseAltExtensionData(ggepBlocks, securityService);
                if (this.alternateLocations != null && this.alternateLocations.length > 20) {
                    throw new InvalidMessageException("Number of query response record alt-locs exceed the acceptable maximum: " + this.alternateLocations.length + "/" + 20);
                }
                byte[] pathInfoArr = GGEPBlock.getExtensionDataInBlocks(ggepBlocks, "PATH");
                if (pathInfoArr != null) {
                    this.pathInfo = new String(pathInfoArr);
                }
                this.creationTime = ggepBlock.getLongExtensionData("CT", -1L) * 1000L;
                if (ggepBlock.isExtensionAvailable("LF")) {
                    long tmpFileSize = ggepBlock.getLongExtensionData("LF", -1L);
                    if (tmpFileSize < 0L) {
                        throw new InvalidMessageException("Invalid file size: " + tmpFileSize);
                    }
                    this.fileSize = tmpFileSize;
                }
            }
        }
        catch (IOException exp) {
            logger.error(exp.toString(), (Throwable)exp);
        }
    }

    private void evaluateExtensionToken(String extension) {
        if (URN.isValidURN(extension)) {
            this.urn = new URN(extension);
        } else if (this.metaData == null || this.metaData.length() == 0) {
            this.metaData = this.parseMetaData(extension);
        }
    }

    public String toString() {
        return "[FileIndex=" + this.fileIndex + ", " + "FileSize=" + this.fileSize + ", " + "Filename=" + this.fileName + "]";
    }

    private String parseMetaData(String metaDataString) {
        StringTokenizer tokenizer = new StringTokenizer(metaDataString);
        if (tokenizer.countTokens() < 2) {
            return "";
        }
        String first = tokenizer.nextToken();
        String second = tokenizer.nextToken();
        String length = "";
        String frequency = "";
        String bitrate = "";
        boolean isVBR = false;
        boolean bearShare1 = false;
        boolean bearShare2 = false;
        boolean gnotella = false;
        if (second.toLowerCase().startsWith("kbps")) {
            bearShare1 = true;
            if (second.indexOf("VBR") > 0) {
                isVBR = true;
            }
        } else if (first.toLowerCase().endsWith("kbps")) {
            bearShare2 = true;
        }
        if (bearShare1) {
            bitrate = first;
        } else if (bearShare2) {
            int j = first.toLowerCase().indexOf("kbps");
            bitrate = first.substring(0, j);
        }
        if (bearShare1 || bearShare2) {
            String prev = "";
            String token = "";
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if (token.startsWith("kHz")) {
                    frequency = prev;
                }
                prev = token;
            }
            length = token;
        } else if (metaDataString.endsWith("kHz")) {
            gnotella = true;
            length = first;
            int i = second.indexOf("kbps");
            if (i > -1) {
                bitrate = second.substring(0, i);
            } else {
                gnotella = false;
            }
        }
        if (bearShare1 || bearShare2 || gnotella) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(bitrate);
            buffer.append("Kbps");
            if (isVBR) {
                buffer.append("(VBR)");
            }
            buffer.append(" - ");
            if (frequency != null && frequency.length() > 0) {
                buffer.append(frequency);
                buffer.append("kHz");
                buffer.append(" - ");
            }
            buffer.append(length);
            return buffer.toString();
        }
        return "";
    }
}

