/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import phex.io.buffer.ByteBuffer;
import phex.msg.InvalidMessageException;
import phex.msg.MsgHeader;
import phex.msg.RouteTableUpdateMsg;

public class QRPatchTableMsg
extends RouteTableUpdateMsg {
    public static final byte COMPRESSOR_NONE = 0;
    public static final byte COMPRESSOR_ZLIB = 1;
    public static final int MAX_MESSAGE_DATA_SIZE = 4096;
    private byte sequenceNumber;
    private byte sequenceSize;
    private byte compressor;
    private byte entryBits;
    private byte[] data;
    private int dataOffset;
    private int dataLength;

    public QRPatchTableMsg(byte aSequenceNumber, byte aSequenceSize, byte aCompressor, byte aEntryBits, byte[] aData, int aDataOffset, int aDataLength) {
        super((byte)1, 5 + aDataLength);
        this.sequenceNumber = aSequenceNumber;
        this.sequenceSize = aSequenceSize;
        this.compressor = aCompressor;
        this.entryBits = aEntryBits;
        this.data = aData;
        this.dataOffset = aDataOffset;
        this.dataLength = aDataLength;
    }

    public QRPatchTableMsg(MsgHeader header, byte[] aBody) throws InvalidMessageException {
        super((byte)1, header);
        header.setDataLength(aBody.length);
        this.sequenceNumber = aBody[1];
        this.sequenceSize = aBody[2];
        if (this.sequenceNumber == 0 || this.sequenceSize == 0 || this.sequenceNumber > this.sequenceSize) {
            throw new InvalidMessageException("Invalid sequence number or size: " + this.sequenceNumber + "/" + this.sequenceSize);
        }
        this.compressor = aBody[3];
        if (this.compressor != 0 && this.compressor != 1) {
            throw new InvalidMessageException("Invalid compressor type: " + this.compressor);
        }
        this.entryBits = aBody[4];
        this.dataOffset = 0;
        this.dataLength = aBody.length - 5;
        this.data = new byte[this.dataLength];
        System.arraycopy(aBody, 5, this.data, 0, this.dataLength);
    }

    public byte getSequenceNumber() {
        return this.sequenceNumber;
    }

    public byte getSequenceSize() {
        return this.sequenceSize;
    }

    public byte getCompressor() {
        return this.compressor;
    }

    public byte getEntryBits() {
        return this.entryBits;
    }

    public byte[] getPatchData() {
        return this.data;
    }

    public ByteBuffer createMessageBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(this.dataLength + 5);
        buffer.put(this.variant).put(this.sequenceNumber).put(this.sequenceSize).put(this.compressor).put(this.entryBits).put(this.data, this.dataOffset, this.dataLength);
        buffer.rewind();
        return buffer;
    }
}

