/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DataFormatException;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.log.NLogger;
import phex.msg.InvalidGGEPBlockException;
import phex.utils.HexConverter;
import phex.utils.IOUtil;

public class GGEPBlock {
    public static final byte MAGIC_NUMBER = -61;
    public static final String BROWSE_HOST_HEADER_ID = "BH";
    public static final String ALTERNATE_LOCATIONS_HEADER_ID = "ALT";
    public static final String AVARAGE_DAILY_UPTIME = "DU";
    public static final String ULTRAPEER_ID = "UP";
    public static final String VENDOR_CODE_ID = "VC";
    public static final String PATH_INFO_HEADER_ID = "PATH";
    public static final String PUSH_PROXY_HEADER_ID = "PUSH";
    public static final String UDP_HOST_CACHE_UDPHC = "UDPHC";
    public static final String UDP_HOST_CACHE_IPP = "IPP";
    public static final String UDP_HOST_CACHE_SCP = "SCP";
    public static final String UDP_HOST_CACHE_PHC = "PHC";
    public static final String PHEX_EXTENDED_DESTINATION = "PHEX.EXDST";
    public static final String PHEX_EXTENDED_ORIGIN = "PHEX.EXORG";
    public static final String FEATURE_QUERY_HEADER_ID = "WH";
    public static final String CREATION_TIME_HEADER_ID = "CT";
    public static final String SECURE_OOB_ID = "SO";
    public static final String LARGE_FILE_HEADER_ID = "LF";
    private HashMap<String, byte[]> headerToDataMap;
    private boolean needsCobsFor0x00Byte;
    private static byte[] browseHostGGEPBlock;

    public GGEPBlock(boolean needsCobsFor0x00) {
        this.needsCobsFor0x00Byte = needsCobsFor0x00;
        this.headerToDataMap = new HashMap(3);
    }

    public GGEPBlock() {
        this(true);
    }

    public void debugDump() {
        System.out.println("--------------------------------------");
        for (String key : this.headerToDataMap.keySet()) {
            System.out.println(key + " = " + this.headerToDataMap.get(key));
        }
        System.out.println("--------------------------------------");
    }

    public void addExtension(String header) {
        this.addExtension(header, "".getBytes());
    }

    public void addExtension(String header, byte[] data) {
        this.headerToDataMap.put(header, data);
    }

    public void addExtension(String header, int value) {
        this.addExtension(header, IOUtil.serializeInt2MinLE(value));
    }

    public void addExtension(String header, long value) {
        this.addExtension(header, IOUtil.serializeLong2MinLE(value));
    }

    public void addExtension(String header, DestAddress[] addresses, int maxAmount) {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            int count = Math.min(addresses.length, maxAmount);
            for (int i = 0; i < count; ++i) {
                IpAddress ip = addresses[i].getIpAddress();
                if (ip == null) continue;
                outStream.write(ip.getHostIP());
                IOUtil.serializeShortLE((short)addresses[i].getPort(), outStream);
            }
            if (outStream.size() > 0) {
                this.addExtension(header, outStream.toByteArray());
            }
        }
        catch (IOException exp) {
            NLogger.error(GGEPBlock.class, exp, exp);
        }
    }

    public void addAllExtensions(GGEPBlock block) {
        this.headerToDataMap.putAll(block.headerToDataMap);
    }

    public byte[] getExtensionData(String header) {
        return this.headerToDataMap.get(header);
    }

    public long getLongExtensionData(String header, long defaultValue) {
        byte[] data = this.getExtensionData(header);
        if (data == null || data.length < 1 || data.length > 8) {
            return defaultValue;
        }
        return IOUtil.deserializeLongLE(data, 0, data.length);
    }

    public byte getByteExtensionData(String header, byte defaultValue) {
        byte[] data = this.getExtensionData(header);
        if (data == null || data.length != 1) {
            return defaultValue;
        }
        return data[0];
    }

    private int checkIfCompressed(String header, int headerFlags) {
        if (header.equals(UDP_HOST_CACHE_PHC)) {
            headerFlags |= 0x20;
        }
        return headerFlags;
    }

    private boolean checkIfNeedsCobsEncoding(byte[] data) {
        return this.needsCobsFor0x00Byte && this.contains0x00Byte(data);
    }

    private boolean contains0x00Byte(byte[] bytes) {
        if (bytes != null) {
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 0) continue;
                return true;
            }
        }
        return false;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(30);
        outStream.write(-61);
        Iterator<String> iterator = this.headerToDataMap.keySet().iterator();
        while (iterator.hasNext()) {
            String headerKey = iterator.next();
            byte[] dataBytes = this.headerToDataMap.get(headerKey);
            int headerFlags = 0;
            headerFlags = this.checkIfCompressed(headerKey, headerFlags);
            boolean needsCobsEncoding = this.checkIfNeedsCobsEncoding(dataBytes);
            if (needsCobsEncoding) {
                headerFlags |= 0x40;
                dataBytes = IOUtil.cobsEncode(dataBytes);
            }
            if (!iterator.hasNext()) {
                headerFlags |= 0x80;
            }
            byte[] headerBytes = headerKey.getBytes();
            outStream.write(headerFlags |= headerBytes.length);
            try {
                outStream.write(headerBytes);
            }
            catch (IOException exp) {
                assert (false) : "Exception occured which should never happen.";
                throw new RuntimeException(exp);
            }
            int dataLength = dataBytes.length;
            int tmp = dataLength & 0x3F000;
            if (tmp != 0) {
                tmp >>= 12;
                tmp = 0x80 | tmp;
                outStream.write(tmp);
            }
            if ((tmp = dataLength & 0xFC0) != 0) {
                tmp >>= 6;
                tmp = 0x80 | tmp;
                outStream.write(tmp);
            }
            tmp = dataLength & 0x3F;
            tmp = 0x40 | tmp;
            outStream.write(tmp);
            if (dataLength <= 0) continue;
            try {
                outStream.write(dataBytes);
            }
            catch (IOException exp) {
                assert (false) : "Exception occured which should never happen.";
                throw new RuntimeException(exp);
            }
        }
        return outStream.toByteArray();
    }

    public boolean isExtensionAvailable(String headerID) {
        return this.headerToDataMap.containsKey(headerID);
    }

    public static byte[] getQueryReplyGGEPBlock(boolean isBrowseHostSupported, DestAddress[] pushProxyAddresses) {
        if (pushProxyAddresses != null && pushProxyAddresses.length > 0) {
            GGEPBlock ggepBlock = new GGEPBlock(true);
            if (isBrowseHostSupported) {
                ggepBlock.addExtension(BROWSE_HOST_HEADER_ID);
            }
            ggepBlock.addExtension(PUSH_PROXY_HEADER_ID, pushProxyAddresses, 4);
            byte[] data = ggepBlock.getBytes();
            return data;
        }
        if (isBrowseHostSupported) {
            if (browseHostGGEPBlock == null) {
                GGEPBlock ggepBlock = new GGEPBlock(true);
                ggepBlock.addExtension(BROWSE_HOST_HEADER_ID);
                browseHostGGEPBlock = ggepBlock.getBytes();
            }
            return browseHostGGEPBlock;
        }
        return IOUtil.EMPTY_BYTE_ARRAY;
    }

    public static byte[] getQueryReplyRecordGGEPBlock(long creationTime, DestAddress[] alternateLocations, long fileSize) {
        if (creationTime > 0L || alternateLocations != null && alternateLocations.length > 0 || fileSize > Integer.MAX_VALUE) {
            GGEPBlock ggepBlock = new GGEPBlock(true);
            if (creationTime > 0L) {
                ggepBlock.addExtension(CREATION_TIME_HEADER_ID, creationTime / 1000L);
            }
            if (alternateLocations != null && alternateLocations.length > 0) {
                ggepBlock.addExtension(ALTERNATE_LOCATIONS_HEADER_ID, alternateLocations, 10);
            }
            if (fileSize > Integer.MAX_VALUE) {
                ggepBlock.addExtension(LARGE_FILE_HEADER_ID, fileSize);
            }
            byte[] data = ggepBlock.getBytes();
            return data;
        }
        return IOUtil.EMPTY_BYTE_ARRAY;
    }

    public static boolean isExtensionHeaderInBlocks(GGEPBlock[] ggepBlocks, String headerID) {
        for (int i = 0; i < ggepBlocks.length; ++i) {
            if (!ggepBlocks[i].isExtensionAvailable(headerID)) continue;
            return true;
        }
        return false;
    }

    public static byte[] getExtensionDataInBlocks(GGEPBlock[] ggepBlocks, String headerID) {
        for (int i = 0; i < ggepBlocks.length; ++i) {
            if (!ggepBlocks[i].isExtensionAvailable(headerID)) continue;
            return ggepBlocks[i].getExtensionData(headerID);
        }
        return null;
    }

    public static GGEPBlock mergeGGEPBlocks(GGEPBlock[] ggepBlocks) {
        GGEPBlock mergedBlock = new GGEPBlock();
        for (int i = 0; i < ggepBlocks.length; ++i) {
            mergedBlock.addAllExtensions(ggepBlocks[i]);
        }
        return mergedBlock;
    }

    public static GGEPBlock[] parseGGEPBlocks(byte[] body, int offset) {
        GGEPParser parser = new GGEPParser();
        return parser.parseGGEPBlocks(body, offset);
    }

    public static GGEPBlock[] parseGGEPBlocks(PushbackInputStream inStream) throws InvalidGGEPBlockException, IOException {
        GGEPParser parser = new GGEPParser();
        return parser.parseGGEPBlocks(inStream);
    }

    public static void debugDumpBlocks(GGEPBlock[] ggepBlocks) {
        for (int i = 0; i < ggepBlocks.length; ++i) {
            ggepBlocks[i].debugDump();
        }
    }

    private static class GGEPParser {
        private int offset;
        private List<GGEPBlock> ggepList = new ArrayList<GGEPBlock>(3);

        public GGEPBlock[] parseGGEPBlocks(PushbackInputStream inStream) throws InvalidGGEPBlockException, IOException {
            byte b;
            while ((b = (byte)inStream.read()) != -1) {
                if (b != -61) {
                    inStream.unread(b);
                    break;
                }
                this.ggepList.add(this.parseGGEPBlock(inStream));
            }
            GGEPBlock[] ggepArray = new GGEPBlock[this.ggepList.size()];
            this.ggepList.toArray(ggepArray);
            return ggepArray;
        }

        private GGEPBlock parseGGEPBlock(InputStream inStream) throws InvalidGGEPBlockException, IOException {
            GGEPBlock ggepBlock = new GGEPBlock();
            boolean isLastExtension = false;
            while (!isLastExtension) {
                int b = inStream.read();
                if ((b & 0x10) != 0) {
                    throw new InvalidGGEPBlockException();
                }
                isLastExtension = (b & 0x80) != 0;
                boolean isEncoded = (b & 0x40) != 0;
                boolean isCompressed = (b & 0x20) != 0;
                short headerLength = (short)(b & 0xF);
                if (headerLength == 0) {
                    throw new InvalidGGEPBlockException();
                }
                byte[] headerData = new byte[headerLength];
                inStream.read(headerData, 0, headerLength);
                String header = new String(headerData, 0, (int)headerLength);
                int dataLength = this.parseDataLength(inStream);
                byte[] dataArr = null;
                try {
                    if (dataLength > 0) {
                        dataArr = new byte[dataLength];
                        inStream.read(dataArr, 0, dataLength);
                        if (isCompressed) {
                            dataArr = IOUtil.inflate(dataArr);
                        }
                        if (isEncoded) {
                            try {
                                dataArr = IOUtil.cobsDecode(dataArr);
                            }
                            catch (IOException exp) {
                                dataArr = null;
                            }
                        }
                    } else {
                        dataArr = new byte[]{};
                    }
                    if (dataArr == null) continue;
                    ggepBlock.addExtension(header, dataArr);
                }
                catch (DataFormatException exp) {
                    if (!NLogger.isWarnEnabled(GGEPBlock.class)) continue;
                    NLogger.warn(GGEPBlock.class, "Invalid GGEP data format. Header: '" + header + "' Data: '" + HexConverter.toHexString(dataArr) + "'.", exp);
                }
            }
            return ggepBlock;
        }

        private int parseDataLength(InputStream inStream) throws InvalidGGEPBlockException, IOException {
            byte currentByte;
            int length = 0;
            int byteCount = 0;
            do {
                if (++byteCount > 3) {
                    throw new InvalidGGEPBlockException();
                }
                currentByte = (byte)inStream.read();
                length = length << 6 | currentByte & 0x3F;
            } while (64 != (currentByte & 0x40));
            return length;
        }

        public GGEPBlock[] parseGGEPBlocks(byte[] body, int aOffset) {
            this.offset = aOffset;
            try {
                while (body.length > this.offset && body[this.offset] == -61) {
                    ++this.offset;
                    this.ggepList.add(this.parseGGEPBlock(body));
                }
            }
            catch (InvalidGGEPBlockException exp) {
                NLogger.debug(GGEPBlock.class, exp, exp);
            }
            GGEPBlock[] ggepArray = new GGEPBlock[this.ggepList.size()];
            this.ggepList.toArray(ggepArray);
            return ggepArray;
        }

        private GGEPBlock parseGGEPBlock(byte[] body) throws InvalidGGEPBlockException {
            GGEPBlock ggepBlock = new GGEPBlock();
            boolean isLastExtension = false;
            while (!isLastExtension) {
                boolean isReserved;
                if (body.length > this.offset && (body[this.offset] & 0x10) != 0) {
                    throw new InvalidGGEPBlockException();
                }
                isLastExtension = (body[this.offset] & 0x80) != 0;
                boolean isEncoded = (body[this.offset] & 0x40) != 0;
                boolean isCompressed = (body[this.offset] & 0x20) != 0;
                boolean bl = isReserved = (body[this.offset] & 0x10) != 0;
                if (isReserved) {
                    throw new InvalidGGEPBlockException("Reserved bit set to 1");
                }
                short headerLength = (short)(body[this.offset] & 0xF);
                if (headerLength == 0) {
                    throw new InvalidGGEPBlockException();
                }
                ++this.offset;
                String header = new String(body, this.offset, (int)headerLength);
                this.offset += headerLength;
                int dataLength = this.parseDataLength(body);
                byte[] dataArr = null;
                try {
                    if (dataLength > 0) {
                        dataArr = new byte[dataLength];
                        try {
                            System.arraycopy(body, this.offset, dataArr, 0, dataLength);
                        }
                        catch (IndexOutOfBoundsException exp) {
                            if (NLogger.isDebugEnabled(GGEPBlock.class)) {
                                NLogger.warn(GGEPBlock.class, exp, exp);
                                NLogger.warn(GGEPBlock.class, "Offset: " + this.offset + "- Buffer: " + HexConverter.toHexString(body));
                            }
                            throw new InvalidGGEPBlockException(exp);
                        }
                        this.offset += dataLength;
                        if (isCompressed) {
                            dataArr = IOUtil.inflate(dataArr);
                        }
                        if (isEncoded) {
                            try {
                                dataArr = IOUtil.cobsDecode(dataArr);
                            }
                            catch (IOException exp) {
                                dataArr = null;
                            }
                        }
                    } else {
                        dataArr = new byte[]{};
                    }
                    if (dataArr == null) continue;
                    ggepBlock.addExtension(header, dataArr);
                }
                catch (DataFormatException exp) {
                    if (!NLogger.isWarnEnabled(GGEPBlock.class)) continue;
                    NLogger.warn(GGEPBlock.class, "Invalid GGEP data format. Header: '" + header + "' Data: '" + HexConverter.toHexString(dataArr) + "'.", exp);
                    NLogger.warn(GGEPBlock.class, "Offset: " + this.offset + "- Buffer: " + HexConverter.toHexString(body));
                }
            }
            return ggepBlock;
        }

        private int parseDataLength(byte[] body) throws InvalidGGEPBlockException {
            byte currentByte;
            int length = 0;
            int byteCount = 0;
            do {
                if (++byteCount > 3) {
                    throw new InvalidGGEPBlockException();
                }
                currentByte = body[this.offset];
                ++this.offset;
                length = length << 6 | currentByte & 0x3F;
            } while (64 != (currentByte & 0x40));
            return length;
        }
    }
}

