/*
 * Decompiled with CFR 0.152.
 */
package phex.io.buffer;

import java.nio.BufferUnderflowException;
import java.nio.CharBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import phex.utils.HexConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteBuffer
implements Comparable<ByteBuffer> {
    private java.nio.ByteBuffer buf;

    protected ByteBuffer(java.nio.ByteBuffer buf) {
        this.buf = buf;
    }

    public ByteBuffer putIntLE(int value) {
        this.put((byte)(value >> 0));
        this.put((byte)(value >> 8));
        this.put((byte)(value >> 16));
        this.put((byte)(value >> 24));
        return this;
    }

    public ByteBuffer putShortLE(short value) {
        this.put((byte)(value >> 0));
        this.put((byte)(value >> 8));
        return this;
    }

    public boolean readLine(StringBuilder strBuf) {
        int c = -1;
        block4: while (this.hasRemaining()) {
            c = this.get();
            switch (c) {
                case 10: {
                    return true;
                }
                case 13: {
                    continue block4;
                }
            }
            strBuf.append((char)c);
        }
        return false;
    }

    public String getString(CharsetDecoder decoder) throws CharacterCodingException {
        CoderResult cr;
        int newPos;
        if (!this.hasRemaining()) {
            return "";
        }
        boolean utf16 = decoder.charset().name().startsWith("UTF-16");
        int oldPos = this.position();
        int oldLimit = this.limit();
        int end = -1;
        if (!utf16) {
            end = this.indexOf((byte)0);
            newPos = end < 0 ? (end = oldLimit) : end + 1;
        } else {
            block8: {
                int i = oldPos;
                while (true) {
                    boolean wasZero;
                    boolean bl = wasZero = this.get(i) == 0;
                    if (++i >= oldLimit) break block8;
                    if (this.get(i) != 0) {
                        if (++i < oldLimit) continue;
                        break block8;
                    }
                    if (wasZero) break;
                }
                end = i - 1;
            }
            newPos = end < 0 ? (end = oldPos + (oldLimit - oldPos & 0xFFFFFFFE)) : (end + 2 <= oldLimit ? end + 2 : end);
        }
        if (oldPos == end) {
            this.position(newPos);
            return "";
        }
        this.limit(end);
        decoder.reset();
        int expectedLength = (int)((float)this.remaining() * decoder.averageCharsPerByte()) + 1;
        CharBuffer out = CharBuffer.allocate(expectedLength);
        while (!(cr = this.hasRemaining() ? decoder.decode(this.internalBuffer(), out, true) : decoder.flush(out)).isUnderflow()) {
            if (cr.isOverflow()) {
                CharBuffer o = CharBuffer.allocate(out.capacity() + expectedLength);
                out.flip();
                o.put(out);
                out = o;
                continue;
            }
            if (!cr.isError()) continue;
            this.limit(oldLimit);
            this.position(oldPos);
            cr.throwException();
        }
        this.limit(oldLimit);
        this.position(newPos);
        return out.flip().toString();
    }

    public String getString(int fieldSize, CharsetDecoder decoder) throws CharacterCodingException {
        CoderResult cr;
        int i;
        int end;
        if (fieldSize < 0) {
            throw new IllegalArgumentException("fieldSize cannot be negative: " + fieldSize);
        }
        if (fieldSize == 0) {
            return "";
        }
        if (!this.hasRemaining()) {
            return "";
        }
        boolean utf16 = decoder.charset().name().startsWith("UTF-16");
        if (utf16 && (fieldSize & 1) != 0) {
            throw new IllegalArgumentException("fieldSize is not even.");
        }
        int oldPos = this.position();
        int oldLimit = this.limit();
        if (oldLimit < (end = oldPos + fieldSize)) {
            throw new BufferUnderflowException();
        }
        if (!utf16) {
            for (i = oldPos; i < end && this.get(i) != 0; ++i) {
            }
            if (i == end) {
                this.limit(end);
            } else {
                this.limit(i);
            }
        } else {
            for (i = oldPos; i < end && (this.get(i) != 0 || this.get(i + 1) != 0); i += 2) {
            }
            if (i == end) {
                this.limit(end);
            } else {
                this.limit(i);
            }
        }
        if (!this.hasRemaining()) {
            this.limit(oldLimit);
            this.position(end);
            return "";
        }
        decoder.reset();
        int expectedLength = (int)((float)this.remaining() * decoder.averageCharsPerByte()) + 1;
        CharBuffer out = CharBuffer.allocate(expectedLength);
        while (!(cr = this.hasRemaining() ? decoder.decode(this.internalBuffer(), out, true) : decoder.flush(out)).isUnderflow()) {
            if (cr.isOverflow()) {
                CharBuffer o = CharBuffer.allocate(out.capacity() + expectedLength);
                out.flip();
                o.put(out);
                out = o;
                continue;
            }
            if (!cr.isError()) continue;
            this.limit(oldLimit);
            this.position(oldPos);
            cr.throwException();
        }
        this.limit(oldLimit);
        this.position(end);
        return out.flip().toString();
    }

    public int indexOf(byte b) {
        if (this.hasArray()) {
            int arrayOffset = this.arrayOffset();
            int beginPos = arrayOffset + this.position();
            int limit = arrayOffset + this.limit();
            byte[] array = this.array();
            for (int i = beginPos; i < limit; ++i) {
                if (array[i] != b) continue;
                return i - arrayOffset;
            }
        } else {
            int beginPos = this.position();
            int limit = this.limit();
            for (int i = beginPos; i < limit; ++i) {
                if (this.get(i) != b) continue;
                return i;
            }
        }
        return -1;
    }

    public ByteBuffer skip(int size) {
        return this.position(this.position() + size);
    }

    public java.nio.ByteBuffer internalBuffer() {
        return this.buf;
    }

    public String getHexDump() {
        return this.getHexDump(Integer.MAX_VALUE);
    }

    public String getHexDump(int lengthLimit) {
        return HexConverter.toHexString(this, lengthLimit);
    }

    public String toString() {
        StringBuffer sBuf = new StringBuffer();
        if (this.isDirect()) {
            sBuf.append("DirectBuffer");
        } else {
            sBuf.append("HeapBuffer");
        }
        sBuf.append("[pos=");
        sBuf.append(this.position());
        sBuf.append(" lim=");
        sBuf.append(this.limit());
        sBuf.append(" cap=");
        sBuf.append(this.capacity());
        sBuf.append(": ");
        sBuf.append(this.getHexDump(16));
        sBuf.append(']');
        return sBuf.toString();
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer that = (ByteBuffer)o;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int i = this.limit() - 1;
        int j = that.limit() - 1;
        while (i >= p) {
            byte v2;
            byte v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    @Override
    public int compareTo(ByteBuffer that) {
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            byte v2;
            byte v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    public byte[] array() {
        return this.buf.array();
    }

    public int arrayOffset() {
        return this.buf.arrayOffset();
    }

    public ByteBuffer asReadOnlyBuffer() {
        return new ByteBuffer(this.buf.asReadOnlyBuffer());
    }

    public ShortBuffer asShortBuffer() {
        return this.buf.asShortBuffer();
    }

    public int capacity() {
        return this.buf.capacity();
    }

    public ByteBuffer clear() {
        this.buf.clear();
        return this;
    }

    public ByteBuffer compact() {
        this.buf.compact();
        return this;
    }

    public ByteBuffer duplicate() {
        return new ByteBuffer(this.buf.duplicate());
    }

    public ByteBuffer flip() {
        this.buf.flip();
        return this;
    }

    public byte get() {
        return this.buf.get();
    }

    public ByteBuffer get(byte[] dst, int offset, int length) {
        this.buf.get(dst, offset, length);
        return this;
    }

    public ByteBuffer get(byte[] dst) {
        this.buf.get(dst);
        return this;
    }

    public byte get(int index) {
        return this.buf.get(index);
    }

    public boolean hasArray() {
        return this.buf.hasArray();
    }

    public boolean hasRemaining() {
        return this.buf.hasRemaining();
    }

    public boolean isDirect() {
        return this.buf.isDirect();
    }

    public boolean isReadOnly() {
        return this.buf.isReadOnly();
    }

    public int limit() {
        return this.buf.limit();
    }

    public ByteBuffer limit(int newLimit) {
        this.buf.limit(newLimit);
        return this;
    }

    public ByteBuffer mark() {
        this.buf.mark();
        return this;
    }

    public int position() {
        return this.buf.position();
    }

    public ByteBuffer position(int newPosition) {
        this.buf.position(newPosition);
        return this;
    }

    public ByteBuffer put(byte b) {
        this.buf.put(b);
        return this;
    }

    public ByteBuffer put(byte[] src) {
        this.buf.put(src);
        return this;
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        this.buf.put(src, offset, length);
        return this;
    }

    public ByteBuffer put(ByteBuffer src) {
        this.buf.put(src.buf);
        return this;
    }

    public ByteBuffer put(int index, byte b) {
        this.buf.put(index, b);
        return this;
    }

    public int remaining() {
        return this.buf.remaining();
    }

    public ByteBuffer reset() {
        this.buf.reset();
        return this;
    }

    public ByteBuffer rewind() {
        this.buf.rewind();
        return this;
    }

    public ByteBuffer slice() {
        return new ByteBuffer(this.buf.slice());
    }

    public static ByteBuffer allocate(int capacity) {
        java.nio.ByteBuffer nioBuffer = java.nio.ByteBuffer.allocate(capacity);
        return new ByteBuffer(nioBuffer);
    }

    public static ByteBuffer wrap(byte[] byteArray) {
        return ByteBuffer.wrap(java.nio.ByteBuffer.wrap(byteArray));
    }

    public static ByteBuffer wrap(byte[] byteArray, int offset, int length) {
        return ByteBuffer.wrap(java.nio.ByteBuffer.wrap(byteArray, offset, length));
    }

    public static ByteBuffer wrap(java.nio.ByteBuffer nioBuffer) {
        return new ByteBuffer(nioBuffer);
    }
}

