/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.AbstractLifeCycle;
import phex.common.address.DestAddress;
import phex.connection.ConnectionObserver;
import phex.event.ChangeEvent;
import phex.event.ContainerEvent;
import phex.host.Host;
import phex.host.HostStatus;
import phex.prefs.core.ConnectionPrefs;
import phex.servent.OnlineStatus;
import phex.servent.Servent;
import phex.utils.Localizer;

public final class NetworkHostsContainer
extends AbstractLifeCycle {
    private Servent servent;
    private final List<Host> networkHosts;
    private final List<Host> ultrapeerConnections;
    private int leafUltrapeerConnectionCount;
    private final List<Host> leafConnections;

    public NetworkHostsContainer(Servent servent) {
        this.servent = servent;
        this.networkHosts = new ArrayList<Host>();
        this.ultrapeerConnections = new ArrayList<Host>();
        this.leafConnections = new ArrayList<Host>();
        servent.getEventService().processAnnotations(this);
    }

    protected void doStart() {
        ConnectionObserver observer = new ConnectionObserver(this, this.servent.getMessageService());
        observer.start();
    }

    public synchronized boolean isShieldedLeafNode() {
        return this.leafUltrapeerConnectionCount > 0;
    }

    public synchronized boolean hasLeafConnections() {
        return !this.leafConnections.isEmpty();
    }

    public synchronized boolean hasUltrapeerConnections() {
        return !this.ultrapeerConnections.isEmpty();
    }

    public boolean hasUltrapeerSlotsAvailable() {
        return this.ultrapeerConnections.size() < ConnectionPrefs.Up2UpConnections.get();
    }

    public int getOpenUltrapeerSlotsCount() {
        return ConnectionPrefs.Up2UpConnections.get() - this.ultrapeerConnections.size();
    }

    public boolean hasLeafSlotForUltrapeerAvailable() {
        return this.hasLeafSlotsAvailable() && this.ultrapeerConnections.size() < ConnectionPrefs.Up2UpConnections.get() + 1;
    }

    public boolean hasLeafSlotsAvailable() {
        return this.leafConnections.size() < ConnectionPrefs.Up2LeafConnections.get();
    }

    public int getOpenLeafSlotsCount() {
        if (this.servent.isUltrapeer()) {
            return ConnectionPrefs.Up2LeafConnections.get() - this.leafConnections.size();
        }
        return 0;
    }

    public synchronized Host[] getNetworkHosts() {
        Host[] hosts = new Host[this.networkHosts.size()];
        this.networkHosts.toArray(hosts);
        return hosts;
    }

    public synchronized Host[] getUltrapeerConnections() {
        Host[] hosts = new Host[this.ultrapeerConnections.size()];
        this.ultrapeerConnections.toArray(hosts);
        return hosts;
    }

    public synchronized Host[] getLeafConnections() {
        Host[] hosts = new Host[this.leafConnections.size()];
        this.leafConnections.toArray(hosts);
        return hosts;
    }

    public synchronized int getTotalConnectionCount() {
        return this.ultrapeerConnections.size() + this.leafConnections.size();
    }

    public synchronized int getLeafConnectionCount() {
        return this.leafConnections.size();
    }

    public synchronized int getUltrapeerConnectionCount() {
        return this.ultrapeerConnections.size();
    }

    public DestAddress[] getPushProxies() {
        if (this.isShieldedLeafNode()) {
            HashSet<DestAddress> pushProxies = new HashSet<DestAddress>();
            for (Host host : this.ultrapeerConnections) {
                DestAddress pushProxyAddress = host.getPushProxyAddress();
                if (pushProxyAddress == null) continue;
                pushProxies.add(pushProxyAddress);
                if (pushProxies.size() != 4) continue;
                break;
            }
            DestAddress[] addresses = new DestAddress[pushProxies.size()];
            pushProxies.toArray(addresses);
            return addresses;
        }
        return null;
    }

    public synchronized void addIncomingHost(Host host) {
        this.addNetworkHost(host);
        this.addConnectedHost(host);
    }

    public synchronized void addConnectedHost(Host host) {
        if (!this.networkHosts.contains(host)) {
            host.disconnect();
            return;
        }
        if (host.isUltrapeer()) {
            this.ultrapeerConnections.add(host);
            if (host.isLeafUltrapeerConnection()) {
                ++this.leafUltrapeerConnectionCount;
            }
        } else if (host.isUltrapeerLeafConnection()) {
            this.leafConnections.add(host);
        } else assert (false) : "Peer connections should not be used anymore";
    }

    @Deprecated
    public synchronized void disconnectHost(Host host) {
        if (host == null) {
            return;
        }
        if (host.isUltrapeer()) {
            boolean isRemoved = this.ultrapeerConnections.remove(host);
            if (isRemoved && host.isLeafUltrapeerConnection()) {
                --this.leafUltrapeerConnectionCount;
            }
        } else if (host.isUltrapeerLeafConnection()) {
            this.leafConnections.remove(host);
        }
        this.servent.getMessageService().removeRoutings(host);
        this.servent.getQueryService().removeHostQueries(host);
    }

    public synchronized void periodicallyCheckHosts() {
        long currentTime = System.currentTimeMillis();
        Host[] badHosts = new Host[this.networkHosts.size()];
        int badHostsPos = 0;
        for (Host host : this.networkHosts) {
            HostStatus status = host.getStatus();
            if (status != HostStatus.CONNECTED) continue;
            String policyInfraction = null;
            if (host.isSendQueueTooLong()) {
                policyInfraction = Localizer.getString("SendQueueTooLong");
            } else if (host.isNoVendorDisconnectApplying()) {
                policyInfraction = Localizer.getString("NoVendorString");
            }
            if (policyInfraction == null) continue;
            host.setStatus(HostStatus.ERROR, policyInfraction, currentTime);
            host.disconnect();
        }
        if (badHostsPos > 0) {
            this.removeNetworkHosts(badHosts);
        }
    }

    public synchronized Host getNetworkHostAt(int index) {
        if (index < 0 || index >= this.networkHosts.size()) {
            return null;
        }
        return this.networkHosts.get(index);
    }

    public synchronized Host[] getNetworkHostsAt(int[] indices) {
        int length = indices.length;
        Host[] hosts = new Host[length];
        for (int i = 0; i < length; ++i) {
            hosts[i] = indices[i] < 0 || indices[i] >= this.networkHosts.size() ? null : this.networkHosts.get(indices[i]);
        }
        return hosts;
    }

    public synchronized Host getNetworkHost(DestAddress address) {
        for (Host networkHost : this.networkHosts) {
            DestAddress networkAddress = networkHost.getHostAddress();
            if (!networkAddress.equals(address)) continue;
            return networkHost;
        }
        return null;
    }

    public synchronized int getNetworkHostCount() {
        return this.networkHosts.size();
    }

    public synchronized int getNetworkHostCount(HostStatus status) {
        int count = 0;
        for (Host host : this.networkHosts) {
            if (host.getStatus() != status) continue;
            ++count;
        }
        return count;
    }

    public synchronized void addNetworkHost(Host host) {
        int position = this.networkHosts.size();
        this.networkHosts.add(host);
        this.fireNetworkHostAdded(host, position);
    }

    public synchronized boolean isConnectedToHost(DestAddress address) {
        for (int i = 0; i < this.networkHosts.size(); ++i) {
            Host host = this.networkHosts.get(i);
            if (!host.getHostAddress().equals(address)) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeAllNetworkHosts() {
        while (this.networkHosts.size() > 0) {
            Host host = this.networkHosts.get(0);
            this.internalRemoveNetworkHost(host);
        }
    }

    public synchronized void removeNetworkHosts(Host[] hosts) {
        for (Host host : hosts) {
            this.internalRemoveNetworkHost(host);
        }
    }

    public synchronized void removeNetworkHost(Host host) {
        this.internalRemoveNetworkHost(host);
    }

    private synchronized void internalRemoveNetworkHost(Host host) {
        if (host == null) {
            return;
        }
        host.disconnect();
        int position = this.networkHosts.indexOf(host);
        if (position >= 0) {
            this.networkHosts.remove(position);
            this.fireNetworkHostRemoved(host, position);
        }
    }

    private void fireNetworkHostAdded(Host host, int position) {
        this.servent.getEventService().publish("phex:net/hosts", new ContainerEvent(ContainerEvent.Type.ADDED, host, this, position));
    }

    private void fireNetworkHostRemoved(Host host, int position) {
        this.servent.getEventService().publish("phex:net/hosts", new ContainerEvent(ContainerEvent.Type.REMOVED, host, this, position));
    }

    @EventTopicSubscriber(topic="phex:servent/onlineStatus")
    public void onOnlineStatusEvent(String topic, ChangeEvent event) {
        OnlineStatus oldStatus = (OnlineStatus)((Object)event.getOldValue());
        OnlineStatus newStatus = (OnlineStatus)((Object)event.getNewValue());
        if (newStatus == OnlineStatus.OFFLINE && oldStatus != OnlineStatus.OFFLINE) {
            this.removeAllNetworkHosts();
        }
    }
}

