/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimerTask;
import org.apache.commons.collections.set.ListOrderedSet;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.common.Environment;
import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.collections.PriorityQueue;
import phex.connection.ConnectionStatusEvent;
import phex.event.ChangeEvent;
import phex.host.CatchedHostCache;
import phex.host.CaughtHost;
import phex.host.HostFetchingStrategy;
import phex.msg.PongMsg;
import phex.prefs.core.NetworkPrefs;
import phex.security.AccessType;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;
import phex.utils.IPUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaughtHostsContainer {
    private static final Logger logger = LoggerFactory.getLogger(CaughtHostsContainer.class);
    public static final short HIGH_PRIORITY = 2;
    public static final short NORMAL_PRIORITY = 1;
    public static final short LOW_PRIORITY = 0;
    private static final int FREE_SLOT_SET_SIZE = 8;
    private PriorityQueue caughtHosts;
    private HashSet<CaughtHost> uniqueCaughtHosts;
    private CatchedHostCache catchedHostCache;
    private Set<CaughtHost> freeLeafSlotSet;
    private Set<CaughtHost> freeUltrapeerSlotSet;
    private boolean hasChangedSinceLastSave;
    private HostFetchingStrategy hostFetchingStrategy;
    private final Servent servent;

    public CaughtHostsContainer(Servent servent) {
        this.servent = servent;
        int[] capacities = new int[3];
        capacities[2] = (int)Math.round(NetworkPrefs.MaxHostInHostCache.get().doubleValue() * 2.0 / 3.0);
        capacities[1] = (int)Math.round((NetworkPrefs.MaxHostInHostCache.get().doubleValue() - (double)capacities[2]) * 2.0 / 3.0);
        capacities[0] = NetworkPrefs.MaxHostInHostCache.get() - capacities[2] - capacities[1];
        this.caughtHosts = new PriorityQueue(capacities);
        this.uniqueCaughtHosts = new HashSet();
        this.catchedHostCache = new CatchedHostCache();
        Environment.getInstance().scheduleTimerTask(new SaveHostsContainerTimer(), 60000L, 60000L);
        this.freeUltrapeerSlotSet = new ListOrderedSet();
        this.freeLeafSlotSet = new ListOrderedSet();
        this.initializeCaughtHostsContainer();
        servent.getEventService().processAnnotations(this);
    }

    public void setHostFetchingStrategy(HostFetchingStrategy hostFetchingStrategy) {
        this.hostFetchingStrategy = hostFetchingStrategy;
    }

    private void initializeCaughtHostsContainer() {
        this.caughtHosts.clear();
        this.catchedHostCache.clear();
        this.hasChangedSinceLastSave = false;
        this.loadHostsFromFile();
    }

    public boolean catchHosts(PongMsg pongMsg) {
        Set<DestAddress> ipPortPairs;
        DestAddress pongAddress = pongMsg.getPongAddress();
        boolean valid = this.isValidCaughtHostAddress(pongAddress);
        boolean isNew = false;
        if (valid) {
            short priority;
            String vendor;
            CaughtHost caughtHost = new CaughtHost(pongAddress);
            int dailyUptime = pongMsg.getDailyUptime();
            if (dailyUptime > 0) {
                caughtHost.setDailyUptime(dailyUptime);
            }
            if ((vendor = pongMsg.getVendor()) != null) {
                caughtHost.setVendor(vendor, pongMsg.getVendorVersionMajor(), pongMsg.getVendorVersionMinor());
            }
            caughtHost.setUltrapeer(pongMsg.isUltrapeerMarked());
            if (pongMsg.isUltrapeerMarked()) {
                priority = 2;
                if (pongMsg.hasFreeLeafSlots()) {
                    this.addToFreeLeafSlotSet(caughtHost);
                }
                if (pongMsg.hasFreeUPSlots()) {
                    this.addToFreeUltrapeerSlotSet(caughtHost);
                }
            } else {
                priority = 0;
            }
            this.addPersistentCaughtHost(caughtHost);
            isNew = this.addToCaughtHostFetcher(caughtHost, priority);
        }
        if ((ipPortPairs = pongMsg.getIPPDestAddresses()) != null) {
            for (DestAddress ipPortAdd : ipPortPairs) {
                if (!this.isValidCaughtHostAddress(ipPortAdd)) continue;
                this.addToCaughtHostFetcher(new CaughtHost(ipPortAdd), (short)2);
            }
        }
        return isNew;
    }

    public void addCaughtHost(DestAddress address, short priority) {
        boolean valid = this.isValidCaughtHostAddress(address);
        if (!valid) {
            return;
        }
        CaughtHost caughtHost = new CaughtHost(address);
        this.addPersistentCaughtHost(caughtHost);
        this.addToCaughtHostFetcher(caughtHost, priority);
    }

    private synchronized boolean addToCaughtHostFetcher(CaughtHost caughtHost, short priority) {
        boolean isNew = false;
        if (!this.uniqueCaughtHosts.contains(caughtHost)) {
            isNew = this.uniqueCaughtHosts.add(caughtHost);
            Object removed = this.caughtHosts.addToHead(caughtHost, priority);
            if (removed != null) {
                this.uniqueCaughtHosts.remove(removed);
            }
            logger.debug("Added to host fetcher: {} - {}", (Object)caughtHost, (Object)priority);
        }
        return isNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPersistentCaughtHost(CaughtHost caughtHost) {
        CatchedHostCache catchedHostCache = this.catchedHostCache;
        synchronized (catchedHostCache) {
            DestAddress address = caughtHost.getHostAddress();
            CaughtHost existingHost = this.catchedHostCache.getCaughHost(address);
            if (existingHost == null) {
                this.catchedHostCache.add(caughtHost);
            } else {
                this.catchedHostCache.remove(existingHost);
                if (caughtHost.getDailyUptime() > 0) {
                    existingHost.setDailyUptime(caughtHost.getDailyUptime());
                }
                this.catchedHostCache.add(existingHost);
            }
            this.hasChangedSinceLastSave = true;
        }
    }

    public synchronized int getCaughtHostsCount() {
        return this.caughtHosts.getSize();
    }

    public synchronized DestAddress getNextCaughtHost() {
        this.ensureMinCaughHosts();
        if (!this.caughtHosts.isEmpty()) {
            CaughtHost host = (CaughtHost)this.caughtHosts.removeMaxPriority();
            this.uniqueCaughtHosts.remove(host);
            return host.getHostAddress();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventTopicSubscriber(topic="phex:net/connectionStatus")
    public void onConnectionStatusEvent(String topic, ConnectionStatusEvent event) {
        DestAddress hostAddress = event.getHostAddres();
        boolean valid = this.isValidCaughtHostAddress(hostAddress);
        if (!valid) {
            return;
        }
        CatchedHostCache catchedHostCache = this.catchedHostCache;
        synchronized (catchedHostCache) {
            CaughtHost existingHost = this.catchedHostCache.getCaughHost(hostAddress);
            if (existingHost == null) {
                existingHost = new CaughtHost(hostAddress);
            } else {
                this.catchedHostCache.remove(existingHost);
            }
            if (event.getStatus() == ConnectionStatusEvent.Status.SUCCESSFUL || event.getStatus() == ConnectionStatusEvent.Status.HANDSHAKE_REJECTED) {
                existingHost.setLastSuccessfulConnection(System.currentTimeMillis());
            } else {
                existingHost.setLastFailedConnection(System.currentTimeMillis());
            }
            this.catchedHostCache.add(existingHost);
            this.hasChangedSinceLastSave = true;
        }
    }

    @EventTopicSubscriber(topic="phex:servent/gnutellaNetwork")
    public void onGnutellaNetworkEvent(String topic, ChangeEvent event) {
        this.saveHostsContainer();
        this.initializeCaughtHostsContainer();
    }

    private void ensureMinCaughHosts() {
        int minCount = (int)Math.ceil(NetworkPrefs.MaxHostInHostCache.get().doubleValue() / 100.0);
        if (this.caughtHosts.getSize() < minCount && this.hostFetchingStrategy != null) {
            this.hostFetchingStrategy.fetchNewHosts(HostFetchingStrategy.FetchingReason.EnsureMinHosts);
        }
    }

    private boolean isValidCaughtHostAddress(DestAddress address) {
        if (address.isLocalHost(this.servent.getLocalAddress()) || !address.isValidAddress() || address.isSiteLocalAddress()) {
            return false;
        }
        return !IPUtils.isPortInUserInvalidList(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFreeUltrapeerSlotSet(CaughtHost host) {
        Set<CaughtHost> set = this.freeUltrapeerSlotSet;
        synchronized (set) {
            this.freeUltrapeerSlotSet.add(host);
            if (this.freeUltrapeerSlotSet.size() > 8) {
                ((ListOrderedSet)this.freeUltrapeerSlotSet).remove(0);
            }
            assert (this.freeUltrapeerSlotSet.size() <= 8) : "freeUltrapeerSlotSet grows over max size.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFreeLeafSlotSet(CaughtHost host) {
        Set<CaughtHost> set = this.freeLeafSlotSet;
        synchronized (set) {
            this.freeLeafSlotSet.add(host);
            if (this.freeLeafSlotSet.size() > 8) {
                ((ListOrderedSet)this.freeLeafSlotSet).remove(0);
            }
            assert (this.freeLeafSlotSet.size() <= 8) : "freeLeafSlotSet grows over max size.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CaughtHost> getFreeUltrapeerSlotHosts() {
        Set<CaughtHost> set = this.freeUltrapeerSlotSet;
        synchronized (set) {
            ArrayList<CaughtHost> freeHosts = new ArrayList<CaughtHost>(this.freeUltrapeerSlotSet);
            freeHosts.trimToSize();
            return freeHosts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CaughtHost> getFreeLeafSlotHosts() {
        Set<CaughtHost> set = this.freeLeafSlotSet;
        synchronized (set) {
            ArrayList<CaughtHost> freeHosts = new ArrayList<CaughtHost>(this.freeLeafSlotSet);
            freeHosts.trimToSize();
            return freeHosts;
        }
    }

    private void loadHostsFromFile() {
        logger.debug("Loading hosts file.");
        try {
            String line;
            BufferedReader br;
            File file = this.servent.getGnutellaNetwork().getHostsFile();
            if (file.exists()) {
                br = new BufferedReader(new FileReader(file));
            } else {
                logger.debug("Load default hosts file.");
                InputStream inStream = ClassLoader.getSystemResourceAsStream("phex/resources/phex.hosts");
                if (inStream != null) {
                    br = new BufferedReader(new InputStreamReader(inStream));
                } else {
                    logger.debug("Default Phex Hosts file not found.");
                    return;
                }
            }
            long now = System.currentTimeMillis();
            PhexSecurityManager securityMgr = this.servent.getSecurityService();
            short usedPriority = 0;
            block5: while ((line = br.readLine()) != null) {
                CaughtHost caughtHost;
                if (line.startsWith("#") || (caughtHost = this.parseCaughtHostFromLine(line, now)) == null) continue;
                AccessType access = securityMgr.controlHostAddressAccess(caughtHost.getHostAddress());
                switch (access) {
                    case ACCESS_DENIED: 
                    case ACCESS_STRONGLY_DENIED: {
                        continue block5;
                    }
                }
                if (IPUtils.isPortInUserInvalidList(caughtHost.getHostAddress())) continue;
                this.addPersistentCaughtHost(caughtHost);
                if (usedPriority != 2 && this.caughtHosts.isFull(usedPriority)) {
                    usedPriority = (short)(usedPriority + 1);
                }
                this.addToCaughtHostFetcher(caughtHost, usedPriority);
            }
            br.close();
        }
        catch (IOException exp) {
            logger.warn(exp.toString(), (Throwable)exp);
        }
    }

    private CaughtHost parseCaughtHostFromLine(String line, long now) {
        long lastSuccessfulConnection;
        long lastFailedconnection;
        int dailyUptime;
        String hostAddressStr;
        StringTokenizer tokenizer = new StringTokenizer(line, ",");
        int tokenCount = tokenizer.countTokens();
        String vendor = null;
        int vendorVersionMajor = -1;
        int vendorVersionMinor = -1;
        boolean isUltrapeer = false;
        if (tokenCount == 1) {
            hostAddressStr = line;
            dailyUptime = -1;
            lastFailedconnection = -1L;
            lastSuccessfulConnection = -1L;
        } else if (tokenCount == 4 || tokenCount == 8) {
            hostAddressStr = tokenizer.nextToken();
            try {
                lastFailedconnection = Long.parseLong(tokenizer.nextToken());
            }
            catch (NumberFormatException exp) {
                lastFailedconnection = -1L;
            }
            try {
                lastSuccessfulConnection = Long.parseLong(tokenizer.nextToken());
            }
            catch (NumberFormatException exp) {
                lastSuccessfulConnection = -1L;
            }
            try {
                dailyUptime = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException exp) {
                dailyUptime = -1;
            }
            if (tokenCount == 8) {
                vendor = tokenizer.nextToken();
                try {
                    vendorVersionMajor = Integer.parseInt(tokenizer.nextToken());
                }
                catch (NumberFormatException exp) {
                    vendorVersionMajor = -1;
                }
                try {
                    vendorVersionMinor = Integer.parseInt(tokenizer.nextToken());
                }
                catch (NumberFormatException exp) {
                    vendorVersionMinor = -1;
                }
                isUltrapeer = Boolean.parseBoolean(tokenizer.nextToken());
            }
        } else {
            logger.warn("Unknown HostCache line format: {}", (Object)line);
            return null;
        }
        byte[] ip = AddressUtils.parseIP(hostAddressStr);
        if (ip == null) {
            return null;
        }
        int port = AddressUtils.parsePort(hostAddressStr);
        if (port == -1) {
            return null;
        }
        DefaultDestAddress hostAddress = new DefaultDestAddress(ip, port);
        CaughtHost caughtHost = new CaughtHost(hostAddress);
        caughtHost.setUltrapeer(isUltrapeer);
        if (dailyUptime > 0) {
            caughtHost.setDailyUptime(dailyUptime);
        }
        if (lastFailedconnection > 0L && now - lastSuccessfulConnection < 2592000000L) {
            caughtHost.setLastFailedConnection(lastFailedconnection);
        }
        if (lastSuccessfulConnection > 0L && now - lastSuccessfulConnection < 2592000000L) {
            caughtHost.setLastSuccessfulConnection(lastSuccessfulConnection);
        }
        if (vendor != null && !vendor.equals("-")) {
            caughtHost.setVendor(vendor, vendorVersionMajor, vendorVersionMinor);
        }
        return caughtHost;
    }

    void saveHostsContainer() {
        if (!this.hasChangedSinceLastSave) {
            return;
        }
        this.saveCaughtHosts();
        this.hasChangedSinceLastSave = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCaughtHosts() {
        logger.debug("Start saving caught hosts.");
        try {
            File file = this.servent.getGnutellaNetwork().getHostsFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            CatchedHostCache catchedHostCache = this.catchedHostCache;
            synchronized (catchedHostCache) {
                Iterator<CaughtHost> iterator = this.catchedHostCache.iterator();
                while (iterator.hasNext()) {
                    CaughtHost host = iterator.next();
                    DestAddress hostAddress = host.getHostAddress();
                    String vendor = host.getVendor();
                    bw.write(hostAddress.getFullHostName() + "," + host.getLastFailedConnection() + "," + host.getLastSuccessfulConnection() + "," + host.getDailyUptime() + "," + (vendor == null ? "-" : vendor) + "," + host.getVendorVersionMajor() + "," + host.getVendorVersionMinor() + "," + host.isUltrapeer());
                    bw.newLine();
                }
            }
            bw.close();
        }
        catch (IOException exp) {
            logger.error(exp.toString(), (Throwable)exp);
        }
        logger.debug("Finish saving caught hosts.");
    }

    private class SaveHostsContainerTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private SaveHostsContainerTimer() {
        }

        public void run() {
            Environment.getInstance().executeOnThreadPool(new SaveHostsContainerRunner(), "SaveHostsContainer");
        }
    }

    private class SaveHostsContainerRunner
    implements Runnable {
        private SaveHostsContainerRunner() {
        }

        public void run() {
            CaughtHostsContainer.this.saveHostsContainer();
        }
    }
}

