/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.cp;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.gui.common.BoxPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.table.FWTable;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchTab;
import phex.gui.tabs.search.cp.BrowseHostSearchBox;
import phex.gui.tabs.search.cp.KeywordSearchBox;
import phex.gui.tabs.search.cp.SearchActivityBox;
import phex.gui.tabs.search.cp.SearchInfoBox;
import phex.gui.tabs.search.cp.WhatsNewSearchBox;
import phex.net.repres.PresentationManager;
import phex.query.BrowseHostResults;
import phex.query.KeywordSearch;
import phex.query.Search;
import phex.query.SearchContainer;
import phex.query.SearchDataEvent;
import phex.query.WhatsNewSearch;
import phex.rules.SearchFilterRules;

public class SearchControlPanel
extends JPanel {
    private final SearchContainer searchContainer;
    private final SearchFilterRules filterRules;
    private SearchResultsDataModel displayedDataModel;
    private SearchTab searchTab;
    private int prefWidth;
    private SearchActivityBox activityBox;
    private JPanel searchBoxContentPanel;
    private KeywordSearchBox keywordSearchBox;
    private WhatsNewSearchBox whatsNewBox;
    private BrowseHostSearchBox browseHostBox;
    private SearchInfoBox infoBox;
    private JScrollPane scrollPane;

    public SearchControlPanel(SearchTab tab, SearchContainer searchContainer, SearchFilterRules filterRules) {
        super(new GridBagLayout());
        this.searchTab = tab;
        this.searchContainer = searchContainer;
        this.filterRules = filterRules;
        this.initializeComponent();
        this.updateUI();
        GUIRegistry.getInstance().getServent().getEventService().processAnnotations(this);
    }

    public void clearSearchHistory() {
        this.keywordSearchBox.clearSearchHistory();
        this.browseHostBox.clearBrowseHostHistory();
    }

    public void initializeComponent() {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("fill:d:grow", "p, p, p");
        PanelBuilder cpPanelBuilder = new PanelBuilder(layout, (JPanel)this);
        this.keywordSearchBox = new KeywordSearchBox(this);
        this.whatsNewBox = new WhatsNewSearchBox(this);
        this.browseHostBox = new BrowseHostSearchBox(this);
        this.activityBox = new SearchActivityBox(this.searchTab, this);
        this.infoBox = new SearchInfoBox(this);
        this.prefWidth = 0;
        int prefHeight = 0;
        Dimension actPref = this.activityBox.getPreferredSize();
        this.prefWidth = Math.max(this.prefWidth, actPref.width);
        Dimension infoPref = this.infoBox.getPreferredSize();
        this.prefWidth = Math.max(this.prefWidth, infoPref.width);
        Dimension ksbPref = this.keywordSearchBox.getPreferredSize();
        this.prefWidth = Math.max(this.prefWidth, ksbPref.width);
        prefHeight = Math.max(prefHeight, ksbPref.height);
        Dimension wnbPref = this.whatsNewBox.getPreferredSize();
        this.prefWidth = Math.max(this.prefWidth, wnbPref.width);
        prefHeight = Math.max(prefHeight, wnbPref.height);
        Dimension bhbPref = this.browseHostBox.getPreferredSize();
        this.prefWidth = Math.max(this.prefWidth, bhbPref.width);
        prefHeight = Math.max(prefHeight, bhbPref.height);
        actPref.width = this.prefWidth;
        this.keywordSearchBox.setPreferredSize(actPref);
        infoPref.width = this.prefWidth;
        this.keywordSearchBox.setPreferredSize(infoPref);
        ksbPref.width = this.prefWidth;
        ksbPref.height = prefHeight;
        this.keywordSearchBox.setPreferredSize(ksbPref);
        wnbPref.width = this.prefWidth;
        wnbPref.height = prefHeight;
        this.whatsNewBox.setPreferredSize(wnbPref);
        bhbPref.width = this.prefWidth;
        bhbPref.height = prefHeight;
        this.browseHostBox.setPreferredSize(bhbPref);
        this.searchBoxContentPanel = new JPanel(new BorderLayout());
        cpPanelBuilder.add((Component)this.searchBoxContentPanel, cc.xy(1, 1));
        cpPanelBuilder.add((Component)this.activityBox, cc.xy(1, 2));
        cpPanelBuilder.add((Component)this.infoBox, cc.xy(1, 3));
        this.activityBox.postInit();
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.width = this.prefWidth;
        return dim;
    }

    private void activateSearchBox(BoxPanel boxPanel) {
        this.searchBoxContentPanel.removeAll();
        this.searchBoxContentPanel.add((Component)boxPanel, "Center");
        this.searchBoxContentPanel.doLayout();
        this.searchBoxContentPanel.revalidate();
        this.searchBoxContentPanel.repaint();
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        if (this.displayedDataModel != searchResultsDataModel) {
            this.displayedDataModel = searchResultsDataModel;
            this.infoBox.setDisplayedSearch(this.displayedDataModel);
            this.updateControlPanel();
        }
    }

    public void activateKeywordSearchBox() {
        this.activateSearchBox(this.keywordSearchBox);
        this.keywordSearchBox.focusInputField();
    }

    public void activateBrowseHostBox() {
        this.activateSearchBox(this.browseHostBox);
        this.browseHostBox.focusInputField();
    }

    public void activateWhatsNewBox() {
        this.activateSearchBox(this.whatsNewBox);
        this.whatsNewBox.focusInputField();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateControlPanel() {
        assert (EventQueue.isDispatchThread()) : "Not on EDT!";
        if (this.displayedDataModel != null) {
            this.activityBox.displayRunningSearchPanel();
            Search search = this.displayedDataModel.getSearch();
            if (search instanceof WhatsNewSearch) {
                this.activateSearchBox(this.whatsNewBox);
                this.whatsNewBox.updateControlPanel((WhatsNewSearch)search);
                return;
            } else if (search instanceof KeywordSearch) {
                this.activateSearchBox(this.keywordSearchBox);
                this.keywordSearchBox.updateControlPanel((KeywordSearch)search);
                return;
            } else {
                if (!(search instanceof BrowseHostResults)) throw new RuntimeException("Unknwon search type");
                this.activateSearchBox(this.browseHostBox);
                this.browseHostBox.updateControlPanel((BrowseHostResults)search);
            }
            return;
        } else {
            this.activityBox.displayNewSearchPanel();
            this.whatsNewBox.updateControlPanel(null);
            this.keywordSearchBox.updateControlPanel(null);
            this.browseHostBox.updateControlPanel(null);
        }
    }

    public void updateUI() {
        super.updateUI();
        Color shadow = UIManager.getColor("controlDkShadow");
        Color window = UIManager.getColor("window");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, window), BorderFactory.createMatteBorder(1, 1, 1, 1, shadow)));
        this.setBackground(window);
        if (this.scrollPane != null) {
            FWTable.updateFWTableScrollPane(this.scrollPane);
        }
    }

    protected boolean startKeywordSearch(String searchString) {
        if (this.displayedDataModel != null && !this.displayedDataModel.getSearch().isSearchFinished()) {
            return false;
        }
        Search existingSearch = this.searchContainer.getRunningKeywordSearch(searchString);
        if (existingSearch != null) {
            SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.lookupResultDataModel(existingSearch);
            this.searchTab.setDisplayedSearch(searchResultsDataModel);
            return false;
        }
        if (this.displayedDataModel == null) {
            Search newSearch = this.searchContainer.createSearch(searchString);
            SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.registerNewSearch(newSearch, this.filterRules);
            this.searchTab.setDisplayedSearch(searchResultsDataModel);
        } else {
            this.displayedDataModel.restartKeywordSearch(searchString);
        }
        return true;
    }

    public boolean startBrowseHost(String hostName) {
        DestAddress destAddress;
        if (this.displayedDataModel != null && !this.displayedDataModel.getSearch().isSearchFinished()) {
            return false;
        }
        PresentationManager presMgr = PresentationManager.getInstance();
        try {
            destAddress = presMgr.createHostAddress(hostName, 6346);
        }
        catch (MalformedDestAddressException exp) {
            return false;
        }
        Search existingSearch = this.searchContainer.getRunningBrowseHost(destAddress, null);
        if (existingSearch != null) {
            SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.lookupResultDataModel(existingSearch);
            this.searchTab.setDisplayedSearch(searchResultsDataModel);
            return false;
        }
        BrowseHostResults newSearch = this.searchContainer.createBrowseHostSearch(destAddress, null);
        SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.registerNewSearch(newSearch, this.filterRules);
        this.searchTab.setDisplayedSearch(searchResultsDataModel);
        return true;
    }

    public void startWhatsNewSearch() {
        if (this.displayedDataModel != null && !this.displayedDataModel.getSearch().isSearchFinished()) {
            return;
        }
        Search newSearch = this.searchContainer.createWhatsNewSearch();
        SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.registerNewSearch(newSearch, this.filterRules);
        this.searchTab.setDisplayedSearch(searchResultsDataModel);
    }

    public void stopSearching() {
        if (this.displayedDataModel != null && !this.displayedDataModel.getSearch().isSearchFinished()) {
            this.displayedDataModel.getSearch().stopSearching();
        }
    }

    @EventTopicSubscriber(topic="phex:search/data")
    public void onSearchDataEvent(String topic, SearchDataEvent event) {
        if (this.displayedDataModel == null) {
            return;
        }
        if (this.displayedDataModel.getSearch() != event.getSource()) {
            return;
        }
        short type = event.getType();
        switch (type) {
            case 0: 
            case 3: 
            case 4: {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        SearchControlPanel.this.updateControlPanel();
                    }
                });
            }
        }
    }
}

