/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.cp;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.text.Keymap;
import phex.common.log.NLogger;
import phex.gui.common.BoxPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.prefs.PhexGuiPrefs;
import phex.gui.prefs.SearchTabPrefs;
import phex.gui.tabs.search.cp.SearchControlPanel;
import phex.query.KeywordSearch;
import phex.utils.Localizer;

public class KeywordSearchBox
extends BoxPanel {
    private SearchControlPanel controlPanel;
    private DefaultComboBoxModel searchComboModel;
    private JComboBox searchTermComboBox;
    private JButton searchButton;
    private JButton stopButton;

    public KeywordSearchBox(SearchControlPanel cp) {
        super(Localizer.getString("SearchTab_KeywordSearch"));
        this.controlPanel = cp;
        CellConstraints cc = new CellConstraints();
        FormLayout searchBoxLayout = new FormLayout("6dlu, p, 6dlu", "4dlu, p, 2dlu, p, 6dlu, p, 4dlu");
        PanelBuilder searchBoxBuilder = new PanelBuilder(searchBoxLayout, this.getContentPanel());
        searchBoxBuilder.addLabel(Localizer.getString("SearchTab_TypeYourSearch"), cc.xy(2, 2));
        SubmitSearchHandler submitSearchHandler = new SubmitSearchHandler();
        this.searchComboModel = new DefaultComboBoxModel<Object>(SearchTabPrefs.SearchTermHistory.get().toArray());
        this.searchTermComboBox = new JComboBox(this.searchComboModel);
        this.searchTermComboBox.setEditable(true);
        JTextField editor = (JTextField)this.searchTermComboBox.getEditor().getEditorComponent();
        Keymap keymap = JTextField.addKeymap("SearchTermEditor", editor.getKeymap());
        editor.setKeymap(keymap);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), submitSearchHandler);
        GUIUtils.assignKeymapToComboBoxEditor(keymap, this.searchTermComboBox);
        this.searchTermComboBox.setSelectedItem("");
        searchBoxBuilder.add((Component)this.searchTermComboBox, cc.xy(2, 4));
        this.searchButton = new JButton(Localizer.getString("SearchTab_StartSearch"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.Search"));
        this.searchButton.setCursor(Cursor.getPredefinedCursor(12));
        this.searchButton.setToolTipText(Localizer.getString("SearchTab_TTTStartSearch"));
        this.searchButton.setMargin(GUIUtils.NARROW_BUTTON_INSETS);
        this.searchButton.addActionListener(submitSearchHandler);
        StopSearchHandler stopSearchHandler = new StopSearchHandler();
        this.stopButton = new JButton(Localizer.getString("SearchTab_StopSearch"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.Stop"));
        this.stopButton.setCursor(Cursor.getPredefinedCursor(12));
        this.stopButton.setToolTipText(Localizer.getString("SearchTab_TTTStopSearch"));
        this.stopButton.setMargin(GUIUtils.NARROW_BUTTON_INSETS);
        this.stopButton.addActionListener(stopSearchHandler);
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.setLeftToRightButtonOrder(true);
        builder.addFixedNarrow((JComponent)this.searchButton);
        builder.addRelatedGap();
        builder.addFixedNarrow((JComponent)this.stopButton);
        builder.addGlue();
        JPanel btnBar = builder.getPanel();
        btnBar.setOpaque(false);
        searchBoxBuilder.add((Component)btnBar, cc.xy(2, 6));
        this.adjustComponents();
    }

    private void adjustComponents() {
        if (this.searchTermComboBox != null) {
            GUIUtils.adjustComboBoxHeight(this.searchTermComboBox);
            ListCellRenderer renderer = this.searchTermComboBox.getRenderer();
            if (renderer != null) {
                FontMetrics fm = this.searchTermComboBox.getFontMetrics(this.searchTermComboBox.getFont());
                int maxFmWidth = fm.getMaxAdvance() * 10;
                int minFmWidth = fm.getMaxAdvance() * 8;
                Dimension maxDim = this.searchTermComboBox.getMaximumSize();
                maxDim.width = Math.max(minFmWidth, Math.min(maxFmWidth, maxDim.width));
                this.searchTermComboBox.setMaximumSize(maxDim);
                Dimension prefDim = this.searchTermComboBox.getPreferredSize();
                prefDim.width = Math.max(minFmWidth, Math.min(maxFmWidth, prefDim.width));
                this.searchTermComboBox.setPreferredSize(prefDim);
            }
        }
        if (this.searchButton != null) {
            String orgText = this.searchButton.getText();
            this.searchButton.setText(Localizer.getString("SearchTab_StartSearch"));
            Dimension dim = this.searchButton.getPreferredSize();
            this.searchButton.setText(Localizer.getString("SearchTab_Searching"));
            Dimension dim2 = this.searchButton.getPreferredSize();
            dim.width = Math.max(dim.width, dim2.width);
            this.searchButton.setPreferredSize(dim);
            this.searchButton.setText(orgText);
        }
    }

    public void clearSearchHistory() {
        this.searchComboModel.removeAllElements();
        SearchTabPrefs.SearchTermHistory.get().clear();
        PhexGuiPrefs.save(false);
    }

    public void focusInputField() {
        this.searchTermComboBox.requestFocus();
    }

    public void updateUI() {
        super.updateUI();
        this.adjustComponents();
    }

    public void updateControlPanel(KeywordSearch search) {
        if (search != null) {
            String searchString = search.getSearchString();
            this.searchTermComboBox.setSelectedItem(searchString);
            ((JTextField)this.searchTermComboBox.getEditor().getEditorComponent()).setText(searchString);
            if (!search.isSearchFinished()) {
                this.searchButton.setText(Localizer.getString("SearchTab_Searching"));
                this.searchButton.setToolTipText(Localizer.getString("SearchTab_TTTSearching"));
                this.searchButton.setEnabled(false);
                this.searchTermComboBox.setEnabled(false);
            } else {
                this.searchButton.setText(Localizer.getString("SearchTab_StartSearch"));
                this.searchButton.setToolTipText(Localizer.getString("SearchTab_TTTStartSearch"));
                this.searchButton.setEnabled(true);
                this.searchTermComboBox.setEnabled(true);
            }
        } else {
            this.searchTermComboBox.setSelectedItem(null);
            ((JTextField)this.searchTermComboBox.getEditor().getEditorComponent()).setText("");
            this.searchButton.setText(Localizer.getString("SearchTab_StartSearch"));
            this.searchButton.setToolTipText(Localizer.getString("SearchTab_TTTStartSearch"));
            this.searchButton.setEnabled(true);
            this.searchTermComboBox.setEnabled(true);
        }
    }

    private class StopSearchHandler
    extends AbstractAction
    implements ActionListener {
        private StopSearchHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            KeywordSearchBox.this.controlPanel.stopSearching();
        }
    }

    private class SubmitSearchHandler
    extends AbstractAction
    implements ActionListener {
        private SubmitSearchHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            String searchStr = (String)KeywordSearchBox.this.searchTermComboBox.getEditor().getItem();
            KeywordSearchBox.this.searchComboModel.setSelectedItem(searchStr);
            searchStr = searchStr.trim();
            if (searchStr.length() == 0) {
                return;
            }
            if (searchStr.length() < 2) {
                Object[] objArr = new Object[]{2};
                GUIUtils.showErrorMessage(Localizer.getFormatedString("MinSearchTerm", objArr));
                KeywordSearchBox.this.searchTermComboBox.getEditor().selectAll();
                try {
                    ((JComponent)KeywordSearchBox.this.searchTermComboBox.getEditor().getEditorComponent()).requestFocus();
                }
                catch (Exception exp) {
                    NLogger.error(SubmitSearchHandler.class, KeywordSearchBox.this.searchTermComboBox.getEditor().toString(), exp);
                }
                return;
            }
            boolean succ = KeywordSearchBox.this.controlPanel.startKeywordSearch(searchStr);
            if (!succ) {
                return;
            }
            int idx = KeywordSearchBox.this.searchComboModel.getIndexOf(searchStr);
            if (idx < 0) {
                KeywordSearchBox.this.searchComboModel.insertElementAt(searchStr, 0);
                if (KeywordSearchBox.this.searchComboModel.getSize() > SearchTabPrefs.MaxSearchHistorySize.get()) {
                    KeywordSearchBox.this.searchComboModel.removeElementAt(KeywordSearchBox.this.searchComboModel.getSize() - 1);
                }
                this.saveSearchList();
            } else if (idx > 0) {
                KeywordSearchBox.this.searchComboModel.removeElementAt(idx);
                KeywordSearchBox.this.searchComboModel.insertElementAt(searchStr, 0);
                this.saveSearchList();
            }
        }

        private void saveSearchList() {
            int length = KeywordSearchBox.this.searchComboModel.getSize();
            ArrayList searchList = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                searchList.add(KeywordSearchBox.this.searchComboModel.getElementAt(i));
            }
            SearchTabPrefs.SearchTermHistory.get().clear();
            SearchTabPrefs.SearchTermHistory.get().addAll(searchList);
            SearchTabPrefs.SearchTermHistory.changed();
            PhexGuiPrefs.save(false);
        }
    }
}

