/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import java.util.ArrayList;
import java.util.List;
import phex.common.format.HostSpeedFormatUtils;
import phex.download.RemoteFile;
import phex.utils.Localizer;

public class SearchResultElement {
    private RemoteFile remoteFile;
    private volatile List<RemoteFile> remoteFileList;
    private short bestScore;
    private RemoteFile bestRatedFile;
    private int bestSpeed;
    private String cachedBestSpeedFormatted;

    public SearchResultElement(RemoteFile aRemoteFile) {
        this.remoteFile = aRemoteFile;
        this.bestScore = this.remoteFile.getScore();
        this.bestRatedFile = this.remoteFile;
        this.bestSpeed = this.remoteFile.getSpeed();
        this.cachedBestSpeedFormatted = null;
    }

    public synchronized void addRemoteFile(RemoteFile aRemoteFile) {
        if (this.remoteFileList == null) {
            this.remoteFileList = new ArrayList<RemoteFile>(2);
            this.remoteFileList.add(this.remoteFile);
        }
        this.remoteFileList.add(aRemoteFile);
        if (aRemoteFile.getScore() > this.bestScore) {
            this.bestScore = aRemoteFile.getScore();
        }
        if (aRemoteFile.getQueryHitHost().getHostRating() > this.bestRatedFile.getQueryHitHost().getHostRating()) {
            this.bestRatedFile = aRemoteFile;
        }
        if (aRemoteFile.getSpeed() > this.bestSpeed) {
            this.bestSpeed = aRemoteFile.getSpeed();
            this.cachedBestSpeedFormatted = null;
        }
    }

    public int getRemoteFileListCount() {
        if (this.remoteFileList == null) {
            return 0;
        }
        return this.remoteFileList.size();
    }

    public RemoteFile getRemoteFileAt(int index) {
        if (this.remoteFileList == null || index < 0 || index >= this.remoteFileList.size()) {
            return null;
        }
        return this.remoteFileList.get(index);
    }

    public RemoteFile getBestRatedFile() {
        return this.bestRatedFile;
    }

    public RemoteFile getSingleRemoteFile() {
        return this.remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFile[] getRemoteFiles() {
        if (this.remoteFileList == null) {
            return new RemoteFile[]{this.remoteFile};
        }
        SearchResultElement searchResultElement = this;
        synchronized (searchResultElement) {
            RemoteFile[] remoteFiles = new RemoteFile[this.remoteFileList.size()];
            this.remoteFileList.toArray(remoteFiles);
            return remoteFiles;
        }
    }

    public Object getValue(int modelIndex) {
        switch (modelIndex) {
            case 3: {
                return this.bestScore;
            }
            case 4: {
                return this.bestRatedFile.getQueryHitHost().getHostRating();
            }
            case 6: {
                int listSize = this.getRemoteFileListCount();
                if (listSize > 0) {
                    return Localizer.getFormatedString("NumberOfHosts", listSize);
                }
                return this.remoteFile.getHostAddress();
            }
            case 7: {
                int listSize = this.getRemoteFileListCount();
                if (listSize > 0) {
                    return Localizer.getFormatedString("NumberOfHosts", listSize);
                }
                return this.remoteFile.getQueryHitHost().getVendor();
            }
        }
        return "";
    }

    public String getFormattedHostSpeed() {
        if (this.cachedBestSpeedFormatted == null) {
            this.cachedBestSpeedFormatted = HostSpeedFormatUtils.formatHostSpeed(this.bestSpeed);
        }
        return this.cachedBestSpeedFormatted;
    }
}

