/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import java.awt.Component;
import javax.swing.JTable;
import phex.download.RemoteFile;
import phex.gui.renderer.FWTableCellRenderer;
import phex.gui.tabs.search.SearchResultElement;
import phex.query.QHDFlag;
import phex.query.QueryHitHost;
import phex.utils.Localizer;

public class HostRatingCellRenderer
extends FWTableCellRenderer {
    public HostRatingCellRenderer() {
        this.setHorizontalAlignment(4);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        QueryHitHost queryHitHost = null;
        if (value instanceof SearchResultElement) {
            SearchResultElement result = (SearchResultElement)value;
            if (result.getRemoteFileListCount() != 0) {
                this.setText(String.valueOf(result.getBestRatedFile().getQueryHitHost().getHostRating()));
                this.setToolTipText(null);
                return this;
            }
            queryHitHost = result.getSingleRemoteFile().getQueryHitHost();
        } else if (value instanceof RemoteFile) {
            queryHitHost = ((RemoteFile)value).getQueryHitHost();
        }
        if (queryHitHost == null) {
            this.setText("");
            this.setToolTipText(null);
            return this;
        }
        this.setText(String.valueOf(queryHitHost.getHostRating()));
        StringBuilder builder = new StringBuilder("<html>");
        this.handleQHDFlag(queryHitHost.getPushNeededFlag(), "SearchTab_HostRating_FirewalledTrue", "SearchTab_HostRating_FirewalledFalse", "SearchTab_HostRating_FirewalledUnknown", builder);
        builder.append("<br>");
        this.handleQHDFlag(queryHitHost.getServerBusyFlag(), "SearchTab_HostRating_ServerBusyTrue", "SearchTab_HostRating_ServerBusyFalse", "SearchTab_HostRating_ServerBusyUnknown", builder);
        builder.append("<br>");
        this.handleQHDFlag(queryHitHost.getHasUploadedFlag(), "SearchTab_HostRating_HasUploadedTrue", "SearchTab_HostRating_HasUploadedFalse", "SearchTab_HostRating_HasUploadedUnknown", builder);
        builder.append("<br>");
        if (queryHitHost.isBrowseHostSupported()) {
            builder.append(Localizer.getString("SearchTab_HostRating_SupportsBrowseHost"));
            builder.append("<br>");
        }
        if (queryHitHost.isChatSupported()) {
            builder.append(Localizer.getString("SearchTab_HostRating_SupportsChat"));
            builder.append("<br>");
        }
        if (queryHitHost.isUdpHost()) {
            builder.append(Localizer.getString("SearchTab_HostRating_ReceivedViaUdp"));
            builder.append("<br>");
        }
        this.setToolTipText(builder.toString());
        return this;
    }

    private void handleQHDFlag(QHDFlag flag, String trueStr, String falseStr, String unknownStr, StringBuilder builder) {
        switch (flag) {
            case QHD_TRUE_FLAG: {
                builder.append(Localizer.getString(trueStr));
                break;
            }
            case QHD_FALSE_FLAG: {
                builder.append(Localizer.getString(falseStr));
                break;
            }
            case QHD_UNKNOWN_FLAG: {
                builder.append(Localizer.getString(unknownStr));
            }
        }
    }
}

