/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.download;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import phex.common.Environment;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.format.NumberFormatUtils;
import phex.common.log.LogBuffer;
import phex.common.log.LogRecord;
import phex.common.log.NLogger;
import phex.download.strategy.AvailBeginRandSelectionStrategy;
import phex.download.strategy.BeginAvailRandSelectionStrategy;
import phex.download.strategy.BeginEndAvailRandSelectionStrategy;
import phex.download.strategy.RandomScopeSelectionStrategy;
import phex.download.strategy.ScopeSelectionStrategy;
import phex.download.strategy.ScopeSelectionStrategyProvider;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.gui.actions.BanHostActionUtils;
import phex.gui.actions.FWAction;
import phex.gui.actions.FWToggleAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.FWMenu;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IconPack;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.dialogs.DownloadConfigDialog;
import phex.gui.dialogs.LogBufferDialog;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.download.DownloadOverviewPanel;
import phex.gui.tabs.download.DownloadTransfersPanel;
import phex.gui.tabs.download.SWCandidateTableModel;
import phex.gui.tabs.download.SWDownloadTableModel;
import phex.prefs.core.BandwidthPrefs;
import phex.prefs.core.DownloadPrefs;
import phex.query.ResearchSetting;
import phex.utils.Localizer;
import phex.utils.SystemShellExecute;
import phex.utils.URLUtil;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;

public class SWDownloadTab
extends FWTab {
    private static final String DOWNLOAD_TABLE_IDENTIFIER = "DownloadTable";
    private static final String CANDIDATE_TABLE_IDENTIFIER = "CandidateTable";
    private static final SWDownloadFile[] EMPTY_DOWNLOADFILE_ARRAY = new SWDownloadFile[0];
    private static final SWDownloadCandidate[] EMPTY_DOWNLOADCANDIDATE_ARRAY = new SWDownloadCandidate[0];
    private final SwarmingManager downloadService;
    private FWTable downloadTable;
    private JScrollPane downloadTableScrollPane;
    private SWDownloadTableModel downloadModel;
    private JTabbedPane downloadDetails;
    private JPopupMenu downloadPopup;
    private JMenu downloadPopupSpeedMenu;
    private FWElegantPanel overviewElegantPanel;
    private DownloadOverviewPanel downloadOverviewPanel;
    private FWElegantPanel transfersElegantPanel;
    private DownloadTransfersPanel transfersPanel;
    private PanelBuilder candidatePanelBuilder;
    private FWElegantPanel candidateElegantPanel;
    private FWTable candidateTable;
    private JScrollPane candidateTableScrollPane;
    private SWCandidateTableModel candidateModel;
    private JPopupMenu candidatePopup;

    public SWDownloadTab(SwarmingManager downloadService) {
        super(1003, Localizer.getString("Download"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Download.Tab"), Localizer.getString("TTTDownloadTab"), Localizer.getChar("DownloadMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("DownloadAccelerator")), 2);
        if (downloadService == null) {
            throw new NullPointerException("DownloadService missing");
        }
        this.downloadService = downloadService;
    }

    public void initComponent(DGuiSettings guiSettings) {
        MouseHandler mouseHandler = new MouseHandler();
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:d:grow, 2dlu");
        PanelBuilder tabBuilder = new PanelBuilder(layout, (JPanel)this);
        JPanel downloadTablePanel = this.initDownloadTablePanel(guiSettings, mouseHandler);
        this.initDownloadOverviewPanel();
        JPanel downloadCandidatePanel = this.initDownloadCandidatePanel(guiSettings, mouseHandler);
        this.initDownloadTransferPanel(guiSettings);
        this.downloadDetails = new JTabbedPane(3);
        this.downloadDetails.putClientProperty("jgoodies.embeddedTabs", Boolean.TRUE);
        this.downloadDetails.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.downloadDetails.addTab(Localizer.getString("DownloadTab_Overview"), this.overviewElegantPanel);
        this.downloadDetails.addTab(Localizer.getString("DownloadTab_Transfers"), this.transfersElegantPanel);
        this.downloadDetails.addTab(Localizer.getString("Candidates"), downloadCandidatePanel);
        Dimension dim = new Dimension(400, 300);
        downloadTablePanel.setPreferredSize(dim);
        this.downloadDetails.setPreferredSize(dim);
        dim = new Dimension(0, 0);
        downloadTablePanel.setMinimumSize(dim);
        this.downloadDetails.setMinimumSize(dim);
        JSplitPane splitPane = new JSplitPane(0, downloadTablePanel, this.downloadDetails);
        splitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        splitPane.setDividerSize(4);
        splitPane.setOneTouchExpandable(false);
        splitPane.setDividerLocation(0.5);
        splitPane.setResizeWeight(0.5);
        tabBuilder.add((Component)splitPane, cc.xy(2, 2));
        GUIUtils.adjustTableProgresssBarHeight(this.downloadTable);
        GUIUtils.adjustTableProgresssBarHeight(this.candidateTable);
        ActionListener updateDownloadFileInfoAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SWDownloadTab.this.updateDownloadFileInfo();
            }
        };
        GUIRegistry.getInstance().getGuiUpdateTimer().addActionListener(updateDownloadFileInfoAction);
    }

    private void initDownloadOverviewPanel() {
        this.downloadOverviewPanel = new DownloadOverviewPanel();
        this.downloadOverviewPanel.initializeComponent(null);
        this.overviewElegantPanel = new FWElegantPanel(Localizer.getString("DownloadTab_DownloadOverview"), this.downloadOverviewPanel);
    }

    private void initDownloadTransferPanel(DGuiSettings guiSettings) {
        this.transfersPanel = new DownloadTransfersPanel();
        this.transfersPanel.initializeComponent(guiSettings);
        this.transfersElegantPanel = new FWElegantPanel(Localizer.getString("DownloadTab_DownloadTransfers"), this.transfersPanel);
    }

    private JPanel initDownloadCandidatePanel(DGuiSettings guiSettings, MouseHandler mouseHandler) {
        JPanel downloadCandidatePanel = new JPanel();
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        this.candidatePanelBuilder = new PanelBuilder(layout, downloadCandidatePanel);
        this.candidateModel = new SWCandidateTableModel(this.downloadTable, this.downloadService);
        this.candidateTable = new FWTable(new FWSortedTableModel(this.candidateModel));
        GUIUtils.updateTableFromDGuiSettings(guiSettings, this.candidateTable, CANDIDATE_TABLE_IDENTIFIER);
        this.candidateTable.activateAllHeaderActions();
        this.candidateTable.getSelectionModel().addListSelectionListener(new CandidateSelectionHandler());
        this.candidateTable.setAutoResizeMode(0);
        this.candidateTable.addMouseListener(mouseHandler);
        GUIRegistry.getInstance().getGuiUpdateTimer().addTable(this.candidateTable);
        this.candidateTableScrollPane = FWTable.createFWTableScrollPane(this.candidateTable);
        this.candidateTableScrollPane.addMouseListener(mouseHandler);
        this.candidatePanelBuilder.add((Component)this.candidateTableScrollPane, cc.xy(1, 1));
        FWToolBar candidateToolbar = new FWToolBar(0);
        candidateToolbar.setBorderPainted(false);
        candidateToolbar.setFloatable(false);
        this.candidatePanelBuilder.add((Component)candidateToolbar, cc.xy(1, 3));
        this.candidatePopup = new JPopupMenu();
        FWAction action = new RetryCandidateAction();
        this.addTabAction(action);
        candidateToolbar.addAction(action);
        this.candidatePopup.add(action);
        action = new RemoveCandidateAction();
        this.addTabAction(action);
        candidateToolbar.addAction(action);
        this.candidatePopup.add(action);
        this.candidateTable.getActionMap().put(action, action);
        this.candidateTable.getInputMap(1).put((KeyStroke)action.getValue("AcceleratorKey"), action);
        this.candidatePopup.addSeparator();
        candidateToolbar.addSeparator();
        action = new AddToFavoritesAction();
        this.addTabAction(action);
        this.candidatePopup.add(action);
        action = new BrowseHostAction();
        this.addTabAction(action);
        candidateToolbar.addAction(action);
        this.candidatePopup.add(action);
        action = new ChatToHostAction();
        this.addTabAction(action);
        candidateToolbar.addAction(action);
        this.candidatePopup.add(action);
        BanHostActionProvider banHostActionProvider = new BanHostActionProvider();
        BanHostActionUtils.BanHostActionMenu bhActionMenu = BanHostActionUtils.createActionMenu(banHostActionProvider);
        this.candidatePopup.add(bhActionMenu.menu);
        this.addTabActions(bhActionMenu.actions);
        action = BanHostActionUtils.createToolBarAction(banHostActionProvider);
        candidateToolbar.addAction(action);
        this.addTabAction(action);
        if (DownloadPrefs.CandidateLogBufferSize.get() > 0) {
            action = new CandidateLogAction();
            this.addTabAction(action);
            candidateToolbar.addAction(action);
            this.candidatePopup.add(action);
        }
        this.candidateElegantPanel = new FWElegantPanel(Localizer.getString("DownloadCandidates"), downloadCandidatePanel);
        return this.candidateElegantPanel;
    }

    private JPanel initDownloadTablePanel(DGuiSettings guiSettings, MouseHandler mouseHandler) {
        JPanel downloadTablePanel = new JPanel();
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        PanelBuilder tabBuilder = new PanelBuilder(layout, downloadTablePanel);
        this.downloadModel = new SWDownloadTableModel(this.downloadService);
        this.downloadTable = new FWTable(new FWSortedTableModel(this.downloadModel));
        GUIUtils.updateTableFromDGuiSettings(guiSettings, this.downloadTable, DOWNLOAD_TABLE_IDENTIFIER);
        this.downloadTable.activateAllHeaderActions();
        this.downloadTable.setAutoResizeMode(0);
        this.downloadTable.getSelectionModel().addListSelectionListener(new DownloadSelectionHandler());
        this.downloadTable.addMouseListener(mouseHandler);
        GUIRegistry.getInstance().getGuiUpdateTimer().addTable(this.downloadTable);
        this.downloadTableScrollPane = FWTable.createFWTableScrollPane(this.downloadTable);
        this.downloadTableScrollPane.addMouseListener(mouseHandler);
        tabBuilder.add((Component)this.downloadTableScrollPane, cc.xy(1, 1));
        FWToolBar fileToolbar = new FWToolBar(0);
        fileToolbar.setBorderPainted(false);
        fileToolbar.setFloatable(false);
        tabBuilder.add((Component)fileToolbar, cc.xy(1, 3));
        this.downloadPopup = new JPopupMenu();
        StartDownloadAction startDownloadAction = new StartDownloadAction();
        this.addTabAction(startDownloadAction);
        fileToolbar.addAction(startDownloadAction);
        this.downloadPopup.add(startDownloadAction);
        StopDownloadAction stopDownloadAction = new StopDownloadAction();
        this.addTabAction(stopDownloadAction);
        fileToolbar.addAction(stopDownloadAction);
        this.downloadPopup.add(stopDownloadAction);
        RemoveDownloadAction removeDownloadAction = new RemoveDownloadAction();
        this.addTabAction(removeDownloadAction);
        fileToolbar.addAction(removeDownloadAction);
        this.downloadPopup.add(removeDownloadAction);
        this.downloadTable.getActionMap().put(removeDownloadAction, removeDownloadAction);
        this.downloadTable.getInputMap(1).put((KeyStroke)removeDownloadAction.getValue("AcceleratorKey"), removeDownloadAction);
        fileToolbar.addSeparator();
        this.downloadPopup.addSeparator();
        ConfigureDownloadAction configureDownloadAction = new ConfigureDownloadAction();
        this.addTabAction(configureDownloadAction);
        fileToolbar.addAction(configureDownloadAction);
        this.downloadPopup.add(configureDownloadAction);
        SearchCandidatesAction searchCandidateAction = new SearchCandidatesAction();
        this.addTabAction(searchCandidateAction);
        fileToolbar.addAction(searchCandidateAction);
        this.downloadPopup.add(searchCandidateAction);
        this.downloadPopupSpeedMenu = new JMenu(Localizer.getString("DownloadTab_DownloadSpeed"));
        this.downloadPopup.add(this.downloadPopupSpeedMenu);
        JMenu priorityMenu = new JMenu(Localizer.getString("Priority"));
        MoveDownloadPriorityAction priorityTopAction = new MoveDownloadPriorityAction(0);
        priorityMenu.add(priorityTopAction);
        this.addTabAction(priorityTopAction);
        MoveDownloadPriorityAction priorityUpAction = new MoveDownloadPriorityAction(1);
        priorityMenu.add(priorityUpAction);
        this.addTabAction(priorityUpAction);
        MoveDownloadPriorityAction priorityResortAction = new MoveDownloadPriorityAction(100);
        priorityMenu.add(priorityResortAction);
        this.addTabAction(priorityResortAction);
        MoveDownloadPriorityAction priorityDownAction = new MoveDownloadPriorityAction(2);
        priorityMenu.add(priorityDownAction);
        this.addTabAction(priorityDownAction);
        MoveDownloadPriorityAction priorityBottomAction = new MoveDownloadPriorityAction(3);
        priorityMenu.add(priorityBottomAction);
        this.addTabAction(priorityBottomAction);
        this.downloadPopup.add(priorityMenu);
        FWMenu orderingMenu = new FWMenu(Localizer.getString("DownloadTab_Strategy"));
        FWAction action = new SelectStrategyAction(0);
        orderingMenu.addAction(action);
        this.addTabAction(action);
        action = new SelectStrategyAction(1);
        orderingMenu.addAction(action);
        this.addTabAction(action);
        action = new SelectStrategyAction(2);
        orderingMenu.addAction(action);
        this.addTabAction(action);
        action = new SelectStrategyAction(3);
        orderingMenu.addAction(action);
        this.addTabAction(action);
        this.downloadPopup.add(orderingMenu);
        action = new GeneratePreviewAction();
        this.addTabAction(action);
        fileToolbar.addAction(action);
        this.downloadPopup.add(action);
        action = new ViewBitziTicketAction();
        this.addTabAction(action);
        this.downloadPopup.add(action);
        FWElegantPanel elegantPanel = new FWElegantPanel(Localizer.getString("DownloadFiles"), downloadTablePanel);
        return elegantPanel;
    }

    public void updateUI() {
        super.updateUI();
        if (this.downloadTable != null) {
            GUIUtils.adjustTableProgresssBarHeight(this.downloadTable);
        }
        if (this.downloadTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.downloadTableScrollPane);
        }
        if (this.candidateTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.candidateTableScrollPane);
        }
    }

    private void updateDownloadFileInfo() {
        int selectedRow = this.downloadTable.getSelectedRow();
        int modelRow = this.downloadTable.translateRowIndexToModel(selectedRow);
        this.refreshTabActions();
        SWDownloadFile file = this.downloadService.getDownloadFile(modelRow);
        this.downloadOverviewPanel.updateDownloadFileInfo(file);
        this.transfersPanel.updateDownloadFile(file);
        if (file != null) {
            ResearchSetting researchSetting = file.getResearchSetting();
            if (researchSetting.isSearchRunning()) {
                Object[] args = new Object[]{researchSetting.getSearchHitCount(), researchSetting.getSearchProgress()};
                this.overviewElegantPanel.setTitle(Localizer.getString("DownloadTab_DownloadOverview") + " " + Localizer.getFormatedString("CandidatesSearchingExt", args));
                this.transfersElegantPanel.setTitle(Localizer.getString("DownloadTab_DownloadTransfers") + " " + Localizer.getFormatedString("CandidatesSearchingExt", args));
                this.candidateElegantPanel.setTitle(Localizer.getString("DownloadCandidates") + " " + Localizer.getFormatedString("CandidatesSearchingExt", args));
            } else {
                this.overviewElegantPanel.setTitle(Localizer.getString("DownloadTab_DownloadOverview"));
                this.transfersElegantPanel.setTitle(Localizer.getString("DownloadTab_DownloadTransfers"));
                this.candidateElegantPanel.setTitle(Localizer.getString("DownloadCandidates"));
            }
        }
    }

    private SWDownloadFile[] getSelectedDownloadFiles() {
        if (this.downloadTable.getSelectedRowCount() == 0) {
            return EMPTY_DOWNLOADFILE_ARRAY;
        }
        int[] viewIndices = this.downloadTable.getSelectedRows();
        int[] modelIndices = this.downloadTable.convertRowIndicesToModel(viewIndices);
        SWDownloadFile[] files = this.downloadService.getDownloadFilesAt(modelIndices);
        return files;
    }

    private SWDownloadFile getSelectedDownloadFile() {
        int viewIndex = this.downloadTable.getSelectedRow();
        if (viewIndex < 0) {
            return null;
        }
        int modelIndex = this.downloadTable.translateRowIndexToModel(viewIndex);
        SWDownloadFile file = this.downloadService.getDownloadFile(modelIndex);
        return file;
    }

    private SWDownloadCandidate[] getSelectedDownloadCandidates() {
        if (this.candidateTable.getSelectedRowCount() == 0) {
            return EMPTY_DOWNLOADCANDIDATE_ARRAY;
        }
        int[] viewIndices = this.candidateTable.getSelectedRows();
        int[] modelIndices = this.candidateTable.convertRowIndicesToModel(viewIndices);
        SWDownloadCandidate[] candidates = new SWDownloadCandidate[modelIndices.length];
        SWDownloadFile downloadFile = this.candidateModel.getDownloadFile();
        for (int i = 0; i < candidates.length; ++i) {
            candidates[i] = downloadFile.getCandidate(modelIndices[i]);
        }
        return candidates;
    }

    private SWDownloadCandidate getSelectedDownloadCandidate() {
        int viewIndex = this.candidateTable.getSelectedRow();
        int modelIndex = this.candidateTable.translateRowIndexToModel(viewIndex);
        if (modelIndex < 0) {
            return null;
        }
        SWDownloadFile downloadFile = this.candidateModel.getDownloadFile();
        SWDownloadCandidate candidate = downloadFile.getCandidate(modelIndex);
        return candidate;
    }

    public void appendDGuiSettings(DGuiSettings dSettings) {
        super.appendDGuiSettings(dSettings);
        DTable dTable = GUIUtils.createDTable(this.downloadTable, DOWNLOAD_TABLE_IDENTIFIER);
        dSettings.getTableList().getTableList().add(dTable);
        dTable = GUIUtils.createDTable(this.candidateTable, CANDIDATE_TABLE_IDENTIFIER);
        dSettings.getTableList().getTableList().add(dTable);
        this.transfersPanel.appendDGuiSettings(dSettings);
    }

    private class CandidateLogAction
    extends FWAction {
        public CandidateLogAction() {
            super(Localizer.getString("DownloadTab_ViewLog"), null, Localizer.getString("DownloadTab_TTTViewLog"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SWDownloadCandidate candidate = SWDownloadTab.this.getSelectedDownloadCandidate();
                LogBuffer buffer = SWDownloadTab.this.downloadService.getCandidateLogBuffer();
                Collection<LogRecord> logRecords = buffer.getLogRecords(candidate);
                if (logRecords != null) {
                    LogBufferDialog dialog = new LogBufferDialog(logRecords);
                    dialog.setVisible(true);
                }
            }
            catch (Throwable th) {
                NLogger.error(CandidateLogAction.class, th, th);
            }
        }

        public void refreshActionState() {
            SWDownloadCandidate candidate;
            if (SWDownloadTab.this.candidateTable.getSelectedRowCount() == 1 && (candidate = SWDownloadTab.this.getSelectedDownloadCandidate()) != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class SearchCandidatesAction
    extends FWAction {
        public SearchCandidatesAction() {
            super(Localizer.getString("Search"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Download.Search"), Localizer.getString("TTTSearchCandidates"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            try {
                int viewIdx = SWDownloadTab.this.downloadTable.getSelectedRow();
                int modelIdx = SWDownloadTab.this.downloadTable.translateRowIndexToModel(viewIdx);
                SWDownloadFile file = SWDownloadTab.this.downloadService.getDownloadFile(modelIdx);
                file.startSearchForCandidates();
            }
            catch (Throwable th) {
                NLogger.error(SearchCandidatesAction.class, th, th);
            }
        }

        public void refreshActionState() {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() != 1) {
                this.setEnabled(false);
                return;
            }
            int viewIdx = SWDownloadTab.this.downloadTable.getSelectedRow();
            int modelIdx = SWDownloadTab.this.downloadTable.translateRowIndexToModel(viewIdx);
            SWDownloadFile file = SWDownloadTab.this.downloadService.getDownloadFile(modelIdx);
            if (file == null) {
                this.setEnabled(false);
            } else if (file.getResearchSetting().isSearchRunning() || file.isFileCompletedOrMoved()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class AddToFavoritesAction
    extends FWAction {
        public AddToFavoritesAction() {
            super(Localizer.getString("AddToFavorites"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Download.FavoriteHost"), Localizer.getString("TTTAddToFavorites"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            SWDownloadCandidate[] candidates = SWDownloadTab.this.getSelectedDownloadCandidates();
            DestAddress[] addresses = new DestAddress[candidates.length];
            for (int i = 0; i < candidates.length; ++i) {
                addresses[i] = candidates[i].getHostAddress();
            }
            GUIActionPerformer.addHostsToFavorites(addresses);
        }

        public void refreshActionState() {
            int downloadRow = SWDownloadTab.this.downloadTable.getSelectedRow();
            int candidateRow = SWDownloadTab.this.candidateTable.getSelectedRow();
            if (downloadRow < 0 || candidateRow < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private final class BanHostActionProvider
    implements BanHostActionUtils.BanHostActionProvider {
        private BanHostActionProvider() {
        }

        public DestAddress[] getBanHostAddresses() {
            SWDownloadCandidate[] candidates = SWDownloadTab.this.getSelectedDownloadCandidates();
            SWDownloadFile file = SWDownloadTab.this.candidateModel.getDownloadFile();
            DestAddress[] addresses = new DestAddress[candidates.length];
            for (int i = 0; i < candidates.length; ++i) {
                file.stopDownload(candidates[i]);
                file.markCandidateIgnored(candidates[i], "CandidateStatusReason_ByUser");
                addresses[i] = candidates[i].getHostAddress();
            }
            return addresses;
        }

        public boolean isBanHostActionEnabled(boolean allowMultipleAddresses) {
            int downloadRow = SWDownloadTab.this.downloadTable.getSelectedRow();
            int candidateRow = SWDownloadTab.this.candidateTable.getSelectedRow();
            return downloadRow >= 0 && candidateRow >= 0 && (allowMultipleAddresses || SWDownloadTab.this.candidateTable.getSelectedRowCount() <= 1);
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Download.BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            SWDownloadCandidate candidate = SWDownloadTab.this.getSelectedDownloadCandidate();
            if (candidate == null) {
                return;
            }
            GUIActionPerformer.browseHost(candidate.getHostAddress());
        }

        public void refreshActionState() {
            SWDownloadCandidate candidate;
            if (SWDownloadTab.this.candidateTable.getSelectedRowCount() == 1 && (candidate = SWDownloadTab.this.getSelectedDownloadCandidate()) != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Download.Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            SWDownloadCandidate candidate = SWDownloadTab.this.getSelectedDownloadCandidate();
            if (candidate == null) {
                return;
            }
            if (!candidate.isChatSupported()) {
                return;
            }
            GUIActionPerformer.chatToHost(candidate.getHostAddress());
        }

        public void refreshActionState() {
            SWDownloadCandidate candidate;
            if (SWDownloadTab.this.candidateTable.getSelectedRowCount() == 1 && (candidate = SWDownloadTab.this.getSelectedDownloadCandidate()) != null && candidate.isChatSupported()) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    class RetryCandidateAction
    extends FWAction {
        RetryCandidateAction() {
            super(Localizer.getString("RetryCandidate"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Download.ReconnectHost"), Localizer.getString("TTTRetryCandidate"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            SWDownloadCandidate[] candidates = SWDownloadTab.this.getSelectedDownloadCandidates();
            for (int i = 0; i < candidates.length; ++i) {
                if (candidates[i] == null) continue;
                candidates[i].manualConnectionRetry();
            }
        }

        public void refreshActionState() {
            int downloadRow = SWDownloadTab.this.downloadTable.getSelectedRow();
            int candidateRow = SWDownloadTab.this.candidateTable.getSelectedRow();
            if (downloadRow < 0 || candidateRow < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class RemoveCandidateAction
    extends FWAction {
        RemoveCandidateAction() {
            super(Localizer.getString("RemoveCandidate"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Download.RemoveCandidate"), Localizer.getString("TTTRemoveCandidate"), null, KeyStroke.getKeyStroke(127, 0));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            final SWDownloadCandidate[] candidates = SWDownloadTab.this.getSelectedDownloadCandidates();
            final SWDownloadFile file = SWDownloadTab.this.candidateModel.getDownloadFile();
            Runnable runner = new Runnable(){

                public void run() {
                    try {
                        for (int i = 0; i < candidates.length; ++i) {
                            file.stopDownload(candidates[i]);
                            file.markCandidateIgnored(candidates[i], "CandidateStatusReason_ByUser");
                        }
                        RemoveCandidateAction.this.refreshActionState();
                    }
                    catch (Throwable th) {
                        NLogger.error(RemoveCandidateAction.class, th, th);
                    }
                }
            };
            Environment.getInstance().executeOnThreadPool(runner, "RemoveDownloadCandidate");
        }

        public void refreshActionState() {
            int downloadRow = SWDownloadTab.this.downloadTable.getSelectedRow();
            int candidateRow = SWDownloadTab.this.candidateTable.getSelectedRow();
            if (downloadRow < 0 || candidateRow < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Download.ViewBitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            block4: {
                SWDownloadFile file = SWDownloadTab.this.getSelectedDownloadFile();
                if (file == null) {
                    return;
                }
                URN urn = file.getFileURN();
                if (urn == null) {
                    return;
                }
                String url = URLUtil.buildBitziLookupURL(urn);
                try {
                    BrowserLauncher.openURL(url);
                }
                catch (IOException exp) {
                    NLogger.warn(ViewBitziTicketAction.class, exp, exp);
                    Object[] dialogOptions = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int choice = JOptionPane.showOptionDialog(SWDownloadTab.this, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, dialogOptions, Localizer.getString("Yes"));
                    if (choice != 0) break block4;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(url), null);
                }
            }
        }

        public void refreshActionState() {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class GeneratePreviewAction
    extends FWAction {
        GeneratePreviewAction() {
            super(Localizer.getString("DownloadTab_PreviewDownload"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Download.Preview"), Localizer.getString("DownloadTab_TTTPreviewDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            try {
                final SWDownloadFile file = SWDownloadTab.this.getSelectedDownloadFile();
                if (file == null) {
                    return;
                }
                Runnable runner = new Runnable(){

                    public void run() {
                        try {
                            File previewFile = file.getPreviewFile();
                            SystemShellExecute.launchFile(previewFile);
                        }
                        catch (Throwable th) {
                            NLogger.error(GeneratePreviewAction.class, th, th);
                        }
                    }
                };
                Environment.getInstance().executeOnThreadPool(runner, "GenerateDownloadPreview");
            }
            catch (Throwable th) {
                NLogger.error(GeneratePreviewAction.class, th, th);
            }
        }

        public void refreshActionState() {
            try {
                SWDownloadFile file = SWDownloadTab.this.getSelectedDownloadFile();
                if (file == null) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(file.isPreviewPossible());
                }
            }
            catch (Throwable th) {
                NLogger.error(GeneratePreviewAction.class, th, th);
            }
        }
    }

    class SelectStrategyAction
    extends FWToggleAction {
        private static final short AVAILABILITY = 0;
        private static final short PRIORITIZE_BEGINNING = 1;
        private static final short PRIORITIZE_BEGINNING_END = 2;
        private static final short RANDOM = 3;
        private short strategy;

        SelectStrategyAction(short strategy) {
            this.strategy = strategy;
            switch (strategy) {
                case 0: {
                    this.setName(Localizer.getString("DownloadTab_StrategyAvailability"));
                    break;
                }
                case 1: {
                    this.setName(Localizer.getString("DownloadTab_StrategyBeginning"));
                    break;
                }
                case 2: {
                    this.setName(Localizer.getString("DownloadTab_StrategyBeginningEnd"));
                    break;
                }
                case 3: {
                    this.setName(Localizer.getString("DownloadTab_StrategyRandom"));
                }
            }
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            ScopeSelectionStrategy selectionStrategy;
            switch (this.strategy) {
                case 0: {
                    selectionStrategy = ScopeSelectionStrategyProvider.getAvailBeginRandSelectionStrategy();
                    break;
                }
                case 1: {
                    selectionStrategy = ScopeSelectionStrategyProvider.getBeginAvailRandSelectionStrategy();
                    break;
                }
                case 2: {
                    selectionStrategy = ScopeSelectionStrategyProvider.getBeginEndAvailRandSelectionStrategy();
                    break;
                }
                default: {
                    selectionStrategy = ScopeSelectionStrategyProvider.getRandomSelectionStrategy();
                }
            }
            SWDownloadFile[] files = SWDownloadTab.this.getSelectedDownloadFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null) continue;
                files[i].getMemoryFile().setScopeSelectionStrategy(selectionStrategy);
            }
        }

        public void refreshActionState() {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
                SWDownloadFile file = SWDownloadTab.this.getSelectedDownloadFile();
                if (file == null) {
                    this.setSelected(false);
                    return;
                }
                ScopeSelectionStrategy curStrat = file.getMemoryFile().getScopeSelectionStrategy();
                switch (this.strategy) {
                    case 0: {
                        this.setSelected(curStrat instanceof AvailBeginRandSelectionStrategy);
                        break;
                    }
                    case 1: {
                        this.setSelected(curStrat instanceof BeginAvailRandSelectionStrategy);
                        break;
                    }
                    case 2: {
                        this.setSelected(curStrat instanceof BeginEndAvailRandSelectionStrategy);
                        break;
                    }
                    default: {
                        this.setSelected(curStrat instanceof RandomScopeSelectionStrategy);
                        break;
                    }
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    class MoveDownloadPriorityAction
    extends FWAction {
        private static final short PRIORITY_MOVE_TO_TOP = 0;
        private static final short PRIORITY_MOVE_UP = 1;
        private static final short PRIORITY_MOVE_DOWN = 2;
        private static final short PRIORITY_MOVE_TO_BOTTOM = 3;
        private static final short PRIORITY_RESORT = 100;
        private short moveDirection;

        MoveDownloadPriorityAction(short type) {
            this.moveDirection = type;
            switch (type) {
                case 0: {
                    this.setName(Localizer.getString("MoveToTop"));
                    this.setToolTipText(Localizer.getString("TTTMoveToTop"));
                    break;
                }
                case 1: {
                    this.setName(Localizer.getString("MoveUp"));
                    this.setToolTipText(Localizer.getString("TTTMoveUp"));
                    break;
                }
                case 2: {
                    this.setName(Localizer.getString("MoveDown"));
                    this.setToolTipText(Localizer.getString("TTTMoveDown"));
                    break;
                }
                case 3: {
                    this.setName(Localizer.getString("MoveToBottom"));
                    this.setToolTipText(Localizer.getString("TTTMoveToBottom"));
                    break;
                }
                case 100: {
                    this.setName(Localizer.getString("Resort"));
                    this.setToolTipText(Localizer.getString("TTTResort"));
                }
            }
            this.setupIcons();
            this.refreshActionState();
        }

        private void setupIcons() {
            IconPack iconPack = GUIRegistry.getInstance().getPlafIconPack();
            switch (this.moveDirection) {
                case 0: {
                    this.setSmallIcon(iconPack.getIcon("Download.PriorityTop"));
                    break;
                }
                case 1: {
                    this.setSmallIcon(iconPack.getIcon("Download.PriorityUp"));
                    break;
                }
                case 2: {
                    this.setSmallIcon(iconPack.getIcon("Download.PriorityDown"));
                    break;
                }
                case 3: {
                    this.setSmallIcon(iconPack.getIcon("Download.PriorityBottom"));
                    break;
                }
                case 100: {
                    this.setSmallIcon(iconPack.getIcon("Download.PriorityResort"));
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.moveDirection == 100) {
                    this.performPriorityResort();
                } else {
                    this.performPriorityUpdate();
                }
            }
            catch (Throwable th) {
                NLogger.error(MoveDownloadPriorityAction.class, th, th);
            }
        }

        private void performPriorityResort() {
            int[] viewIndices = new int[SWDownloadTab.this.downloadTable.getRowCount()];
            for (int i = 0; i < viewIndices.length; ++i) {
                viewIndices[i] = i;
            }
            final int[] modelIndices = SWDownloadTab.this.downloadTable.convertRowIndicesToModel(viewIndices);
            Runnable runner = new Runnable(){

                public void run() {
                    try {
                        SWDownloadFile[] files = SWDownloadTab.this.downloadService.getDownloadFilesAt(modelIndices);
                        SWDownloadTab.this.downloadService.updateDownloadFilePriorities(files);
                    }
                    catch (Throwable th) {
                        NLogger.error(MoveDownloadPriorityAction.class, th, th);
                    }
                }
            };
            Environment.getInstance().executeOnThreadPool(runner, "ResortPriority");
        }

        private void performPriorityUpdate() {
            final SWDownloadFile[] files = SWDownloadTab.this.getSelectedDownloadFiles();
            Runnable runner = new Runnable(){

                public void run() {
                    try {
                        for (int i = 0; i < files.length; ++i) {
                            if (files[i] == null) continue;
                            SWDownloadTab.this.downloadService.moveDownloadFilePriority(files[i], MoveDownloadPriorityAction.this.moveDirection);
                        }
                    }
                    catch (Throwable th) {
                        NLogger.error(MoveDownloadPriorityAction.class, th, th);
                    }
                }
            };
            Environment.getInstance().executeOnThreadPool(runner, "UpdatePriority");
        }

        public void refreshActionState() {
            if (this.moveDirection == 100) {
                this.setEnabled(true);
            } else if (SWDownloadTab.this.downloadTable.getSelectedRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class SetDownloadSpeedAction
    extends FWAction {
        private int speedInBytes;

        SetDownloadSpeedAction(int speedInBytes) {
            this.speedInBytes = speedInBytes;
            String name = speedInBytes >= Integer.MAX_VALUE ? Localizer.getString("DownloadTab_NoLimit") + " (" + Localizer.getDecimalFormatSymbols().getInfinity() + ")" : NumberFormatUtils.formatSignificantByteSize(speedInBytes) + Localizer.getString("PerSec");
            this.setName(name);
        }

        public void actionPerformed(ActionEvent e) {
            SWDownloadFile[] files = SWDownloadTab.this.getSelectedDownloadFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null) continue;
                files[i].setDownloadThrottlingRate(this.speedInBytes);
            }
        }

        public void refreshActionState() {
        }
    }

    class RemoveDownloadAction
    extends FWAction {
        RemoveDownloadAction() {
            super(Localizer.getString("RemoveDownload"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Download.RemoveDownload"), Localizer.getString("TTTRemoveDownload"), null, KeyStroke.getKeyStroke(127, 0));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            SWDownloadFile[] files = SWDownloadTab.this.getSelectedDownloadFiles();
            ArrayList<SWDownloadFile> warningFiles = new ArrayList<SWDownloadFile>(files.length);
            ArrayList<SWDownloadFile> removeFiles = new ArrayList<SWDownloadFile>(files.length);
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null) continue;
                if (files[i].isFileCompletedMoved()) {
                    removeFiles.add(files[i]);
                    continue;
                }
                if (files[i].isFileCompleted()) continue;
                if (files[i].getTransferredDataSize() == 0L) {
                    removeFiles.add(files[i]);
                    continue;
                }
                warningFiles.add(files[i]);
            }
            Integer warningSize = warningFiles.size();
            for (int i = 0; i < warningSize; ++i) {
                SWDownloadFile file = (SWDownloadFile)warningFiles.get(i);
                Object[] warningParams = new Object[]{file.getFileName(), NumberFormatUtils.formatSignificantByteSize(file.getTransferredDataSize()), NumberFormatUtils.formatSignificantByteSize(file.getTransferDataSize())};
                Object[] titleParams = new Object[]{i + 1, warningSize};
                Object[] dialogOptions = warningSize - i > 1 ? new Object[]{Localizer.getString("Yes"), Localizer.getString("No"), Localizer.getString("YesToAll"), Localizer.getString("NoToAll")} : new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                int choice = JOptionPane.showOptionDialog(GUIRegistry.getInstance().getMainFrame(), Localizer.getFormatedString("RemoveDownloadWarning", warningParams), Localizer.getFormatedString("RemoveDownloadTitle", titleParams), 0, 2, null, dialogOptions, Localizer.getString("Yes"));
                if (choice == 0) {
                    removeFiles.add(file);
                    continue;
                }
                if (choice == 2) {
                    removeFiles.addAll(warningFiles.subList(i, warningFiles.size()));
                    break;
                }
                if (choice == 3) break;
            }
            if (removeFiles.size() > 0) {
                final SWDownloadFile[] filesToRemove = new SWDownloadFile[removeFiles.size()];
                removeFiles.toArray(filesToRemove);
                Runnable runner = new Runnable(){

                    public void run() {
                        try {
                            SWDownloadTab.this.downloadService.removeDownloadFiles(filesToRemove);
                        }
                        catch (Throwable th) {
                            NLogger.error(RemoveDownloadAction.class, th, th);
                        }
                    }
                };
                Environment.getInstance().executeOnThreadPool(runner, "RemoveDownloadFiles");
                SWDownloadTab.this.downloadTable.getSelectionModel().clearSelection();
            }
        }

        public void refreshActionState() {
            int row = SWDownloadTab.this.downloadTable.getSelectedRow();
            if (row < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class ConfigureDownloadAction
    extends FWAction {
        ConfigureDownloadAction() {
            super(Localizer.getString("ConfigureDownload"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Download.ConfigureDownload"), Localizer.getString("TTTConfigureDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() != 1) {
                this.setEnabled(false);
                return;
            }
            int viewIdx = SWDownloadTab.this.downloadTable.getSelectedRow();
            int modelIdx = SWDownloadTab.this.downloadTable.translateRowIndexToModel(viewIdx);
            SWDownloadFile dfile = SWDownloadTab.this.downloadService.getDownloadFile(modelIdx);
            if (dfile != null) {
                if (dfile.isDownloadInProgress()) {
                    JOptionPane.showMessageDialog(SWDownloadTab.this, Localizer.getString("NoConfigDownloadInProgress"), Localizer.getString("DownloadInProgress"), 2);
                    return;
                }
                int oldStatus = dfile.getStatus();
                dfile.stopDownload();
                DownloadConfigDialog dialog = new DownloadConfigDialog(dfile);
                dialog.setVisible(true);
                dfile.setStatus(oldStatus);
            }
        }

        public void refreshActionState() {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() != 1) {
                this.setEnabled(false);
                return;
            }
            SWDownloadFile file = SWDownloadTab.this.getSelectedDownloadFile();
            if (file == null || file.isFileCompletedOrMoved()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class StopDownloadAction
    extends FWAction {
        StopDownloadAction() {
            super(Localizer.getString("StopDownload"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Download.StopDownload"), Localizer.getString("TTTStopDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            final SWDownloadFile[] files = SWDownloadTab.this.getSelectedDownloadFiles();
            Runnable runner = new Runnable(){

                public void run() {
                    try {
                        for (int i = 0; i < files.length; ++i) {
                            if (files[i] == null || files[i].isFileCompletedOrMoved() || files[i].isDownloadStopped()) continue;
                            files[i].stopDownload();
                        }
                        StopDownloadAction.this.refreshActionState();
                    }
                    catch (Throwable th) {
                        NLogger.error(StopDownloadAction.class, th, th);
                    }
                }
            };
            Environment.getInstance().executeOnThreadPool(runner, "StopDownloadFiles");
        }

        public void refreshActionState() {
            SWDownloadFile[] files = SWDownloadTab.this.getSelectedDownloadFiles();
            boolean state = false;
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null || files[i].isFileCompletedOrMoved() || files[i].isDownloadStopped()) continue;
                state = true;
                break;
            }
            this.setEnabled(state);
        }
    }

    class StartDownloadAction
    extends FWAction {
        StartDownloadAction() {
            super(Localizer.getString("StartDownload"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Download.StartDownload"), Localizer.getString("TTTStartDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            SWDownloadFile[] files = SWDownloadTab.this.getSelectedDownloadFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null || !files[i].isDownloadStopped()) continue;
                files[i].startDownload();
            }
            this.refreshActionState();
        }

        public void refreshActionState() {
            SWDownloadFile[] files = SWDownloadTab.this.getSelectedDownloadFiles();
            boolean state = false;
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null || !files[i].isDownloadStopped()) continue;
                state = true;
                break;
            }
            this.setEnabled(state);
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        private void popupMenu(Component source, int x, int y) {
            if (source == SWDownloadTab.this.downloadTable || source == SWDownloadTab.this.downloadTableScrollPane) {
                SWDownloadTab.this.refreshTabActions();
                this.prepareDownloadPopup();
                SWDownloadTab.this.downloadPopup.show(source, x, y);
            } else if (source == SWDownloadTab.this.candidateTable || source == SWDownloadTab.this.candidateTableScrollPane) {
                SWDownloadTab.this.candidatePopup.show(source, x, y);
            }
        }

        public void prepareDownloadPopup() {
            SWDownloadTab.this.downloadPopupSpeedMenu.removeAll();
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() <= 0) {
                SWDownloadTab.this.downloadPopupSpeedMenu.setEnabled(false);
                return;
            }
            SWDownloadTab.this.downloadPopupSpeedMenu.setEnabled(true);
            int downloadBw = BandwidthPrefs.MaxDownloadBandwidth.get();
            if (downloadBw > BandwidthPrefs.MaxTotalBandwidth.get()) {
                downloadBw = BandwidthPrefs.MaxTotalBandwidth.get();
            }
            if (downloadBw >= Integer.MAX_VALUE) {
                downloadBw = 512000;
            }
            double downloadBwFraction = (double)downloadBw / 10.0;
            SetDownloadSpeedAction action = new SetDownloadSpeedAction(Integer.MAX_VALUE);
            SWDownloadTab.this.downloadPopupSpeedMenu.add(action);
            for (int i = 10; i > 0; --i) {
                action = new SetDownloadSpeedAction((int)(downloadBwFraction * (double)i));
                SWDownloadTab.this.downloadPopupSpeedMenu.add(action);
            }
        }
    }

    class CandidateSelectionHandler
    implements ListSelectionListener {
        CandidateSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                SWDownloadTab.this.refreshTabActions();
            }
        }
    }

    class DownloadSelectionHandler
    implements ListSelectionListener {
        DownloadSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            try {
                SWDownloadTab.this.updateDownloadFileInfo();
            }
            catch (Exception exp) {
                NLogger.error(DownloadSelectionHandler.class, exp, exp);
            }
        }
    }
}

