/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.renderer;

import java.awt.Component;
import javax.swing.JTable;
import phex.common.TransferDataProvider;
import phex.common.format.NumberFormatUtils;
import phex.gui.renderer.CellColorHandler;
import phex.gui.renderer.FWTableCellRenderer;

public class TransferSizeCellRenderer
extends FWTableCellRenderer {
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof TransferDataProvider) {
            TransferDataProvider provider = (TransferDataProvider)value;
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
            } else {
                CellColorHandler.applyCellColor(provider, this);
            }
            long transferredSize = provider.getTransferredDataSize();
            long transferSize = provider.getTransferDataSize();
            StringBuffer buffer = new StringBuffer();
            buffer.append(NumberFormatUtils.formatSignificantByteSize(transferredSize));
            if (transferSize > -1L) {
                buffer.append(" / ");
                buffer.append(NumberFormatUtils.formatSignificantByteSize(transferSize));
            }
            this.setText(buffer.toString());
        } else {
            this.setText("");
        }
        return this;
    }
}

