/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.prefs;

import phex.common.Environment;
import phex.common.PhexVersion;
import phex.gui.prefs.InterfacePrefs;
import phex.gui.prefs.NetworkTabPrefs;
import phex.gui.prefs.SearchTabPrefs;
import phex.gui.prefs.UpdatePrefs;
import phex.prefs.OldCfg;
import phex.prefs.api.Preferences;
import phex.utils.StringUtils;

public class PhexGuiPrefs
extends Preferences {
    protected static final PhexGuiPrefs instance = new PhexGuiPrefs();

    protected PhexGuiPrefs() {
        super(Environment.getInstance().getPhexConfigFile("phexGuiPrefs.properties"));
    }

    public static void init() {
        instance.load();
        instance.updatePreferences();
    }

    public static void save(boolean force) {
        if (force) {
            instance.saveRequiredNotify();
        }
        instance.save();
    }

    public void updatePreferences() {
        if (StringUtils.isEmpty(UpdatePrefs.RunningBuildNumber.get())) {
            UpdatePrefs.ShowConfigWizard.set(Boolean.TRUE);
        }
        UpdatePrefs.RunningBuildNumber.set(PhexVersion.getBuild());
        UpdatePrefs.RunningPhexVersion.set(PhexVersion.getVersion());
    }

    public static void updatePreV30Config(OldCfg cfg) {
        InterfacePrefs.LocaleName.set(cfg.usedLocale != null ? cfg.usedLocale : "");
        InterfacePrefs.MinimizeToBackground.set(cfg.minimizeToBackground);
        InterfacePrefs.ShowCloseOptionsDialog.set(cfg.showCloseOptionsDialog);
        InterfacePrefs.ShowBetaUpdateNotification.set(cfg.showBetaUpdateNotification);
        NetworkTabPrefs.ConnectToHistory.set(cfg.connectToHistory);
        NetworkTabPrefs.MaxConnectToHistorySize.set(cfg.maxConnectToHistorySize);
        NetworkTabPrefs.HostErrorDisplayTime.set(cfg.hostErrorDisplayTime);
        SearchTabPrefs.BrowseHostHistory.set(cfg.browseHostHistory);
        SearchTabPrefs.SearchTermHistory.set(cfg.searchTermHistory);
        SearchTabPrefs.MaxSearchHistorySize.set(cfg.maxSearchTermHistorySize);
        UpdatePrefs.ShowConfigWizard.set(Boolean.TRUE);
    }
}

