/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.prefs.core.LibraryPrefs;
import phex.prefs.core.UploadPrefs;
import phex.utils.Localizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharingPane
extends OptionsSettingsPane {
    private static final String SIMULTANEOUS_UPLOADS_KEY = "SimultaneousUploads";
    private static final String UPLOADS_PER_HOST_KEY = "UploadsPerHost";
    private static final String RETURNED_SEARCH_LIMIT_KEY = "ReturnedSearchLimit";
    private static final String QUEUE_LIMIT_KEY = "QueueLimit";
    private static final String MIN_POLL_TIME_KEY = "UploadQueueMinPollTime";
    private static final String MAX_POLL_TIME_KEY = "UploadQueueMaxPollTime";
    private static final String SEARCH_HIT_LIMIT_ERROR_KEY = "SearchHitLimitError";
    private IntegerTextField simultaneousUploadsTF;
    private IntegerTextField uploadsPerHostTF;
    private IntegerTextField returnedSearchLimitTF;
    private JCheckBox allowUploadQueuingChkbx;
    private JLabel queueLimitLabel;
    private IntegerTextField queueLimitTF;
    private JLabel minPollTimeLabel;
    private IntegerTextField minPollTimeTF;
    private JLabel maxPollTimeLabel;
    private IntegerTextField maxPollTimeTF;
    private JCheckBox removeCompletedUploadsChkbx;
    private JCheckBox sharePartialFilesChkbx;
    private JCheckBox allowBrowsingChkbx;

    public SharingPane() {
        super("Sharing");
    }

    @Override
    protected void prepareComponent() {
        FormLayout layout = new FormLayout("10dlu, right:d, 2dlu, d, 10dlu, right:d, 2dlu, d, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 9dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        layout.setRowGroups((int[][])new int[][]{{3, 5, 7, 9, 13, 15, 17}});
        this.setLayout((LayoutManager)layout);
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        CellConstraints cc2 = new CellConstraints();
        builder.addSeparator(Localizer.getString("GeneralUploadSettings"), cc.xywh(1, 1, 9, 1));
        this.simultaneousUploadsTF = new IntegerTextField(UploadPrefs.MaxParallelUploads.get().toString(), 6, 3);
        builder.addLabel(Localizer.getString("MaxParallelUploads") + ": ", cc.xy(2, 3), (Component)this.simultaneousUploadsTF, cc2.xy(4, 3));
        this.uploadsPerHostTF = new IntegerTextField(UploadPrefs.MaxUploadsPerIP.get().toString(), 6, 2);
        builder.addLabel(Localizer.getString("MaxUploadsPerHost") + ": ", cc.xy(6, 3), (Component)this.uploadsPerHostTF, cc2.xy(8, 3));
        builder.addLabel(Localizer.getString("MaxReturnedSearchHits") + ": ", cc.xy(2, 5));
        this.returnedSearchLimitTF = new IntegerTextField(String.valueOf(LibraryPrefs.MaxResultsPerQuery.get().toString()), 6, 3);
        builder.add((Component)this.returnedSearchLimitTF, cc.xy(4, 5));
        this.allowBrowsingChkbx = new JCheckBox(Localizer.getString("AllowBrowsingDirectories"), (boolean)LibraryPrefs.AllowBrowsing.get());
        builder.add((Component)this.allowBrowsingChkbx, cc.xywh(2, 7, 3, 1));
        this.sharePartialFilesChkbx = new JCheckBox(Localizer.getString("SharePartialFiles"), (boolean)UploadPrefs.SharePartialFiles.get());
        builder.add((Component)this.sharePartialFilesChkbx, cc.xywh(6, 7, 3, 1));
        this.removeCompletedUploadsChkbx = new JCheckBox(Localizer.getString("AutoCleanFinishedUploads"), (boolean)UploadPrefs.AutoRemoveCompleted.get());
        builder.add((Component)this.removeCompletedUploadsChkbx, cc.xywh(2, 9, 3, 1));
        builder.addSeparator(Localizer.getString("UploadQueuing"), cc.xywh(1, 11, 9, 1));
        this.allowUploadQueuingChkbx = new JCheckBox(Localizer.getString("AllowUploadQueuing"), (boolean)UploadPrefs.AllowQueuing.get());
        this.allowUploadQueuingChkbx.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SharingPane.this.refreshEnableState();
            }
        });
        builder.add((Component)this.allowUploadQueuingChkbx, cc.xywh(2, 13, 4, 1));
        this.queueLimitLabel = builder.addLabel(Localizer.getString("MaxQueueLength") + ": ", cc.xy(2, 15));
        this.queueLimitTF = new IntegerTextField(UploadPrefs.MaxQueueSize.get().toString(), 6, 2);
        builder.add((Component)this.queueLimitTF, cc.xy(4, 15));
        this.minPollTimeLabel = builder.addLabel(Localizer.getString("MinPollTime") + ": ", cc.xy(2, 17));
        this.minPollTimeTF = new IntegerTextField(UploadPrefs.MinQueuePollTime.get().toString(), 6, 3);
        builder.add((Component)this.minPollTimeTF, cc.xy(4, 17));
        this.maxPollTimeLabel = builder.addLabel(Localizer.getString("MaxPollTime") + ": ", cc.xy(6, 17));
        this.maxPollTimeTF = new IntegerTextField(UploadPrefs.MaxQueuePollTime.get().toString(), 6, 3);
        builder.add((Component)this.maxPollTimeTF, cc.xy(8, 17));
        this.refreshEnableState();
    }

    public void checkInput(HashMap inputDic) {
        try {
            String simultaneousUploadsStr = this.simultaneousUploadsTF.getText();
            Integer simultaneousUploads = Integer.valueOf(simultaneousUploadsStr);
            inputDic.put(SIMULTANEOUS_UPLOADS_KEY, simultaneousUploads);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.simultaneousUploadsTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String uploadsPerHostStr = this.uploadsPerHostTF.getText();
            Integer uploadsPerHost = Integer.valueOf(uploadsPerHostStr);
            inputDic.put(UPLOADS_PER_HOST_KEY, uploadsPerHost);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.uploadsPerHostTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String returnedSearchLimitStr = this.returnedSearchLimitTF.getText();
            Integer returnedSearchLimit = Integer.valueOf(returnedSearchLimitStr);
            if (returnedSearchLimit > 255) {
                inputDic.put(SEARCH_HIT_LIMIT_ERROR_KEY, returnedSearchLimit);
                this.setInputValid(inputDic, false);
                return;
            }
            inputDic.put(RETURNED_SEARCH_LIMIT_KEY, returnedSearchLimit);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.returnedSearchLimitTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String queueLimitStr = this.queueLimitTF.getText();
            Integer queueLimit = Integer.valueOf(queueLimitStr);
            inputDic.put(QUEUE_LIMIT_KEY, queueLimit);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.queueLimitTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String minPollTimeStr = this.minPollTimeTF.getText();
            Integer minPollTime = Integer.valueOf(minPollTimeStr);
            inputDic.put(MIN_POLL_TIME_KEY, minPollTime);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.minPollTimeTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String maxPollTimeStr = this.maxPollTimeTF.getText();
            Integer maxPollTime = Integer.valueOf(maxPollTimeStr);
            inputDic.put(MAX_POLL_TIME_KEY, maxPollTime);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.maxPollTimeTF);
            this.setInputValid(inputDic, false);
            return;
        }
        this.setInputValid(inputDic, true);
    }

    public void displayErrorMessage(HashMap inputDic) {
        if (inputDic.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(inputDic);
        } else if (inputDic.containsKey(SEARCH_HIT_LIMIT_ERROR_KEY)) {
            this.returnedSearchLimitTF.setText("255");
            this.returnedSearchLimitTF.requestFocus();
            this.returnedSearchLimitTF.selectAll();
            GUIUtils.showErrorMessage(Localizer.getString("ExceedSearchHitLimit"), Localizer.getString("Error"));
        }
    }

    @Override
    public void saveAndApplyChanges(HashMap<String, Object> inputDic) {
        Integer simultaneousUploadsInt = (Integer)inputDic.get(SIMULTANEOUS_UPLOADS_KEY);
        UploadPrefs.MaxParallelUploads.set(simultaneousUploadsInt);
        Integer uploadsPerHostInt = (Integer)inputDic.get(UPLOADS_PER_HOST_KEY);
        UploadPrefs.MaxUploadsPerIP.set(uploadsPerHostInt);
        Integer returnedSearchLimitInt = (Integer)inputDic.get(RETURNED_SEARCH_LIMIT_KEY);
        LibraryPrefs.MaxResultsPerQuery.set(returnedSearchLimitInt);
        boolean allowUploadQueuing = this.allowUploadQueuingChkbx.isSelected();
        UploadPrefs.AllowQueuing.set(allowUploadQueuing);
        Integer queueLimitInt = (Integer)inputDic.get(QUEUE_LIMIT_KEY);
        UploadPrefs.MaxQueueSize.set(queueLimitInt);
        Integer minPollTimeInt = (Integer)inputDic.get(MIN_POLL_TIME_KEY);
        UploadPrefs.MinQueuePollTime.set(minPollTimeInt);
        Integer maxPollTimeInt = (Integer)inputDic.get(MAX_POLL_TIME_KEY);
        UploadPrefs.MaxQueuePollTime.set(maxPollTimeInt);
        boolean sharePartialFiles = this.sharePartialFilesChkbx.isSelected();
        UploadPrefs.SharePartialFiles.set(sharePartialFiles);
        boolean removeCompletedUploads = this.removeCompletedUploadsChkbx.isSelected();
        UploadPrefs.AutoRemoveCompleted.set(removeCompletedUploads);
        boolean allowBrowsing = this.allowBrowsingChkbx.isSelected();
        LibraryPrefs.AllowBrowsing.set(allowBrowsing);
    }

    private void refreshEnableState() {
        boolean enableState = this.allowUploadQueuingChkbx.isSelected();
        this.queueLimitLabel.setEnabled(enableState);
        this.queueLimitTF.setEnabled(enableState);
        this.minPollTimeLabel.setEnabled(enableState);
        this.minPollTimeTF.setEnabled(enableState);
        this.maxPollTimeLabel.setEnabled(enableState);
        this.maxPollTimeTF.setEnabled(enableState);
    }
}

