/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import phex.gui.dialogs.filter.RuleDescriptionVisualizer;
import phex.rules.consequence.BanHostConsequence;
import phex.rules.consequence.Consequence;
import phex.rules.consequence.DownloadFileConsequence;
import phex.rules.consequence.FilterFromSearchConsequence;
import phex.rules.consequence.RemoveFromSearchConsequence;
import phex.utils.Localizer;

public class ConsequenceVisualizer {
    public static String buildDisplayString(Consequence consequence) {
        if (consequence instanceof FilterFromSearchConsequence) {
            String displayString = Localizer.getString("RuleVisualization_HideFromSearchConseq");
            return displayString;
        }
        if (consequence instanceof RemoveFromSearchConsequence) {
            String displayString = Localizer.getString("RuleVisualization_RemoveFromSearchConseq");
            return displayString;
        }
        if (consequence instanceof DownloadFileConsequence) {
            String displayString = Localizer.getString("RuleVisualization_DownloadFileConseq");
            return displayString;
        }
        if (consequence instanceof BanHostConsequence) {
            String displayString = Localizer.getString("RuleVisualization_BanHostConseq");
            return displayString;
        }
        throw new IllegalArgumentException("Unknown consequence to visualize: " + consequence);
    }

    public static String buildCleanDisplayString(Consequence consequence) {
        String displayString = ConsequenceVisualizer.buildDisplayString(consequence);
        return RuleDescriptionVisualizer.cleanDisplayString(displayString);
    }

    public static void visualize(Consequence consequence, boolean isAndConcat, Document doc) throws BadLocationException {
        RuleDescriptionVisualizer.visualizeNext(isAndConcat, consequence, doc);
        String displayString = ConsequenceVisualizer.buildDisplayString(consequence);
        RuleDescriptionVisualizer.insertDisplayString(displayString, consequence, doc);
    }
}

