/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter;

import java.util.Iterator;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import phex.common.MediaType;
import phex.common.URN;
import phex.common.format.NumberFormatUtils;
import phex.gui.dialogs.filter.RuleDescriptionVisualizer;
import phex.rules.condition.Condition;
import phex.rules.condition.FileSizeCondition;
import phex.rules.condition.FileUrnCondition;
import phex.rules.condition.FilenameCondition;
import phex.rules.condition.MediaTypeCondition;
import phex.rules.condition.NotCondition;
import phex.utils.Localizer;

public class ConditionVisualizer {
    public static String buildDisplayString(Condition condition) {
        String postfix = "";
        if (condition instanceof NotCondition) {
            postfix = "_Not";
            condition = ((NotCondition)condition).getContainedCondition();
        }
        if (condition instanceof FilenameCondition) {
            FilenameCondition filenameCondition = (FilenameCondition)condition;
            String conditionString = Localizer.getString("RuleVisualization_FilenameCond" + postfix);
            Set<String> terms = filenameCondition.getTerms();
            if (terms.size() > 0) {
                Iterator<String> iterator = terms.iterator();
                StringBuffer buffer = new StringBuffer();
                while (iterator.hasNext()) {
                    String term = iterator.next();
                    buffer.append("'").append(term).append("'");
                    if (!iterator.hasNext()) continue;
                    buffer.append(" ").append(Localizer.getString("RuleVisualization_Or")).append(" ");
                }
                String replacement = buffer.toString();
                conditionString = RuleDescriptionVisualizer.replacePlaceholderPattern(conditionString, replacement);
            }
            return conditionString;
        }
        if (condition instanceof FileUrnCondition) {
            FileUrnCondition fileUrnCondition = (FileUrnCondition)condition;
            String conditionString = Localizer.getString("RuleVisualization_FileUrnCond" + postfix);
            Set<URN> urns = fileUrnCondition.getUrnSet();
            if (urns.size() > 0) {
                Iterator<URN> iterator = urns.iterator();
                StringBuffer buffer = new StringBuffer();
                while (iterator.hasNext()) {
                    URN urn = iterator.next();
                    buffer.append("'").append(urn.getAsString()).append("'");
                    if (!iterator.hasNext()) continue;
                    buffer.append(" ").append(Localizer.getString("RuleVisualization_Or")).append(" ");
                }
                String replacement = buffer.toString();
                conditionString = RuleDescriptionVisualizer.replacePlaceholderPattern(conditionString, replacement);
            }
            return conditionString;
        }
        if (condition instanceof MediaTypeCondition) {
            MediaTypeCondition mediaTypeCondition = (MediaTypeCondition)condition;
            String conditionString = Localizer.getString("RuleVisualization_MediaTypeCond" + postfix);
            Set<MediaType> types = mediaTypeCondition.getTypes();
            if (types.size() > 0) {
                Iterator<MediaType> iterator = types.iterator();
                StringBuffer buffer = new StringBuffer();
                while (iterator.hasNext()) {
                    MediaType type = iterator.next();
                    buffer.append("'").append(Localizer.getString(type.getName())).append("'");
                    if (!iterator.hasNext()) continue;
                    buffer.append(" ").append(Localizer.getString("RuleVisualization_Or")).append(" ");
                }
                String replacement = buffer.toString();
                conditionString = RuleDescriptionVisualizer.replacePlaceholderPattern(conditionString, replacement);
            }
            return conditionString;
        }
        if (condition instanceof FileSizeCondition) {
            FileSizeCondition fileSizeCondition = (FileSizeCondition)condition;
            String conditionString = Localizer.getString("RuleVisualization_FileSizeCond" + postfix);
            Set<FileSizeCondition.Range> ranges = fileSizeCondition.getRanges();
            if (ranges.size() > 0) {
                Iterator<FileSizeCondition.Range> iterator = ranges.iterator();
                StringBuffer buffer = new StringBuffer();
                while (iterator.hasNext()) {
                    FileSizeCondition.Range range = iterator.next();
                    ConditionVisualizer.visualizeFileSizeRange(buffer, range);
                    if (!iterator.hasNext()) continue;
                    buffer.append(" ").append(Localizer.getString("RuleVisualization_Or")).append(" ");
                }
                String replacement = buffer.toString();
                conditionString = RuleDescriptionVisualizer.replacePlaceholderPattern(conditionString, replacement);
            }
            return conditionString;
        }
        throw new IllegalArgumentException("Unknown condition to visualize: " + condition);
    }

    public static String buildCleanDisplayString(Condition condition) {
        String displayString = ConditionVisualizer.buildDisplayString(condition);
        return RuleDescriptionVisualizer.cleanDisplayString(displayString);
    }

    public static void visualize(Condition condition, boolean isAndCondition, Document doc) throws BadLocationException {
        RuleDescriptionVisualizer.visualizeNext(isAndCondition, condition, doc);
        String displayString = ConditionVisualizer.buildDisplayString(condition);
        RuleDescriptionVisualizer.insertDisplayString(displayString, condition, doc);
    }

    public static void visualizeFileSizeRange(StringBuffer buffer, FileSizeCondition.Range range) {
        if (range.min > 0L) {
            buffer.append(Localizer.getString("RuleVisualization_FileSizeCond_Min")).append(" ").append(NumberFormatUtils.formatSignificantByteSize(range.min));
        }
        if (range.min > 0L && range.max > 0L) {
            buffer.append(" ").append(Localizer.getString("RuleVisualization_And")).append(" ");
        }
        if (range.max > 0L) {
            buffer.append(Localizer.getString("RuleVisualization_FileSizeCond_Max")).append(" ").append(NumberFormatUtils.formatSignificantByteSize(range.max));
        }
    }
}

