/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import phex.common.log.NLogger;
import phex.gui.actions.FWAction;
import phex.gui.actions.FWActionGroup;
import phex.gui.common.DialogBanner;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.dialogs.filter.RuleDescOwnerDialog;
import phex.gui.dialogs.filter.RuleDescriptionPanel;
import phex.gui.dialogs.filter.RuleEditWrapper;
import phex.gui.dialogs.filter.SearchFilterRulesEditModel;
import phex.gui.dialogs.filter.wizard.FilterWizardDialog;
import phex.rules.Rule;
import phex.rules.SearchFilterRules;
import phex.utils.Localizer;

public class AdvSearchRulesDialog
extends JDialog
implements RuleDescOwnerDialog {
    private FWActionGroup actionGroup = new FWActionGroup();
    private SearchFilterRulesEditModel editModel;
    private JList ruleList;
    private RuleDescriptionPanel ruleDescPanel;

    public AdvSearchRulesDialog(SearchFilterRules currentRules) {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("AdvSearchRules_DialogTitle"), false);
        this.editModel = new SearchFilterRulesEditModel(currentRules);
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("4dlu, fill:d:grow, 4dlu", "p, p, 4dlu, p, p, 8dlu, p, 2dlu, fill:90dlu:grow, 8dlu, fill:p:grow, 12dlu,p, 2dlu, p 4dlu");
        PanelBuilder contentPB = new PanelBuilder(layout, contentPanel);
        int columnCount = layout.getColumnCount();
        int rowCount = layout.getRowCount();
        DialogBanner banner = new DialogBanner(Localizer.getString("AdvSearchRules_BannerHeader"), Localizer.getString("AdvSearchRules_BannerSubHeader"));
        contentPB.add((Component)banner, cc.xywh(1, 1, columnCount, 1));
        contentPB.add((Component)new JSeparator(), cc.xywh(1, 2, columnCount, 1));
        FWToolBar ruleBar = new FWToolBar(0);
        ruleBar.setBorderPainted(false);
        ruleBar.setFloatable(false);
        ruleBar.setShowText(true);
        contentPB.add((Component)ruleBar, cc.xywh(2, 4, 1, 1));
        contentPB.add((Component)new JSeparator(), cc.xywh(2, 5, 1, 1));
        JLabel label = new JLabel(Localizer.getString("AdvSearchRules_RuleListDescription"));
        contentPB.add((Component)label, cc.xywh(2, 7, 1, 1));
        this.ruleList = new JList();
        this.ruleList.setModel(this.editModel);
        this.ruleList.setCellRenderer(new RuleListCellRenderer());
        this.ruleList.getSelectionModel().addListSelectionListener(new RuleListSelectionListener());
        contentPB.add((Component)new JScrollPane(this.ruleList), cc.xywh(2, 9, 1, 1));
        this.ruleDescPanel = new RuleDescriptionPanel(this);
        contentPB.add((Component)this.ruleDescPanel, cc.xywh(2, 11, 1, 1));
        contentPB.add((Component)new JSeparator(), cc.xywh(1, rowCount - 3, columnCount, 1));
        JButton okBtn = new JButton(Localizer.getString("OK"));
        okBtn.setDefaultCapable(true);
        okBtn.setRequestFocusEnabled(true);
        okBtn.addActionListener(new OkBtnListener());
        JButton cancelBtn = new JButton(Localizer.getString("Cancel"));
        cancelBtn.addActionListener(closeEventHandler);
        JButton applyBtn = new JButton(Localizer.getString("Apply"));
        applyBtn.addActionListener(new ApplyBtnListener());
        JPanel btnPanel = ButtonBarFactory.buildOKCancelApplyBar((JButton)okBtn, (JButton)cancelBtn, (JButton)applyBtn);
        contentPB.add((Component)btnPanel, cc.xywh(2, rowCount - 1, columnCount - 2, 1));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(okBtn);
        FWAction action = new NewRuleAction();
        this.actionGroup.addAction(action);
        ruleBar.addAction(action);
        ruleBar.addSeparator();
        action = new ChangeRuleAction();
        this.actionGroup.addAction(action);
        ruleBar.addAction(action);
        action = new CopyRuleAction();
        this.actionGroup.addAction(action);
        ruleBar.addAction(action);
        action = new DeleteRuleAction();
        this.actionGroup.addAction(action);
        ruleBar.addAction(action);
        ruleBar.addSeparator();
        action = new MoveRuleAction(true);
        this.actionGroup.addAction(action);
        ruleBar.addAction(action);
        action = new MoveRuleAction(false);
        this.actionGroup.addAction(action);
        ruleBar.addAction(action);
        this.pack();
        int height = this.getHeight();
        this.setSize(height * 6 / 5, height);
        this.setLocationRelativeTo(this.getParent());
    }

    public Rule getEditRule() {
        int selectedIndex = this.ruleList.getSelectedIndex();
        if (selectedIndex < 0) {
            return null;
        }
        return this.editModel.getDisplayRuleAt(selectedIndex);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public class RuleListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Rule) {
                this.setText(((Rule)value).getName());
            } else if (value instanceof RuleEditWrapper) {
                this.setText(((RuleEditWrapper)value).getName());
            }
            return this;
        }
    }

    public class RuleListSelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            AdvSearchRulesDialog.this.actionGroup.refreshActions();
            AdvSearchRulesDialog.this.ruleDescPanel.updateRuleData();
        }
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            AdvSearchRulesDialog.this.closeDialog();
        }

        public void actionPerformed(ActionEvent e) {
            AdvSearchRulesDialog.this.closeDialog();
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                AdvSearchRulesDialog.this.editModel.applyChangesToQueryManager();
                AdvSearchRulesDialog.this.closeDialog();
            }
            catch (Throwable th) {
                NLogger.error(OkBtnListener.class, th, th);
            }
        }
    }

    private final class ApplyBtnListener
    implements ActionListener {
        private ApplyBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                AdvSearchRulesDialog.this.editModel.applyChangesToQueryManager();
            }
            catch (Throwable th) {
                NLogger.error(ApplyBtnListener.class, th, th);
            }
        }
    }

    class MoveRuleAction
    extends FWAction {
        private static final boolean MOVE_UP = true;
        private static final boolean MOVE_DOWN = false;
        private boolean moveUp;

        MoveRuleAction(boolean type) {
            this.moveUp = type;
            if (this.moveUp) {
                this.setSmallIcon(GUIRegistry.getInstance().getPlafIconPack().getIcon("AdvSearchRules.MoveUp"));
                this.setToolTipText(Localizer.getString("AdvSearchRules_TTTMoveUp"));
            } else {
                this.setSmallIcon(GUIRegistry.getInstance().getPlafIconPack().getIcon("AdvSearchRules.MoveDown"));
                this.setToolTipText(Localizer.getString("AdvSearchRules_TTTMoveDown"));
            }
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            try {
                int selectedIdx = AdvSearchRulesDialog.this.ruleList.getSelectedIndex();
                if (selectedIdx < 0) {
                    return;
                }
                int newIdx = AdvSearchRulesDialog.this.editModel.moveRule(selectedIdx, this.moveUp);
                AdvSearchRulesDialog.this.ruleList.setSelectedIndex(newIdx);
            }
            catch (Throwable th) {
                NLogger.error(MoveRuleAction.class, th, th);
            }
        }

        public void refreshActionState() {
            int selectedIdx = AdvSearchRulesDialog.this.ruleList.getSelectedIndex();
            if (selectedIdx < 0) {
                this.setEnabled(false);
            } else if (this.moveUp && selectedIdx == 0) {
                this.setEnabled(false);
            } else if (!this.moveUp && selectedIdx == AdvSearchRulesDialog.this.editModel.getSize() - 1) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class DeleteRuleAction
    extends FWAction {
        public DeleteRuleAction() {
            super(Localizer.getString("AdvSearchRules_DeleteRule"), null, Localizer.getString("AdvSearchRules_TTTDeleteRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            int selectedIdx = AdvSearchRulesDialog.this.ruleList.getSelectedIndex();
            if (selectedIdx < 0) {
                return;
            }
            AdvSearchRulesDialog.this.editModel.removeRule(selectedIdx);
            AdvSearchRulesDialog.this.ruleDescPanel.updateRuleData();
        }

        public void refreshActionState() {
            this.setEnabled(!AdvSearchRulesDialog.this.ruleList.isSelectionEmpty());
        }
    }

    private class ChangeRuleAction
    extends FWAction {
        public ChangeRuleAction() {
            super(Localizer.getString("AdvSearchRules_ChangeRule"), null, Localizer.getString("AdvSearchRules_TTTChangeRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            int selectedIdx = AdvSearchRulesDialog.this.ruleList.getSelectedIndex();
            if (selectedIdx < 0) {
                return;
            }
            Rule modRule = AdvSearchRulesDialog.this.editModel.getDisplayRuleAt(selectedIdx);
            FilterWizardDialog wizardDialog = new FilterWizardDialog(modRule, AdvSearchRulesDialog.this);
            wizardDialog.setVisible(true);
            Rule resultRule = wizardDialog.getEditRule();
            if (resultRule != null) {
                AdvSearchRulesDialog.this.editModel.updateRule(selectedIdx, resultRule);
            }
            AdvSearchRulesDialog.this.ruleDescPanel.updateRuleData();
        }

        public void refreshActionState() {
            this.setEnabled(!AdvSearchRulesDialog.this.ruleList.isSelectionEmpty());
        }
    }

    private class CopyRuleAction
    extends FWAction {
        public CopyRuleAction() {
            super(Localizer.getString("AdvSearchRules_CopyRule"), null, Localizer.getString("AdvSearchRules_TTTCopyRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            int selectedIdx = AdvSearchRulesDialog.this.ruleList.getSelectedIndex();
            if (selectedIdx < 0) {
                return;
            }
            Rule modRule = AdvSearchRulesDialog.this.editModel.getDisplayRuleAt(selectedIdx);
            Rule copyRule = (Rule)modRule.clone();
            copyRule.setName(Localizer.getString("RuleVisualization_CopyOf") + " " + modRule.getName());
            copyRule.setId(null);
            copyRule.setDefaultRule(false);
            AdvSearchRulesDialog.this.editModel.addNewRule(copyRule);
        }

        public void refreshActionState() {
            this.setEnabled(!AdvSearchRulesDialog.this.ruleList.isSelectionEmpty());
        }
    }

    private class NewRuleAction
    extends FWAction {
        public NewRuleAction() {
            super(Localizer.getString("AdvSearchRules_NewRule"), null, Localizer.getString("AdvSearchRules_TTTNewRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            FilterWizardDialog newFilterDialog = new FilterWizardDialog(AdvSearchRulesDialog.this);
            newFilterDialog.setVisible(true);
            Rule resultRule = newFilterDialog.getEditRule();
            if (resultRule != null) {
                AdvSearchRulesDialog.this.editModel.addNewRule(resultRule);
                AdvSearchRulesDialog.this.actionGroup.refreshActions();
            }
        }

        public void refreshActionState() {
        }
    }
}

