/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;

public class LabeledIcon
implements Icon {
    private Icon delegate;
    private String label;

    public LabeledIcon(Icon delegate, String label) {
        assert (delegate != null) : "Delegate icon is null.";
        this.delegate = delegate;
        this.label = label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getIconHeight() {
        return this.delegate.getIconHeight();
    }

    public int getIconWidth() {
        return this.delegate.getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.delegate.paintIcon(c, g, x, y);
        if (this.label != null) {
            Graphics derivedContext = g.create();
            Font font = derivedContext.getFont();
            font = font.deriveFont(1, font.getSize2D() - 4.0f);
            derivedContext.setFont(font);
            if (derivedContext instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)derivedContext;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            FontMetrics metrics = derivedContext.getFontMetrics();
            Rectangle2D bounds = metrics.getStringBounds(this.label, derivedContext);
            derivedContext.drawString(this.label, (int)((double)(x + this.delegate.getIconWidth() / 2) - bounds.getWidth() / 2.0), (int)((double)(y + this.delegate.getIconHeight() / 2) + bounds.getHeight() / 2.0));
        }
    }
}

