/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HTMLMultiLinePanel
extends JTextPane {
    public HTMLMultiLinePanel(String text) {
        super(new HTMLDocument());
        this.setEditorKit(new HTMLEditorKit());
        this.setEditable(false);
        this.setText(text);
        this.setBorder(null);
        this.setFontAndColor(UIManager.getFont("Label.font"), UIManager.getColor("Label.foreground"));
        this.setBackground(UIManager.getColor("Label.background"));
    }

    private void setFontAndColor(Font font, Color fg) {
        StringBuffer rule = null;
        if (font != null) {
            rule = new StringBuffer("body { font-family: ");
            rule.append(font.getFamily());
            rule.append(";");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt");
            if (font.isBold()) {
                rule.append("; font-weight: 700");
            }
            if (font.isItalic()) {
                rule.append("; font-style: italic");
            }
        }
        if (fg != null) {
            if (rule == null) {
                rule = new StringBuffer("body { color: #");
            } else {
                rule.append("; color: #");
            }
            if (fg.getRed() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getRed()));
            if (fg.getGreen() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getGreen()));
            if (fg.getBlue() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getBlue()));
        }
        if (rule != null) {
            rule.append(" }");
            try {
                StyleSheet style = ((HTMLDocument)this.getDocument()).getStyleSheet();
                style.addRule(rule.toString());
            }
            catch (RuntimeException re) {
                // empty catch block
            }
        }
    }
}

