/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Keymap;
import phex.gui.common.DesktopIndicator;
import phex.gui.common.GUIRegistry;
import phex.gui.common.MainFrame;
import phex.gui.common.PhexColors;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumn;
import phex.utils.Localizer;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTab;
import phex.xml.sax.gui.DTable;
import phex.xml.sax.gui.DTableColumn;
import phex.xml.sax.gui.DTableColumnList;

public final class GUIUtils {
    public static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    public static final Insets NARROW_BUTTON_INSETS = new Insets(1, 1, 1, 3);
    public static final Border ROLLOVER_BUTTON_BORDER = new RolloverButtonBorder();

    private GUIUtils() {
    }

    public static void assignKeymapToComboBoxEditor(Keymap keymap, JComboBox comboBox) {
        ComboBoxUIChangeListener listener = new ComboBoxUIChangeListener(keymap, comboBox);
        comboBox.addPropertyChangeListener("UI", listener);
        ComboBoxEditor comboEditor = comboBox.getEditor();
        JTextField editor = (JTextField)comboEditor.getEditorComponent();
        editor.addPropertyChangeListener("UI", listener);
    }

    public static void assignKeymapToTextField(Keymap keymap, JTextField textField) {
        TextFieldUIChangeListener listener = new TextFieldUIChangeListener(keymap, textField);
        textField.addPropertyChangeListener("UI", listener);
    }

    public static void setWindowLocationRelativeTo(Window window, Window relativeWindow) {
        Rectangle windowBounds = window.getBounds();
        Dimension rwSize = relativeWindow.getSize();
        Point rwLoc = relativeWindow.getLocation();
        int dx = rwLoc.x + (rwSize.width - windowBounds.width >> 1);
        int dy = rwLoc.y + (rwSize.height - windowBounds.height >> 1);
        Dimension ss = window.getToolkit().getScreenSize();
        if (dy + windowBounds.height > ss.height) {
            dy = ss.height - windowBounds.height;
            int n = dx = rwLoc.x < ss.width >> 1 ? rwLoc.x + rwSize.width : rwLoc.x - windowBounds.width;
        }
        if (dx + windowBounds.width > ss.width) {
            dx = ss.width - windowBounds.width;
        }
        if (dx < 0) {
            dx = 0;
        }
        if (dy < 0) {
            dy = 0;
        }
        window.setLocation(dx, dy);
    }

    public static DTable getDGuiTableByIdentifier(DGuiSettings guiSettings, String tableIdentifier) {
        if (guiSettings == null) {
            return null;
        }
        for (DTable dTable : guiSettings.getTableList().getTableList()) {
            if (!dTable.getTableIdentifier().equals(tableIdentifier)) continue;
            return dTable;
        }
        return null;
    }

    public static DTab getDGuiTabById(DGuiSettings guiSettings, int tabID) {
        if (guiSettings == null) {
            return null;
        }
        for (DTab dTab : guiSettings.getTabList()) {
            if (dTab.getTabId() != tabID) continue;
            return dTab;
        }
        return null;
    }

    public static void updateTableFromDGuiSettings(DGuiSettings dGuiSettings, FWTable table, String identifier) {
        DTable dTable = GUIUtils.getDGuiTableByIdentifier(dGuiSettings, identifier);
        GUIUtils.updateTableFromDTable(dTable, table);
    }

    public static void updateTableFromDTable(DTable dTable, FWTable table) {
        if (dTable == null) {
            return;
        }
        DTableColumnList dColumnList = dTable.getTableColumnList();
        if (dColumnList == null) {
            return;
        }
        for (DTableColumn dColumn : dColumnList.getSubElementList()) {
            Integer colId = dColumn.getColumnID();
            FWTableColumn column = table.getFWColumn(colId);
            if (column == null) continue;
            column.setVisible(dColumn.isVisible());
            column.setPreferredWidth(dColumn.getWidth());
            if (!column.isVisible()) continue;
            int colIdx = table.getColumnModel().getColumnIndex(colId);
            int visibleIndex = dColumn.getVisibleIndex();
            visibleIndex = Math.min(visibleIndex, table.getColumnCount() - 1);
            table.moveColumn(colIdx, visibleIndex);
        }
    }

    public static DTable createDTable(FWTable table, String tableId) {
        DTable dTable = new DTable();
        DTableColumnList dList = GUIUtils.createDTableColumnList(table);
        dTable.setTableColumnList(dList);
        dTable.setTableIdentifier(tableId);
        return dTable;
    }

    public static DTableColumnList createDTableColumnList(FWTable table) {
        DTableColumnList colList = new DTableColumnList();
        List<DTableColumn> list = colList.getSubElementList();
        List<TableColumn> allColumns = table.getColumns(true);
        TableColumnModel model = table.getColumnModel();
        Collections.sort(allColumns, new VisibleTableColumnComparator(model));
        for (TableColumn column : allColumns) {
            if (!(column instanceof FWTableColumn)) continue;
            FWTableColumn fwColumn = (FWTableColumn)column;
            DTableColumn dColumn = fwColumn.createDGuiTableColumn();
            if (fwColumn.isVisible()) {
                dColumn.setVisibleIndex(model.getColumnIndex(column.getIdentifier()));
            }
            list.add(dColumn);
        }
        return colList;
    }

    public static void adjustComboBoxHeight(JComboBox comboBox) {
        if (comboBox == null) {
            return;
        }
        Font font = (Font)UIManager.getDefaults().get("ComboBox.font");
        if (font != null) {
            Dimension uiSize = comboBox.getUI().getPreferredSize(comboBox);
            FontMetrics fontMetrics = comboBox.getFontMetrics(font);
            int height = fontMetrics.getHeight() + fontMetrics.getDescent() + 3;
            comboBox.setPreferredSize(new Dimension(uiSize.width + 4, height));
        }
    }

    public static void adjustTableProgresssBarHeight(JTable table) {
        Font progressFont = (Font)UIManager.getDefaults().get("ProgressBar.font");
        FontMetrics fontMetrics = table.getFontMetrics(progressFont);
        int height = fontMetrics.getHeight() + fontMetrics.getDescent();
        table.setRowHeight(height);
    }

    public static void showErrorMessage(String message) {
        GUIUtils.showErrorMessage(GUIRegistry.getInstance().getMainFrame(), message);
    }

    public static void showErrorMessage(String message, String title) {
        GUIUtils.showErrorMessage(null, message, title);
    }

    public static void showErrorMessage(Component parent, String message) {
        GUIUtils.showErrorMessage(parent, message, Localizer.getString("Error"));
    }

    public static void showErrorMessage(Component parent, String message, String title) {
        if (parent == null) {
            parent = GUIRegistry.getInstance().getMainFrame();
        }
        JOptionPane.showMessageDialog(parent, message, title, 0);
    }

    public static void centerWindowOnScreen(Window win) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension winSize = win.getSize();
        Rectangle rect = new Rectangle((screenSize.width - winSize.width) / 2, (screenSize.height - winSize.height) / 2, winSize.width, winSize.height);
        win.setBounds(rect);
    }

    public static void centerAndSizeWindow(Window win, int fraction, int base) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = screenSize.width * fraction / base;
        int height = screenSize.height * fraction / base;
        Rectangle rect = new Rectangle((screenSize.width - width) / 2, (screenSize.height - height) / 2, width, height);
        win.setBounds(rect);
    }

    public static void updateComponentsUI() {
        PhexColors.updateColors();
        MainFrame frame = GUIRegistry.getInstance().getMainFrame();
        if (frame == null) {
            return;
        }
        SwingUtilities.updateComponentTreeUI(frame);
        Window[] windows = frame.getOwnedWindows();
        for (int j = 0; j < windows.length; ++j) {
            SwingUtilities.updateComponentTreeUI(windows[j]);
        }
    }

    public static Color brighterColor(Color color, double factor) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int i = (int)(1.0 / (1.0 - factor));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / factor), 255), Math.min((int)((double)g / factor), 255), Math.min((int)((double)b / factor), 255));
    }

    public static Color darkerColor(Color color, double factor) {
        return new Color(Math.max((int)((double)color.getRed() * factor), 0), Math.max((int)((double)color.getGreen() * factor), 0), Math.max((int)((double)color.getBlue() * factor), 0));
    }

    public static Color getBestColorMatch(Color base, Color[] candidates) {
        Color bestMatch = candidates[0];
        int brightnessDiff = GUIUtils.getColorBrightness(base, candidates[0]);
        int colorDiff = GUIUtils.getColorDifference(base, candidates[0]);
        int matchValue = brightnessDiff - 125 + (colorDiff - 500);
        for (int i = 1; i < candidates.length; ++i) {
            brightnessDiff = GUIUtils.getColorBrightness(base, candidates[i]);
            int testVal = brightnessDiff - 125 + ((colorDiff = GUIUtils.getColorDifference(base, candidates[i])) - 500);
            if (testVal <= matchValue) continue;
            matchValue = testVal;
            bestMatch = candidates[i];
        }
        return bestMatch;
    }

    public static int getColorDifference(Color col1, Color col2) {
        int diff = Math.max(col1.getRed(), col2.getRed()) - Math.min(col1.getRed(), col2.getRed()) + (Math.max(col1.getGreen(), col2.getGreen()) - Math.min(col1.getGreen(), col2.getGreen())) + (Math.max(col1.getBlue(), col2.getBlue()) - Math.min(col1.getBlue(), col2.getBlue()));
        return Math.abs(diff);
    }

    public static int getColorBrightness(Color col1, Color col2) {
        int b1 = (col1.getRed() * 299 + col1.getGreen() * 587 + col1.getBlue() * 114) / 1000;
        int b2 = (col2.getRed() * 299 + col2.getGreen() * 587 + col2.getBlue() * 114) / 1000;
        return Math.abs(b1 - b2);
    }

    public static void showMainFrame() {
        GUIRegistry registry = GUIRegistry.getInstance();
        MainFrame mainFrame = registry.getMainFrame();
        mainFrame.setVisible(true);
        DesktopIndicator indicator = registry.getDesktopIndicator();
        if (indicator != null) {
            indicator.hideIndicator();
        }
        if (mainFrame.getState() != 0) {
            mainFrame.setState(0);
        }
        mainFrame.toFront();
        mainFrame.requestFocus();
    }

    public static class RolloverButtonBorder
    extends AbstractBorder {
        private static final Insets INSETS_3 = new Insets(3, 3, 3, 3);
        private Color controlShadow;
        private Color controlDkShadow;
        private Color controlHighlight;
        private Color control;
        private boolean isShownWhenSelected;

        public RolloverButtonBorder() {
            this(true);
        }

        public RolloverButtonBorder(boolean isShownWhenSelected) {
            this.isShownWhenSelected = isShownWhenSelected;
            UIDefaults table = UIManager.getLookAndFeelDefaults();
            this.controlShadow = table.getColor("controlShadow");
            this.controlDkShadow = table.getColor("controlDkShadow");
            this.controlHighlight = table.getColor("controlHighlight");
            this.control = table.getColor("control");
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            if (!model.isEnabled()) {
                return;
            }
            if (model.isRollover()) {
                if (model.isPressed() && model.isArmed()) {
                    this.drawPressed3DBorder(g, x, y, w, h);
                } else {
                    this.drawFlush3DBorder(g, x, y, w, h);
                }
            } else if (this.isShownWhenSelected && model.isSelected()) {
                this.drawDark3DBorder(g, x, y, w, h);
            }
        }

        private void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            this.drawFlush3DBorder(g, 0, 0, w, h);
            g.setColor(this.controlShadow);
            g.drawLine(1, 1, 1, h - 3);
            g.drawLine(1, 1, w - 3, 1);
            g.translate(-x, -y);
        }

        private void drawDark3DBorder(Graphics g, int x, int y, int w, int h) {
            this.drawFlush3DBorder(g, x, y, w, h);
            g.setColor(this.control);
            g.drawLine(x + 1, y + 1, 1, h - 3);
            g.drawLine(y + 1, y + 1, w - 3, 1);
        }

        private void drawFlush3DBorder(Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(this.controlHighlight);
            RolloverButtonBorder.drawRect(g, 1, 1, w - 2, h - 2);
            g.drawLine(0, h - 1, 0, h - 1);
            g.drawLine(w - 1, 0, w - 1, 0);
            g.setColor(this.controlDkShadow);
            RolloverButtonBorder.drawRect(g, 0, 0, w - 2, h - 2);
            g.translate(-x, -y);
        }

        private static void drawRect(Graphics g, int x, int y, int w, int h) {
            g.fillRect(x, y, w + 1, 1);
            g.fillRect(x, y + 1, 1, h);
            g.fillRect(x + 1, y + h, w, 1);
            g.fillRect(x + w, y + 1, 1, h);
        }

        public Insets getBorderInsets(Component c) {
            return INSETS_3;
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = RolloverButtonBorder.INSETS_3.top;
            newInsets.left = RolloverButtonBorder.INSETS_3.left;
            newInsets.bottom = RolloverButtonBorder.INSETS_3.bottom;
            newInsets.right = RolloverButtonBorder.INSETS_3.right;
            return newInsets;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VisibleTableColumnComparator
    implements Comparator<TableColumn> {
        private TableColumnModel model;

        public VisibleTableColumnComparator(TableColumnModel model) {
            this.model = model;
        }

        @Override
        public int compare(TableColumn col1, TableColumn col2) {
            if (!(col1 instanceof FWTableColumn)) {
                return -1;
            }
            if (!(col2 instanceof FWTableColumn)) {
                return 1;
            }
            FWTableColumn fwCol1 = (FWTableColumn)col1;
            FWTableColumn fwCol2 = (FWTableColumn)col2;
            if (!fwCol1.isVisible()) {
                return -1;
            }
            if (!fwCol2.isVisible()) {
                return 1;
            }
            int col1Idx = this.model.getColumnIndex(col1.getIdentifier());
            int col2Idx = this.model.getColumnIndex(col2.getIdentifier());
            return col1Idx - col2Idx;
        }
    }

    private static class TextFieldUIChangeListener
    implements PropertyChangeListener {
        private Keymap keymap;
        private JTextField textField;

        public TextFieldUIChangeListener(Keymap keymap, JTextField textField) {
            this.keymap = keymap;
            this.textField = textField;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals("UI")) {
                return;
            }
            this.textField.setKeymap(this.keymap);
        }
    }

    private static class ComboBoxUIChangeListener
    implements PropertyChangeListener {
        private Keymap keymap;
        private JComboBox comboBox;

        public ComboBoxUIChangeListener(Keymap keymap, JComboBox comboBox) {
            this.keymap = keymap;
            this.comboBox = comboBox;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals("UI")) {
                return;
            }
            if (evt.getSource() == this.comboBox) {
                ComboBoxEditor comboEditor = this.comboBox.getEditor();
                JTextField editor = (JTextField)comboEditor.getEditorComponent();
                editor.addPropertyChangeListener("UI", this);
            } else {
                ComboBoxEditor comboEditor = this.comboBox.getEditor();
                JTextField editor = (JTextField)comboEditor.getEditorComponent();
                editor.setKeymap(this.keymap);
            }
        }
    }
}

