/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import phex.gui.actions.FWAction;
import phex.gui.actions.FWToggleAction;
import phex.gui.common.GUIUtils;

public class FWToolBar
extends JToolBar {
    private boolean isTextShown;

    public FWToolBar(int orientation) {
        super(orientation);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.isTextShown = true;
    }

    public void setShowText(boolean state) {
        this.isTextShown = state;
    }

    public AbstractButton addAction(FWAction action) {
        return this.addAction(action, action.isToggleAction());
    }

    public AbstractButton addAction(Action action, boolean isToggleAction) {
        AbstractButton btn;
        if (isToggleAction) {
            btn = new JToggleButton();
            btn.setSelected(((FWToggleAction)action).isSelected());
        } else {
            btn = new JButton();
        }
        Icon icon = (Icon)action.getValue("MediumIcon");
        if (icon == null) {
            icon = (Icon)action.getValue("SmallIcon");
        }
        btn.setIcon(icon);
        btn.setHorizontalTextPosition(4);
        btn.setVerticalTextPosition(3);
        btn.setEnabled(action.isEnabled());
        btn.addActionListener(action);
        this.registerActionChangeListener(btn, action);
        btn.setToolTipText((String)action.getValue("ToolTipText"));
        if (this.isTextShown) {
            btn.setText((String)action.getValue("Name"));
        }
        btn.setRequestFocusEnabled(false);
        btn.setMargin(GUIUtils.EMPTY_INSETS);
        this.add(btn);
        return btn;
    }

    private void registerActionChangeListener(AbstractButton b, Action a) {
        ActionChangedListener actionPropertyChangeListener = new ActionChangedListener(b);
        a.addPropertyChangeListener(actionPropertyChangeListener);
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        ActionChangedListener(AbstractButton b) {
            this.button = b;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("Name")) {
                String text = (String)e.getNewValue();
                this.button.setText(text);
                this.button.repaint();
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.button.setEnabled(enabledState);
                this.button.repaint();
            } else if (propertyName.equals("MediumIcon")) {
                Icon icon = (Icon)e.getNewValue();
                this.button.setIcon(icon);
                this.button.invalidate();
                this.button.repaint();
            } else if (propertyName.equals("IsSelected")) {
                Boolean state = (Boolean)e.getNewValue();
                this.button.setSelected(state);
                this.button.repaint();
            } else if (propertyName.equals("ToolTipText")) {
                String state = (String)e.getNewValue();
                this.button.setToolTipText(state);
                this.button.repaint();
            }
        }
    }
}

