/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import phex.gui.common.GradientPanel;
import phex.gui.common.PhexColors;

public class FWElegantPanel
extends JPanel {
    private JLabel titleLabel;
    private JPanel headerPanel = new ElegantHeaderPanel(PhexColors.getBoxHeaderGradientFrom(), PhexColors.getBoxHeaderGradientTo());

    public FWElegantPanel(String title) {
        this(title, null);
    }

    public FWElegantPanel(String title, Component container) {
        super(new BorderLayout());
        this.headerPanel.add((Component)this.getTitleLabel(), "Center");
        this.add((Component)this.headerPanel, "North");
        if (container != null) {
            this.add(container, "Center");
        }
        this.setTitle(title);
    }

    public String getTitle() {
        return this.getTitleLabel().getText();
    }

    private JLabel getTitleLabel() {
        if (this.titleLabel != null) {
            return this.titleLabel;
        }
        this.titleLabel = new JLabel();
        Font currentFont = this.titleLabel.getFont();
        this.titleLabel.setFont(currentFont.deriveFont(1, currentFont.getSize() + 2));
        this.titleLabel.setBorder(new EmptyBorder(6, 6, 6, 4));
        return this.titleLabel;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        title = title.trim();
        this.getTitleLabel().setText(title);
    }

    public void addHeaderPanelComponent(Component comp, String constrain) {
        this.headerPanel.add(comp, constrain);
    }

    private static class ElegantHeaderPanel
    extends GradientPanel {
        private static Rectangle viewRect = new Rectangle();

        public ElegantHeaderPanel(Color from, Color to) {
            super(from, to);
            this.setLayout(new BorderLayout());
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Insets in = this.getInsets();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            Insets i = this.getInsets();
            ElegantHeaderPanel.viewRect.x = i.left;
            ElegantHeaderPanel.viewRect.y = i.top;
            ElegantHeaderPanel.viewRect.width = this.getWidth() - (i.right + ElegantHeaderPanel.viewRect.x) - 1;
            ElegantHeaderPanel.viewRect.height = this.getHeight() - (i.bottom + ElegantHeaderPanel.viewRect.y);
            Graphics2D g2 = (Graphics2D)g;
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.fromColor, 0.0f, ElegantHeaderPanel.viewRect.height, this.toColor);
            g2.setPaint(gradient);
            g2.fillRect(ElegantHeaderPanel.viewRect.x, ElegantHeaderPanel.viewRect.y, ElegantHeaderPanel.viewRect.width, ElegantHeaderPanel.viewRect.height);
            g.setColor(PhexColors.getBoxPanelBorderColor());
            g.drawLine(in.left, in.top, ElegantHeaderPanel.viewRect.width, in.top);
            g.drawLine(in.left, in.top, in.left, ElegantHeaderPanel.viewRect.height);
            g.drawLine(ElegantHeaderPanel.viewRect.width, in.top, ElegantHeaderPanel.viewRect.width, ElegantHeaderPanel.viewRect.height);
        }
    }
}

