/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.chat;

import java.awt.EventQueue;
import java.util.HashMap;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.chat.ChatEngine;
import phex.chat.ChatEvent;
import phex.gui.chat.ChatFrame;
import phex.gui.common.GUIRegistry;
import phex.utils.Localizer;

public class ChatFrameManager {
    private static final int MAX_CHAT_WINDOWS = 30;
    private HashMap<ChatEngine, ChatFrame> openChatsMap = new HashMap(4);

    public ChatFrameManager() {
        GUIRegistry.getInstance().getServent().getEventService().processAnnotations(this);
    }

    @EventTopicSubscriber(topic="phex:chat/update")
    public void onChatEvent(String topic, final ChatEvent event) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                switch (event.getType()) {
                    case OPENED: {
                        ChatFrameManager.this.chatConnectionOpened(event.getEngine());
                        break;
                    }
                    case FAILED: {
                        ChatFrameManager.this.chatConnectionFailed(event.getEngine());
                        break;
                    }
                    case MSG_REC: {
                        ChatFrameManager.this.chatMessageReceived(event.getEngine(), event.getChatMsg());
                    }
                }
            }
        });
    }

    private void chatConnectionOpened(ChatEngine chatEngine) {
        if (this.openChatsMap.size() > 30) {
            chatEngine.stopChat();
            return;
        }
        ChatFrame frame = new ChatFrame(chatEngine);
        frame.setVisible(true);
        this.openChatsMap.put(chatEngine, frame);
    }

    private void chatMessageReceived(ChatEngine chatEngine, String chatMessage) {
        ChatFrame frame = this.openChatsMap.get(chatEngine);
        frame.addChatMessage(chatMessage);
    }

    private void chatConnectionFailed(ChatEngine chatEngine) {
        ChatFrame frame = this.openChatsMap.remove(chatEngine);
        if (frame != null) {
            Object[] args = new Object[]{chatEngine.getHostAddress().getFullHostName()};
            frame.addInfoMessage(Localizer.getFormatedString("ChatConnectionClosed", args));
        }
    }
}

