/*
 * Decompiled with CFR 0.152.
 */
package phex.download.handler;

import phex.download.DownloadEngine;
import phex.download.handler.DownloadHandler;
import phex.http.HTTPHeader;
import phex.http.HTTPResponse;

public abstract class AbstractHttpDownload
implements DownloadHandler {
    protected DownloadEngine downloadEngine;
    protected boolean isKeepAliveSupported;

    AbstractHttpDownload(DownloadEngine engine) {
        this.downloadEngine = engine;
    }

    protected void updateKeepAliveSupport(HTTPResponse response) {
        HTTPHeader header = response.getHeader("Connection");
        if (header != null) {
            if (header.getValue().equalsIgnoreCase("close")) {
                this.isKeepAliveSupported = false;
                return;
            }
            if (header.getValue().equalsIgnoreCase("keep-alive")) {
                this.isKeepAliveSupported = true;
                return;
            }
        }
        this.isKeepAliveSupported = response.getHTTPVersion().equals("HTTP/1.1");
    }
}

