/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.util.List;
import phex.thex.TTHashCalcUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThexVerificationData {
    private ThexData thexData = null;
    private boolean isThexRequested = false;
    private String rootHash;

    public String getRootHash() {
        return this.rootHash;
    }

    public void setRootHash(String rootHash) {
        this.rootHash = rootHash;
    }

    public ThexData getThexData() {
        return this.thexData;
    }

    public void setThexData(List<byte[]> lowestLevelNodes, int treeDepth, long fileSize) {
        this.thexData = new ThexData(lowestLevelNodes, treeDepth, fileSize);
    }

    public boolean isThexRequested() {
        return this.isThexRequested;
    }

    public void setThexRequested(boolean isThexRequested) {
        this.isThexRequested = isThexRequested;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ThexData {
        private final long fileSize;
        private final List<byte[]> lowestLevelNodes;
        private final int treeDepth;
        private final int nodeSize;

        public ThexData(List<byte[]> lowestLevelNodes, int treeDepth, long fileSize) {
            this.lowestLevelNodes = lowestLevelNodes;
            this.treeDepth = treeDepth;
            this.fileSize = fileSize;
            this.nodeSize = TTHashCalcUtils.getTreeNodeSize(fileSize, treeDepth);
        }

        public byte[] getNodeHash(int idx) {
            return this.lowestLevelNodes.get(idx);
        }

        public int getNodeSize() {
            return this.nodeSize;
        }

        public boolean isGoodQuality() {
            return this.treeDepth >= TTHashCalcUtils.getTreeLevels(this.fileSize) - 1;
        }
    }
}

