/*
 * Decompiled with CFR 0.152.
 */
package phex.common.address;

import java.util.Arrays;
import phex.common.Ip2CountryDB;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.utils.IOUtil;

public class IpAddress {
    public static final IpAddress LOCAL_HOST_IP = new IpAddress(new byte[]{127, 0, 0, 1});
    public static final IpAddress UNSET_IP = new IpAddress(new byte[]{0, 0, 0, 0});
    public static final String LOCAL_HOST_NAME = "127.0.0.1";
    private int hash = 0;
    private final byte[] hostIP;
    public String countryCode;

    public IpAddress(byte[] aHostIP) {
        if (aHostIP == null) {
            throw new NullPointerException("Ip is null");
        }
        this.hostIP = aHostIP;
    }

    public byte[] getHostIP() {
        return this.hostIP;
    }

    public String getFormatedString() {
        return AddressUtils.ip2string(this.hostIP);
    }

    public long getLongHostIP() {
        int v1 = this.hostIP[3] & 0xFF;
        int v2 = this.hostIP[2] << 8 & 0xFF00;
        int v3 = this.hostIP[1] << 16 & 0xFF0000;
        int v4 = this.hostIP[0] << 24;
        long ipValue = (long)(v4 | v3 | v2 | v1) & 0xFFFFFFFFL;
        return ipValue;
    }

    public boolean equals(IpAddress address) {
        if (address == null) {
            return false;
        }
        return Arrays.equals(this.hostIP, address.hostIP);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IpAddress) {
            return this.equals((IpAddress)obj);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int ipVal;
            this.hash = ipVal = IOUtil.deserializeInt(this.hostIP, 0);
        }
        return this.hash;
    }

    public String getCountryCode() {
        if (this.countryCode == null) {
            this.countryCode = Ip2CountryDB.getCountryCode(this);
        }
        return this.countryCode;
    }

    public boolean isLocalAddress(DestAddress localAddress) {
        if (this.hostIP[0] == 127) {
            return true;
        }
        return localAddress.getIpAddress().equals(this);
    }

    public boolean isSiteLocalIP() {
        if (this.hostIP[0] == 10 || this.hostIP[0] == 127) {
            return true;
        }
        if (this.hostIP[0] == -84 && this.hostIP[1] >= 16 && this.hostIP[1] <= 31) {
            return true;
        }
        return this.hostIP[0] == -64 && this.hostIP[1] == -88;
    }

    public boolean isValidIP() {
        boolean valid;
        switch (this.getIPClass()) {
            case CLASS_A: {
                valid = (this.hostIP[1] & 0xFF) + (this.hostIP[2] & 0xFF) + (this.hostIP[3] & 0xFF) != 0;
                break;
            }
            case CLASS_B: {
                valid = (this.hostIP[2] & 0xFF) + (this.hostIP[3] & 0xFF) != 0;
                break;
            }
            case CLASS_C: {
                valid = (this.hostIP[3] & 0xFF) != 0;
                break;
            }
            default: {
                valid = false;
            }
        }
        return valid;
    }

    public IPClass getIPClass() {
        if ((this.hostIP[0] & 0x80) == 0) {
            return IPClass.CLASS_A;
        }
        if ((this.hostIP[0] & 0xC0) == 128) {
            return IPClass.CLASS_B;
        }
        if ((this.hostIP[0] & 0xE0) == 192) {
            return IPClass.CLASS_C;
        }
        return IPClass.INVALID;
    }

    public String toString() {
        return AddressUtils.ip2string(this.hostIP);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IPClass {
        CLASS_A,
        CLASS_B,
        CLASS_C,
        INVALID;

    }
}

