/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.Locale;
import phex.utils.URLCodecUtils;

public class URN {
    public static final String SHA1 = "sha1";
    public static final String BITPRINT = "bitprint";
    public static final String URN_PREFIX = "urn:";
    private int hashCode = -1;
    private String urnString;
    private String urnNID;
    private String urnNSS;

    public URN(String aURNString) {
        if (aURNString.length() < 4) {
            throw new IllegalArgumentException("URN not valid: " + aURNString);
        }
        String prefix = aURNString.substring(0, 4).toLowerCase(Locale.US);
        if (!prefix.equals(URN_PREFIX)) {
            throw new IllegalArgumentException("URN not valid: " + aURNString);
        }
        int colonIdx = aURNString.indexOf(58, 4);
        if (colonIdx == -1) {
            throw new IllegalArgumentException("URN not valid: " + aURNString);
        }
        this.urnNID = aURNString.substring(4, colonIdx);
        if (!URN.isValidNamespaceIdentifier(this.urnNID)) {
            throw new IllegalArgumentException("URN not valid (NID): " + aURNString);
        }
        this.urnNSS = aURNString.substring(colonIdx + 1, aURNString.length());
        if (!URN.isValidNamespaceSpecificString(this.urnNSS)) {
            throw new IllegalArgumentException("URN not valid (NSS): " + aURNString);
        }
        this.urnString = aURNString;
    }

    public boolean isSha1Nid() {
        return SHA1.equalsIgnoreCase(this.urnNID);
    }

    public boolean isBitprintNid() {
        return BITPRINT.equalsIgnoreCase(this.urnNID);
    }

    public String getNamespaceSpecificString() {
        return this.urnNSS;
    }

    public String getSHA1Nss() {
        if (SHA1.equalsIgnoreCase(this.urnNID)) {
            return this.urnNSS;
        }
        if (BITPRINT.equalsIgnoreCase(this.urnNID)) {
            return this.urnNSS.substring(0, 32);
        }
        return null;
    }

    public String getTigerTreeRootNss() {
        if (BITPRINT.equalsIgnoreCase(this.urnNID)) {
            return this.urnNSS.substring(33, 72);
        }
        return null;
    }

    public String getAsString() {
        return this.urnString;
    }

    public boolean equals(Object urn) {
        if (urn instanceof URN) {
            return this.equals((URN)urn);
        }
        return false;
    }

    public boolean equals(URN urn) {
        if (this.urnNID.equalsIgnoreCase(urn.urnNID)) {
            return urn.urnString.equalsIgnoreCase(this.urnString);
        }
        String thisSHA1Nss = this.getSHA1Nss();
        if (thisSHA1Nss == null) {
            throw new RuntimeException("Cant compare URNs");
        }
        return thisSHA1Nss.equals(urn.getSHA1Nss());
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = 3 * (this.urnString.hashCode() + this.getClass().hashCode());
        }
        return this.hashCode;
    }

    public static boolean isValidURN(String urn) {
        if (urn.length() < 4) {
            return false;
        }
        String prefix = urn.substring(0, 4).toLowerCase(Locale.US);
        if (!prefix.equals(URN_PREFIX)) {
            return false;
        }
        int colonIdx = urn.indexOf(58, 4);
        if (colonIdx == -1) {
            return false;
        }
        String nid = urn.substring(4, colonIdx);
        if (!URN.isValidNamespaceIdentifier(nid)) {
            return false;
        }
        String nss = urn.substring(colonIdx + 1, urn.length());
        return URN.isValidNamespaceSpecificString(nss);
    }

    public static boolean isValidNamespaceSpecificString(String nss) {
        int length = nss.length();
        return length == 32 || length == 72;
    }

    public static boolean isValidNamespaceIdentifier(String nid) {
        String lcNID = nid.toLowerCase(Locale.US);
        if (lcNID.equals(SHA1)) {
            return true;
        }
        return lcNID.equals(BITPRINT);
    }

    public static URN parseURNFromUriRes(String uriResLine) {
        String urnStr;
        String lowerCaseLine = uriResLine.toLowerCase(Locale.US);
        if (lowerCaseLine.startsWith("/uri-res/n2r?urn:") && URN.isValidURN(urnStr = URLCodecUtils.decodeURL(uriResLine.substring(13)))) {
            URN urn = new URN(urnStr);
            return urn;
        }
        return null;
    }
}

