/*
 * Decompiled with CFR 0.152.
 */
package phex.chat;

import java.io.IOException;
import phex.chat.ChatEngine;
import phex.chat.ChatEvent;
import phex.common.AddressCounter;
import phex.common.address.DestAddress;
import phex.common.bandwidth.BandwidthController;
import phex.common.log.NLogger;
import phex.event.PhexEventService;
import phex.net.connection.Connection;
import phex.prefs.core.NetworkPrefs;
import phex.servent.Servent;

public class ChatService {
    private final Servent servent;
    private final AddressCounter addressCounter;

    public ChatService(Servent servent) {
        this.servent = servent;
        this.addressCounter = new AddressCounter(1, false);
    }

    protected PhexEventService getEventService() {
        return this.servent.getEventService();
    }

    public BandwidthController getChatBandwidthController() {
        return this.servent.getBandwidthService().getNetworkBandwidthController();
    }

    public void openChat(DestAddress hostAddress) {
        ChatEngine chatEngine = new ChatEngine(this, hostAddress);
        chatEngine.startChat();
        this.fireChatConnectionOpened(chatEngine);
    }

    public void chatClosed(ChatEngine chatEngine) {
        this.addressCounter.relaseAddress(chatEngine.getHostAddress());
        this.fireChatConnectionFailed(chatEngine);
    }

    public void acceptChat(Connection connection) {
        if (!NetworkPrefs.AllowChatConnection.get().booleanValue()) {
            connection.disconnect();
            return;
        }
        DestAddress hostAddress = connection.getSocket().getRemoteAddress();
        if (!this.addressCounter.validateAndCountAddress(hostAddress)) {
            connection.disconnect();
            return;
        }
        try {
            ChatEngine chatEngine = new ChatEngine(this, connection);
            chatEngine.startChat();
            this.fireChatConnectionOpened(chatEngine);
        }
        catch (IOException exp) {
            NLogger.debug(ChatService.class, exp, exp);
            connection.disconnect();
            return;
        }
    }

    public void fireChatConnectionOpened(ChatEngine chatEngine) {
        this.getEventService().publish("phex:chat/update", new ChatEvent(ChatEvent.Type.OPENED, chatEngine, null));
    }

    public void fireChatConnectionFailed(ChatEngine chatEngine) {
        this.getEventService().publish("phex:chat/update", new ChatEvent(ChatEvent.Type.FAILED, chatEngine, null));
    }
}

