/*
 * Decompiled with CFR 0.152.
 */
package phex.bootstrap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.bootstrap.BootstrapHostComparator;
import phex.bootstrap.UdpHostCache;
import phex.common.Environment;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.event.ChangeEvent;
import phex.msg.PongMsg;
import phex.net.repres.PresentationManager;
import phex.servent.Servent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UdpHostCacheContainer {
    private static final Logger logger = LoggerFactory.getLogger(UdpHostCacheContainer.class);
    private static int MIN_UDP_HOST_CACHE_SIZE = 20;
    private static final List<UdpHostCache> defaultCaches = new ArrayList<UdpHostCache>();
    private final Servent servent;
    private final List<UdpHostCache> functionalUdpCaches;
    private final List<UdpHostCache> generalUdpCaches;
    private final AtomicBoolean isThreadRequestRunning;

    public UdpHostCacheContainer(Servent servent) {
        this.servent = servent;
        this.functionalUdpCaches = new ArrayList<UdpHostCache>();
        this.generalUdpCaches = new ArrayList<UdpHostCache>();
        this.isThreadRequestRunning = new AtomicBoolean(false);
        this.initialize();
        servent.getEventService().processAnnotations(this);
    }

    @EventTopicSubscriber(topic="phex:servent/gnutellaNetwork")
    public void onGnutellaNetworkEvent(String topic, ChangeEvent event) {
        this.saveCachesToFile();
        this.initialize();
    }

    private void initialize() {
        this.functionalUdpCaches.clear();
        this.generalUdpCaches.clear();
        this.loadCachesFromFile();
        for (UdpHostCache cache : defaultCaches) {
            this.addCache(cache);
        }
        logger.debug("Initialized UdpHostCacheContainer.");
    }

    public boolean addCache(UdpHostCache cache) {
        logger.info("Adding a UDP Host Cache to the GENERAL container.");
        return this.addTo(cache, this.generalUdpCaches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createPackedHostCaches() {
        int PACKED_CACHES_SIZE = 8;
        StringBuffer packedCaches = new StringBuffer(168);
        List<UdpHostCache> list = this.functionalUdpCaches;
        synchronized (list) {
            Iterator<UdpHostCache> udphc = this.functionalUdpCaches.iterator();
            for (int count = 0; udphc.hasNext() && count < 8; ++count) {
                UdpHostCache cache = udphc.next();
                DestAddress address = cache.getHostAddress();
                String ipString = address.getFullHostName();
                packedCaches.append(ipString);
                packedCaches.append("\n");
            }
        }
        return packedCaches.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void catchHosts(PongMsg pongMsg) {
        UdpHostCache cache;
        Set<UdpHostCache> udpHostCaches = pongMsg.getUdpHostCaches();
        if (udpHostCaches != null) {
            logger.debug("Catch UDP Host Caches: {}.", udpHostCaches);
            for (UdpHostCache cache2 : udpHostCaches) {
                this.addCache(cache2);
            }
        }
        if ((cache = pongMsg.getUdpHostCache()) != null) {
            logger.debug("Catch UDP Host Cache: {}.", (Object)cache);
            List<UdpHostCache> list = this.generalUdpCaches;
            synchronized (list) {
                int idx = this.generalUdpCaches.indexOf(cache);
                if (idx >= 0) {
                    cache = this.generalUdpCaches.get(idx);
                    this.generalUdpCaches.remove(idx);
                }
            }
            cache.resetFailedInRowCount();
            this.addTo(cache, this.functionalUdpCaches);
        }
    }

    public synchronized void invokeQueryCachesRequest() {
        if (!this.isThreadRequestRunning.compareAndSet(false, true)) {
            return;
        }
        QueryCachesRunner runner = new QueryCachesRunner();
        Environment.getInstance().executeOnThreadPool(runner, "UdpHostCacheQuery-" + Integer.toHexString(runner.hashCode()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UdpHostCache> getUhcListToQuery(int count) {
        ArrayList<UdpHostCache> list = new ArrayList<UdpHostCache>(count);
        long now = System.currentTimeMillis();
        List<UdpHostCache> list2 = this.functionalUdpCaches;
        synchronized (list2) {
            for (UdpHostCache cache : this.functionalUdpCaches) {
                if (now <= cache.getEarliestReConnectTime()) continue;
                list.add(cache);
                if (list.size() < count) continue;
                return list;
            }
        }
        list2 = this.generalUdpCaches;
        synchronized (list2) {
            Collections.sort(this.generalUdpCaches, BootstrapHostComparator.INSTANCE);
            for (UdpHostCache cache : this.generalUdpCaches) {
                if (now <= cache.getEarliestReConnectTime()) continue;
                list.add(cache);
                if (list.size() < count) continue;
                return list;
            }
        }
        return list;
    }

    private void queryMoreHosts() {
        int NO_OF_CACHES_TO_PING = 3;
        List<UdpHostCache> uhcListToQuery = this.getUhcListToQuery(3);
        for (UdpHostCache udpHostCache : uhcListToQuery) {
            this.queryCache(udpHostCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryCache(UdpHostCache cache) {
        logger.debug("Pinging UDP Host Cache: {}.", (Object)cache);
        cache.setLastRequestTime(System.currentTimeMillis());
        this.servent.getMessageService().sendUdpPing(cache.getHostAddress());
        cache.incFailedInRowCount();
        List<UdpHostCache> list = this.functionalUdpCaches;
        synchronized (list) {
            this.functionalUdpCaches.remove(cache);
        }
        this.addCache(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addTo(UdpHostCache cache, List<UdpHostCache> cacheContainer) {
        List<UdpHostCache> list = cacheContainer;
        synchronized (list) {
            if (!cacheContainer.contains(cache)) {
                cacheContainer.add(cache);
                Collections.sort(cacheContainer, BootstrapHostComparator.INSTANCE);
                logger.info("Added UdpHostCache: {}", (Object)cache);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCachesFromFile() {
        try {
            File file = this.servent.getGnutellaNetwork().getUdpHostCacheFile();
            if (!file.exists()) {
                logger.debug("No UDP host cache file found.");
                return;
            }
            BufferedReader br = new BufferedReader(new FileReader(file));
            List<UdpHostCache> list = this.generalUdpCaches;
            synchronized (list) {
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    UdpHostCache cache = this.parseUhcFromLine(line);
                    this.addCache(cache);
                }
            }
            br.close();
        }
        catch (IOException e) {
            logger.warn("Loading Udp Host Caches from file FAILED", (Throwable)e);
        }
    }

    private UdpHostCache parseUhcFromLine(String line) {
        DestAddress hostCacheAdr;
        int failedInRowCount;
        long lastRequestTime;
        String hostStr;
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount == 1) {
            hostStr = line;
            lastRequestTime = -1L;
            failedInRowCount = -1;
        } else if (tokenCount == 3) {
            hostStr = tokenizer.nextToken();
            try {
                lastRequestTime = Long.parseLong(tokenizer.nextToken());
            }
            catch (NumberFormatException exp) {
                lastRequestTime = -1L;
            }
            try {
                failedInRowCount = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException exp) {
                failedInRowCount = -1;
            }
        } else {
            logger.warn("Unknown HostCache line format: {}", (Object)line);
            return null;
        }
        try {
            hostCacheAdr = PresentationManager.getInstance().createHostAddress(hostStr, 6346);
        }
        catch (MalformedDestAddressException e) {
            logger.warn("Could not create cache from host string: {}", (Object)line, (Object)e);
            return null;
        }
        UdpHostCache cache = new UdpHostCache(hostCacheAdr);
        if (lastRequestTime > 0L) {
            cache.setLastRequestTime(lastRequestTime);
        }
        if (failedInRowCount > 0) {
            cache.setFailedInRowCount(failedInRowCount);
        }
        return cache;
    }

    public void saveCachesToFile() {
        try {
            File file = this.servent.getGnutellaNetwork().getUdpHostCacheFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            this.writeCachesToFile(writer, this.functionalUdpCaches);
            this.writeCachesToFile(writer, this.generalUdpCaches);
            writer.flush();
            writer.close();
        }
        catch (IOException exp) {
            logger.warn("Saving Udp Host Caches to file FAILED ", (Throwable)exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCachesToFile(BufferedWriter writer, List<UdpHostCache> cacheContainer) throws IOException {
        List<UdpHostCache> list = cacheContainer;
        synchronized (list) {
            for (UdpHostCache cache : cacheContainer) {
                DestAddress address = cache.getHostAddress();
                String ipString = address.getFullHostName();
                writer.write(ipString);
                writer.write(32);
                writer.write(String.valueOf(cache.getLastRequestTime()));
                writer.write(32);
                writer.write(String.valueOf(cache.getFailedInRowCount()));
                writer.newLine();
            }
        }
    }

    static {
        defaultCaches.add(new UdpHostCache(new DefaultDestAddress("gnutelladev1.udp-host-cache.com", 1234)));
        defaultCaches.add(new UdpHostCache(new DefaultDestAddress("gnutelladev2.udp-host-cache.com", 5678)));
        defaultCaches.add(new UdpHostCache(new DefaultDestAddress("gwc.ak-electron.eu", 12060)));
        defaultCaches.add(new UdpHostCache(new DefaultDestAddress("gwc.chickenkiller.com", 8080)));
        defaultCaches.add(new UdpHostCache(new DefaultDestAddress("yang.cloud.bishopston.net", 33558)));
        defaultCaches.add(new UdpHostCache(new DefaultDestAddress("yin.cloud.bishopston.net", 33558)));
        Collections.shuffle(defaultCaches);
    }

    private final class QueryCachesRunner
    implements Runnable {
        private QueryCachesRunner() {
        }

        public void run() {
            UdpHostCacheContainer.this.queryMoreHosts();
            UdpHostCacheContainer.this.isThreadRequestRunning.set(false);
        }
    }
}

