/*
 * Decompiled with CFR 0.152.
 */
package phex.bootstrap;

import java.util.TimerTask;
import phex.bootstrap.GWebCacheContainer;
import phex.common.Environment;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.host.NetworkHostsContainer;
import phex.servent.Servent;

public class BootstrapManager {
    private final Servent servent;
    private final GWebCacheContainer gWebCacheContainer;
    private volatile boolean isThreadRequestRunning = false;

    public BootstrapManager(Servent servent) {
        this.servent = servent;
        this.gWebCacheContainer = new GWebCacheContainer(servent);
    }

    public synchronized void invokeQueryMoreHostsRequest(boolean preferPhex) {
        if (this.isThreadRequestRunning) {
            return;
        }
        this.isThreadRequestRunning = true;
        QueryHostsRunner runner = new QueryHostsRunner(preferPhex);
        Environment.getInstance().executeOnThreadPool(runner, "GWebCacheQuery-" + Integer.toHexString(runner.hashCode()));
    }

    public void invokeUpdateRemoteGWebCache(DestAddress myHostAddress, boolean preferPhex) {
        UpdateGWebCacheRunner runner = new UpdateGWebCacheRunner(myHostAddress, preferPhex);
        Environment.getInstance().executeOnThreadPool(runner, "GWebCacheQuery-" + Integer.toHexString(runner.hashCode()));
    }

    public synchronized void invokeQueryMoreGWebCachesRequest(boolean preferPhex) {
        if (this.isThreadRequestRunning) {
            return;
        }
        this.isThreadRequestRunning = true;
        QueryGWebCachesRunner runner = new QueryGWebCachesRunner(preferPhex);
        Environment.getInstance().executeOnThreadPool(runner, "GWebCacheQuery-" + Integer.toHexString(runner.hashCode()));
    }

    public void postManagerInitRoutine() {
        NetworkHostsContainer netCont = this.servent.getHostService().getNetworkHostsContainer();
        Environment.getInstance().scheduleTimerTask(new UpdateGWebCacheTimer(netCont), 5400000L, 5400000L);
    }

    private final class UpdateGWebCacheTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 5400000L;
        private final NetworkHostsContainer netHostsContainer;

        UpdateGWebCacheTimer(NetworkHostsContainer netHostsContainer) {
            this.netHostsContainer = netHostsContainer;
        }

        public void run() {
            if (BootstrapManager.this.servent.getOnlineStatus().isNetworkOnline() || this.netHostsContainer.getTotalConnectionCount() > 0) {
                IpAddress localIp;
                DestAddress localAddress = null;
                if (!BootstrapManager.this.servent.isFirewalled() && (localIp = (localAddress = BootstrapManager.this.servent.getLocalAddress()).getIpAddress()) != null && localIp.isSiteLocalIP()) {
                    localAddress = null;
                }
                BootstrapManager.this.invokeUpdateRemoteGWebCache(localAddress, true);
            }
        }
    }

    private final class QueryHostsRunner
    implements Runnable {
        private boolean preferPhex;

        QueryHostsRunner(boolean preferPhex) {
            this.preferPhex = preferPhex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                BootstrapManager.this.gWebCacheContainer.queryMoreHosts(this.preferPhex);
            }
            finally {
                BootstrapManager.this.isThreadRequestRunning = false;
            }
        }
    }

    private final class UpdateGWebCacheRunner
    implements Runnable {
        private final DestAddress myHostAddress;
        private boolean preferPhex;

        private UpdateGWebCacheRunner(DestAddress myHostAddress, boolean preferPhex) {
            this.myHostAddress = myHostAddress;
            this.preferPhex = preferPhex;
        }

        public void run() {
            BootstrapManager.this.gWebCacheContainer.updateRemoteGWebCache(this.myHostAddress, this.preferPhex);
        }
    }

    private final class QueryGWebCachesRunner
    implements Runnable {
        private boolean preferPhex;

        QueryGWebCachesRunner(boolean preferPhex) {
            this.preferPhex = preferPhex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                BootstrapManager.this.gWebCacheContainer.queryMoreGWebCaches(this.preferPhex);
            }
            finally {
                BootstrapManager.this.isThreadRequestRunning = false;
            }
        }
    }
}

