/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextJNDISelector;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.selector.DefaultContextSelector;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusPrinter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.ILoggerFactory;
import org.slf4j.helpers.Util;
import org.slf4j.spi.LoggerFactoryBinder;

public class StaticLoggerBinder
implements LoggerFactoryBinder {
    public static String REQUESTED_API_VERSION = "1.5.6";
    static final String NULL_CS_URL = "http://logback.qos.ch/codes.html#null_CS";
    private static StaticLoggerBinder SINGLETON = new StaticLoggerBinder();
    private boolean initialized = false;
    private LoggerContext defaultLoggerContext = new LoggerContext();
    private ContextSelector contextSelector;

    private StaticLoggerBinder() {
        this.defaultLoggerContext.setName("default");
    }

    public static StaticLoggerBinder getSingleton() {
        return SINGLETON;
    }

    static void reset() {
        SINGLETON = new StaticLoggerBinder();
        SINGLETON.init();
    }

    void init() {
        try {
            try {
                new ContextInitializer(this.defaultLoggerContext).autoConfig();
            }
            catch (JoranException je) {
                Util.reportFailure((String)"Failed to auto configure default logger context", (Throwable)je);
            }
            StatusPrinter.printIfErrorsOccured((Context)this.defaultLoggerContext);
            String contextSelectorStr = OptionHelper.getSystemProperty((String)"logback.ContextSelector");
            this.contextSelector = contextSelectorStr == null ? new DefaultContextSelector(this.defaultLoggerContext) : (contextSelectorStr.equals("JNDI") ? new ContextJNDISelector(this.defaultLoggerContext) : StaticLoggerBinder.dynamicalContextSelector(this.defaultLoggerContext, contextSelectorStr));
            this.initialized = true;
        }
        catch (Throwable t) {
            Util.reportFailure((String)("Failed to instantiate [" + LoggerContext.class.getName() + "]"), (Throwable)t);
        }
    }

    static ContextSelector dynamicalContextSelector(LoggerContext defaultLoggerContext, String contextSelectorStr) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class contextSelectorClass = Loader.loadClass((String)contextSelectorStr);
        Constructor cons = contextSelectorClass.getConstructor(LoggerContext.class);
        return (ContextSelector)cons.newInstance(new Object[]{defaultLoggerContext});
    }

    public ILoggerFactory getLoggerFactory() {
        if (!this.initialized) {
            return this.defaultLoggerContext;
        }
        if (this.contextSelector == null) {
            throw new IllegalStateException("contextSelector cannot be null. See also http://logback.qos.ch/codes.html#null_CS");
        }
        return this.contextSelector.getLoggerContext();
    }

    public String getLoggerFactoryClassStr() {
        return this.contextSelector.getClass().getName();
    }

    public ContextSelector getContextSelector() {
        return this.contextSelector;
    }

    static {
        SINGLETON.init();
    }
}

