/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class IOUtil {
    /*
     * WARNING - void declaration
     */
    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int el;
        if (in == null || out == null) {
            throw new NullPointerException();
        }
        byte[] buffer = new byte[32768];
        while ((el = in.read(buffer)) != -1) {
            void var2_3;
            out.write(buffer, 0, (int)var2_3);
        }
    }

    public static byte[] createByteArrayFromInputStream(InputStream in) throws IOException {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        IOUtil.copyStream(in, byteArray);
        return byteArray.toByteArray();
    }

    public static void moveFile(File sourceFile, File destinationFile) throws IOException {
        boolean succesfulMove;
        if (destinationFile.exists()) {
            destinationFile.delete();
        }
        if (succesfulMove = sourceFile.renameTo(destinationFile)) {
            return;
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(sourceFile);
            out = new FileOutputStream(destinationFile);
            IOUtil.copyStream(in, out);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            in = IOUtil.closeInputStream(in);
            out = IOUtil.closeOutputStream(out);
            throw throwable;
        }
        in = IOUtil.closeInputStream(in);
        out = IOUtil.closeOutputStream(out);
        sourceFile.delete();
    }

    public static InputStream closeInputStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
                in = null;
            }
            catch (IOException e) {
                System.err.println("Cobertura: Error closing input stream.");
                e.printStackTrace();
            }
        }
        return in;
    }

    public static OutputStream closeOutputStream(OutputStream out) {
        if (out != null) {
            try {
                out.close();
                out = null;
            }
            catch (IOException e) {
                System.err.println("Cobertura: Error closing output stream.");
                e.printStackTrace();
            }
        }
        return out;
    }
}

