/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.reporting.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.LineData;
import net.sourceforge.cobertura.coveragedata.PackageData;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.coveragedata.SourceFileData;
import net.sourceforge.cobertura.reporting.ComplexityCalculator;
import net.sourceforge.cobertura.util.FileFinder;
import net.sourceforge.cobertura.util.Header;
import net.sourceforge.cobertura.util.StringUtil;
import org.apache.log4j.Logger;

public class XMLReport {
    private static final Logger logger = Logger.getLogger((Class)(class$net$sourceforge$cobertura$reporting$xml$XMLReport == null ? (class$net$sourceforge$cobertura$reporting$xml$XMLReport = XMLReport.class$("net.sourceforge.cobertura.reporting.xml.XMLReport")) : class$net$sourceforge$cobertura$reporting$xml$XMLReport));
    protected static final String coverageDTD = "coverage-02.dtd";
    private final PrintWriter pw;
    private final FileFinder finder;
    private final ComplexityCalculator complexity;
    private int indent = 0;
    static /* synthetic */ Class class$net$sourceforge$cobertura$reporting$xml$XMLReport;

    public XMLReport(ProjectData projectData, File destinationDir, FileFinder finder, ComplexityCalculator complexity) throws IOException {
        this.complexity = complexity;
        this.finder = finder;
        this.pw = new PrintWriter(new FileWriter(new File(destinationDir, "coverage.xml")));
        try {
            this.println("<?xml version=\"1.0\"?>");
            this.println("<!DOCTYPE coverage SYSTEM \"http://cobertura.sourceforge.net/xml/coverage-02.dtd\">");
            this.println("");
            this.println("<coverage line-rate=\"" + projectData.getLineCoverageRate() + "\" branch-rate=\"" + projectData.getBranchCoverageRate() + "\" version=\"" + Header.version() + "\" timestamp=\"" + new Date().getTime() + "\">");
            this.increaseIndentation();
            this.dumpSources();
            this.dumpPackages(projectData);
            this.decreaseIndentation();
            this.println("</coverage>");
            Object var6_5 = null;
            this.pw.close();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.pw.close();
            throw throwable;
        }
    }

    void increaseIndentation() {
        ++this.indent;
    }

    void decreaseIndentation() {
        if (this.indent > 0) {
            --this.indent;
        }
    }

    void indent() {
        int i = 0;
        while (i < this.indent) {
            this.pw.print("\t");
            ++i;
        }
    }

    void println(String ln) {
        this.indent();
        this.pw.println(ln);
    }

    private void dumpSources() {
        this.println("<sources>");
        this.increaseIndentation();
        Iterator it = this.finder.getSourceDirectoryList().iterator();
        while (it.hasNext()) {
            String dir = (String)it.next();
            this.dumpSource(dir);
        }
        this.decreaseIndentation();
        this.println("</sources>");
    }

    private void dumpSource(String sourceDirectory) {
        this.println("<source>" + sourceDirectory + "</source>");
    }

    private void dumpPackages(ProjectData projectData) {
        this.println("<packages>");
        this.increaseIndentation();
        Iterator it = projectData.getPackages().iterator();
        while (it.hasNext()) {
            this.dumpPackage((PackageData)it.next());
        }
        this.decreaseIndentation();
        this.println("</packages>");
    }

    private void dumpPackage(PackageData packageData) {
        logger.debug((Object)("Dumping package " + packageData.getName()));
        this.println("<package name=\"" + packageData.getName() + "\" line-rate=\"" + packageData.getLineCoverageRate() + "\" branch-rate=\"" + packageData.getBranchCoverageRate() + "\" complexity=\"" + this.complexity.getCCNForPackage(packageData) + "\"" + ">");
        this.increaseIndentation();
        this.dumpSourceFiles(packageData);
        this.decreaseIndentation();
        this.println("</package>");
    }

    private void dumpSourceFiles(PackageData packageData) {
        this.println("<classes>");
        this.increaseIndentation();
        Iterator it = packageData.getSourceFiles().iterator();
        while (it.hasNext()) {
            this.dumpClasses((SourceFileData)it.next());
        }
        this.decreaseIndentation();
        this.println("</classes>");
    }

    private void dumpClasses(SourceFileData sourceFileData) {
        Iterator it = sourceFileData.getClasses().iterator();
        while (it.hasNext()) {
            this.dumpClass((ClassData)it.next());
        }
    }

    private void dumpClass(ClassData classData) {
        logger.debug((Object)("Dumping class " + classData.getName()));
        this.println("<class name=\"" + classData.getName() + "\" filename=\"" + classData.getSourceFileName() + "\" line-rate=\"" + classData.getLineCoverageRate() + "\" branch-rate=\"" + classData.getBranchCoverageRate() + "\" complexity=\"" + this.complexity.getCCNForClass(classData) + "\"" + ">");
        this.increaseIndentation();
        this.dumpMethods(classData);
        this.dumpLines(classData);
        this.decreaseIndentation();
        this.println("</class>");
    }

    private void dumpMethods(ClassData classData) {
        this.println("<methods>");
        this.increaseIndentation();
        TreeSet sortedMethods = new TreeSet();
        sortedMethods.addAll(classData.getMethodNamesAndDescriptors());
        Iterator iter = sortedMethods.iterator();
        while (iter.hasNext()) {
            this.dumpMethod(classData, (String)iter.next());
        }
        this.decreaseIndentation();
        this.println("</methods>");
    }

    private void dumpMethod(ClassData classData, String nameAndSig) {
        String name = nameAndSig.substring(0, nameAndSig.indexOf(40));
        String signature = nameAndSig.substring(nameAndSig.indexOf(40));
        double lineRate = classData.getLineCoverageRate(nameAndSig);
        double branchRate = classData.getBranchCoverageRate(nameAndSig);
        this.println("<method name=\"" + XMLReport.xmlEscape(name) + "\" signature=\"" + XMLReport.xmlEscape(signature) + "\" line-rate=\"" + lineRate + "\" branch-rate=\"" + branchRate + "\">");
        this.increaseIndentation();
        this.dumpLines(classData, nameAndSig);
        this.decreaseIndentation();
        this.println("</method>");
    }

    private static String xmlEscape(String str) {
        str = StringUtil.replaceAll(str, "<", "&lt;");
        str = StringUtil.replaceAll(str, ">", "&gt;");
        return str;
    }

    private void dumpLines(ClassData classData) {
        this.dumpLines(classData.getLines());
    }

    private void dumpLines(ClassData classData, String methodNameAndSig) {
        this.dumpLines(classData.getLines(methodNameAndSig));
    }

    private void dumpLines(Collection lines) {
        this.println("<lines>");
        this.increaseIndentation();
        TreeSet sortedLines = new TreeSet();
        sortedLines.addAll(lines);
        Iterator iter = sortedLines.iterator();
        while (iter.hasNext()) {
            this.dumpLine((LineData)iter.next());
        }
        this.decreaseIndentation();
        this.println("</lines>");
    }

    private void dumpLine(LineData lineData) {
        int lineNumber = lineData.getLineNumber();
        long hitCount = lineData.getHits();
        boolean isBranch = lineData.isBranch();
        this.println("<line number=\"" + lineNumber + "\" hits=\"" + hitCount + "\" branch=\"" + isBranch + "\"/>");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

