/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.reporting.html;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.PackageData;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.coveragedata.SourceFileData;
import net.sourceforge.cobertura.reporting.ComplexityCalculator;
import net.sourceforge.cobertura.reporting.html.JavaToHtml;
import net.sourceforge.cobertura.reporting.html.SourceFileDataBaseNameComparator;
import net.sourceforge.cobertura.reporting.html.files.CopyFiles;
import net.sourceforge.cobertura.util.FileFinder;
import net.sourceforge.cobertura.util.Header;
import org.apache.log4j.Logger;

public class HTMLReport {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$net$sourceforge$cobertura$reporting$html$HTMLReport == null ? (class$net$sourceforge$cobertura$reporting$html$HTMLReport = HTMLReport.class$("net.sourceforge.cobertura.reporting.html.HTMLReport")) : class$net$sourceforge$cobertura$reporting$html$HTMLReport));
    private File destinationDir;
    private FileFinder finder;
    private ComplexityCalculator complexity;
    private ProjectData projectData;
    static /* synthetic */ Class class$net$sourceforge$cobertura$reporting$html$HTMLReport;

    public HTMLReport(ProjectData projectData, File outputDir, FileFinder finder, ComplexityCalculator complexity) throws Exception {
        this.destinationDir = outputDir;
        this.finder = finder;
        this.complexity = complexity;
        this.projectData = projectData;
        CopyFiles.copy(outputDir);
        this.generatePackageList();
        this.generateSourceFileLists();
        this.generateOverviews();
        this.generateSourceFiles();
    }

    private String generatePackageName(PackageData packageData) {
        if (packageData.getName().equals("")) {
            return "(default)";
        }
        return packageData.getName();
    }

    private void generatePackageList() throws IOException {
        File file = new File(this.destinationDir, "frame-packages.html");
        PrintStream out = null;
        try {
            out = new PrintStream(new FileOutputStream(file));
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
            out.println("           \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
            out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">");
            out.println("<head>");
            out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
            out.println("<title>Coverage Report</title>");
            out.println("<link title=\"Style\" type=\"text/css\" rel=\"stylesheet\" href=\"css/main.css\" />");
            out.println("</head>");
            out.println("<body>");
            out.println("<h5>Packages</h5>");
            out.println("<table width=\"100%\">");
            out.println("<tr>");
            out.println("<td nowrap=\"nowrap\"><a href=\"frame-summary.html\" onclick='parent.sourceFileList.location.href=\"frame-sourcefiles.html\"' target=\"summary\">All</a></td>");
            out.println("</tr>");
            Iterator iter = this.projectData.getPackages().iterator();
            while (iter.hasNext()) {
                PackageData packageData = (PackageData)iter.next();
                String url1 = "frame-summary-" + packageData.getName() + ".html";
                String url2 = "frame-sourcefiles-" + packageData.getName() + ".html";
                out.println("<tr>");
                out.println("<td nowrap=\"nowrap\"><a href=\"" + url1 + "\" onclick='parent.sourceFileList.location.href=\"" + url2 + "\"' target=\"summary\">" + this.generatePackageName(packageData) + "</a></td>");
                out.println("</tr>");
            }
            out.println("</table>");
            out.println("</body>");
            out.println("</html>");
            Object var8_7 = null;
            if (out != null) {
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (out != null) {
                out.close();
            }
            throw throwable;
        }
    }

    private void generateSourceFileLists() throws IOException {
        this.generateSourceFileList(null);
        Iterator iter = this.projectData.getPackages().iterator();
        while (iter.hasNext()) {
            PackageData packageData = (PackageData)iter.next();
            this.generateSourceFileList(packageData);
        }
    }

    private void generateSourceFileList(PackageData packageData) throws IOException {
        Collection sourceFiles;
        String filename;
        if (packageData == null) {
            filename = "frame-sourcefiles.html";
            sourceFiles = this.projectData.getSourceFiles();
        } else {
            filename = "frame-sourcefiles-" + packageData.getName() + ".html";
            sourceFiles = packageData.getSourceFiles();
        }
        Vector sortedSourceFiles = new Vector();
        sortedSourceFiles.addAll(sourceFiles);
        Collections.sort(sortedSourceFiles, new SourceFileDataBaseNameComparator());
        File file = new File(this.destinationDir, filename);
        PrintStream out = null;
        try {
            out = new PrintStream(new FileOutputStream(file));
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
            out.println("           \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
            out.println("<html>");
            out.println("<head>");
            out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>");
            out.println("<title>Coverage Report Classes</title>");
            out.println("<link title=\"Style\" type=\"text/css\" rel=\"stylesheet\" href=\"css/main.css\"/>");
            out.println("</head>");
            out.println("<body>");
            out.println("<h5>");
            out.println(packageData == null ? "All Packages" : this.generatePackageName(packageData));
            out.println("</h5>");
            out.println("<div class=\"separator\">&nbsp;</div>");
            out.println("<h5>Classes</h5>");
            if (!sortedSourceFiles.isEmpty()) {
                out.println("<table width=\"100%\">");
                out.println("<tbody>");
                Iterator iter = ((AbstractList)sortedSourceFiles).iterator();
                while (iter.hasNext()) {
                    SourceFileData sourceFileData = (SourceFileData)iter.next();
                    out.println("<tr>");
                    String percentCovered = sourceFileData.getNumberOfValidLines() > 0 ? HTMLReport.getPercentValue(sourceFileData.getLineCoverageRate()) : "N/A";
                    out.println("<td nowrap=\"nowrap\"><a target=\"summary\" href=\"" + sourceFileData.getNormalizedName() + ".html\">" + sourceFileData.getBaseName() + "</a> <i>(" + percentCovered + ")</i></td>");
                    out.println("</tr>");
                }
                out.println("</tbody>");
                out.println("</table>");
            }
            out.println("</body>");
            out.println("</html>");
            Object var11_10 = null;
            if (out != null) {
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (out != null) {
                out.close();
            }
            throw throwable;
        }
    }

    private void generateOverviews() throws IOException {
        this.generateOverview(null);
        Iterator iter = this.projectData.getPackages().iterator();
        while (iter.hasNext()) {
            PackageData packageData = (PackageData)iter.next();
            this.generateOverview(packageData);
        }
    }

    private void generateOverview(PackageData packageData) throws IOException {
        String filename = packageData == null ? "frame-summary.html" : "frame-summary-" + packageData.getName() + ".html";
        File file = new File(this.destinationDir, filename);
        PrintStream out = null;
        try {
            PackageData defaultPackage;
            SortedSet packages;
            out = new PrintStream(new FileOutputStream(file));
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
            out.println("           \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
            out.println("<html>");
            out.println("<head>");
            out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>");
            out.println("<title>Coverage Report</title>");
            out.println("<link title=\"Style\" type=\"text/css\" rel=\"stylesheet\" href=\"css/main.css\"/>");
            out.println("<link title=\"Style\" type=\"text/css\" rel=\"stylesheet\" href=\"css/sortabletable.css\"/>");
            out.println("<script type=\"text/javascript\" src=\"js/popup.js\"></script>");
            out.println("<script type=\"text/javascript\" src=\"js/sortabletable.js\"></script>");
            out.println("<script type=\"text/javascript\" src=\"js/customsorttypes.js\"></script>");
            out.println("</head>");
            out.println("<body>");
            out.print("<h5>Coverage Report - ");
            out.print(packageData == null ? "All Packages" : this.generatePackageName(packageData));
            out.println("</h5>");
            out.println("<div class=\"separator\">&nbsp;</div>");
            out.println("<table class=\"report\" id=\"packageResults\">");
            out.println(HTMLReport.generateTableHeader("Package", true));
            out.println("<tbody>");
            if (packageData == null) {
                out.println(this.generateTableRowForTotal());
                packages = this.projectData.getPackages();
            } else {
                packages = this.projectData.getSubPackages(packageData.getName());
            }
            Iterator iter = packages.iterator();
            while (iter.hasNext()) {
                PackageData subPackageData = (PackageData)iter.next();
                out.println(this.generateTableRowForPackage(subPackageData));
            }
            out.println("</tbody>");
            out.println("</table>");
            out.println("<script type=\"text/javascript\">");
            out.println("var packageTable = new SortableTable(document.getElementById(\"packageResults\"),");
            out.println("    [\"String\", \"Number\", \"Percentage\", \"Percentage\", \"FormattedNumber\"]);");
            out.println("packageTable.sort(0);");
            out.println("</script>");
            Collection sourceFiles = packageData == null ? ((defaultPackage = (PackageData)this.projectData.getChild("")) != null ? defaultPackage.getSourceFiles() : new TreeSet()) : packageData.getSourceFiles();
            if (sourceFiles.size() > 0) {
                out.println("<div class=\"separator\">&nbsp;</div>");
                out.println("<table class=\"report\" id=\"classResults\">");
                out.println(HTMLReport.generateTableHeader("Classes in this Package", false));
                out.println("<tbody>");
                iter = sourceFiles.iterator();
                while (iter.hasNext()) {
                    SourceFileData sourceFileData = (SourceFileData)iter.next();
                    out.println(this.generateTableRowsForSourceFile(sourceFileData));
                }
                out.println("</tbody>");
                out.println("</table>");
                out.println("<script type=\"text/javascript\">");
                out.println("var classTable = new SortableTable(document.getElementById(\"classResults\"),");
                out.println("    [\"String\", \"Percentage\", \"Percentage\", \"FormattedNumber\"]);");
                out.println("classTable.sort(0);");
                out.println("</script>");
            }
            out.println(HTMLReport.generateFooter());
            out.println("</body>");
            out.println("</html>");
            Object var10_9 = null;
            if (out != null) {
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (out != null) {
                out.close();
            }
            throw throwable;
        }
    }

    private void generateSourceFiles() {
        Iterator iter = this.projectData.getSourceFiles().iterator();
        while (iter.hasNext()) {
            SourceFileData sourceFileData = (SourceFileData)iter.next();
            try {
                this.generateSourceFile(sourceFileData);
            }
            catch (IOException e) {
                LOGGER.info((Object)("Could not generate HTML file for source file " + sourceFileData.getName() + ": " + e.getLocalizedMessage()));
            }
        }
    }

    private void generateSourceFile(SourceFileData sourceFileData) throws IOException {
        if (!sourceFileData.containsInstrumentationInfo()) {
            LOGGER.info((Object)("Data file does not contain instrumentation information for the file " + sourceFileData.getName() + ".  Ensure this class was instrumented, and this " + "data file contains the instrumentation information."));
        }
        String filename = sourceFileData.getNormalizedName() + ".html";
        File file = new File(this.destinationDir, filename);
        PrintStream out = null;
        try {
            out = new PrintStream(new FileOutputStream(file));
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
            out.println("           \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
            out.println("<html>");
            out.println("<head>");
            out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>");
            out.println("<title>Coverage Report</title>");
            out.println("<link title=\"Style\" type=\"text/css\" rel=\"stylesheet\" href=\"css/main.css\"/>");
            out.println("<script type=\"text/javascript\" src=\"js/popup.js\"></script>");
            out.println("</head>");
            out.println("<body>");
            out.print("<h5>Coverage Report - ");
            String classPackageName = sourceFileData.getPackageName();
            if (classPackageName != null && classPackageName.length() > 0) {
                out.print(classPackageName + ".");
            }
            out.print(sourceFileData.getBaseName());
            out.println("</h5>");
            out.println("<div class=\"separator\">&nbsp;</div>");
            out.println("<table class=\"report\">");
            out.println(HTMLReport.generateTableHeader("Classes in this File", false));
            out.println(this.generateTableRowsForSourceFile(sourceFileData));
            out.println("</table>");
            out.println("<div class=\"separator\">&nbsp;</div>");
            out.println(this.generateHtmlizedJavaSource(sourceFileData));
            out.println(HTMLReport.generateFooter());
            out.println("</body>");
            out.println("</html>");
            Object var7_6 = null;
            if (out != null) {
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (out != null) {
                out.close();
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private String generateHtmlizedJavaSource(SourceFileData sourceFileData) {
        StringBuffer ret;
        block17: {
            String lineStr;
            File sourceFile = null;
            try {
                sourceFile = this.finder.getFileForSource(sourceFileData.getName());
            }
            catch (IOException e) {
                return "<p>Unable to locate " + sourceFileData.getName() + ".  Have you specified the source directory?</p>";
            }
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(sourceFile));
            }
            catch (FileNotFoundException e) {
                return "<p>Unable to open " + sourceFile.getAbsolutePath() + "</p>";
            }
            ret = new StringBuffer();
            ret.append("<table cellspacing=\"0\" cellpadding=\"0\" class=\"src\">\n");
            JavaToHtml javaToHtml = new JavaToHtml();
            int lineNumber = 1;
            while ((lineStr = br.readLine()) != null) {
                void var5_9;
                ret.append("<tr>");
                if (sourceFileData.isValidSourceLineNumber(lineNumber)) {
                    long numberOfHits = sourceFileData.getHitCount(lineNumber);
                    ret.append("  <td class=\"numLineCover\">&nbsp;" + lineNumber + "</td>");
                    if (numberOfHits > 0L) {
                        ret.append("  <td class=\"nbHitsCovered\">&nbsp;" + numberOfHits + "</td>");
                        ret.append("  <td class=\"src\"><pre class=\"src\">&nbsp;" + javaToHtml.process((String)var5_9) + "</pre></td>");
                    } else {
                        ret.append("  <td class=\"nbHitsUncovered\">&nbsp;" + numberOfHits + "</td>");
                        ret.append("  <td class=\"src\"><pre class=\"src\"><span class=\"srcUncovered\">&nbsp;" + javaToHtml.process((String)var5_9) + "</span></pre></td>");
                    }
                } else {
                    ret.append("  <td class=\"numLine\">&nbsp;" + lineNumber + "</td>");
                    ret.append("  <td class=\"nbHits\">&nbsp;</td>\n");
                    ret.append("  <td class=\"src\"><pre class=\"src\">&nbsp;" + javaToHtml.process((String)var5_9) + "</pre></td>");
                }
                ret.append("</tr>\n");
                ++lineNumber;
            }
            Object var11_12 = null;
            try {
                br.close();
            }
            catch (IOException e2) {}
            break block17;
            {
                catch (IOException e) {
                    ret.append("<tr><td>Error reading from file " + sourceFile.getAbsolutePath() + ": " + e.getLocalizedMessage() + "</td></tr>\n");
                    Object var11_13 = null;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    br.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        ret.append("</table>\n");
        return ret.toString();
    }

    private static String generateFooter() {
        return "<div class=\"footer\">Report generated by <a href=\"http://cobertura.sourceforge.net/\" target=\"_top\">Cobertura</a> " + Header.version() + " on " + DateFormat.getInstance().format(new Date()) + ".</div>";
    }

    private static String generateTableHeader(String title, boolean showColumnForNumberOfClasses) {
        StringBuffer ret = new StringBuffer();
        ret.append("<thead>");
        ret.append("<tr>");
        ret.append("  <td class=\"heading\">" + title + "</td>");
        if (showColumnForNumberOfClasses) {
            ret.append("  <td class=\"heading\"># Classes</td>");
        }
        ret.append("  <td class=\"heading\">" + HTMLReport.generateHelpURL("Line Coverage", "The percent of lines executed by this test run.") + "</td>");
        ret.append("  <td class=\"heading\">" + HTMLReport.generateHelpURL("Branch Coverage", "The percent of branches executed by this test run.") + "</td>");
        ret.append("  <td class=\"heading\">" + HTMLReport.generateHelpURL("Complexity", "Average McCabe's cyclomatic code complexity for all methods.  This is basically a count of the number of different code paths in a method (incremented by 1 for each if statement, while loop, etc.)") + "</td>");
        ret.append("</tr>");
        ret.append("</thead>");
        return ret.toString();
    }

    private static String generateHelpURL(String text, String description) {
        StringBuffer ret = new StringBuffer();
        boolean popupTooltips = false;
        if (popupTooltips) {
            ret.append("<a class=\"hastooltip\" href=\"help.html\" onclick=\"popupwindow('help.html'); return false;\">");
            ret.append(text);
            ret.append("<span>" + description + "</span>");
            ret.append("</a>");
        } else {
            ret.append("<a class=\"dfn\" href=\"help.html\" onclick=\"popupwindow('help.html'); return false;\">");
            ret.append(text);
            ret.append("</a>");
        }
        return ret.toString();
    }

    private String generateTableRowForTotal() {
        StringBuffer ret = new StringBuffer();
        double ccn = this.complexity.getCCNForProject(this.projectData);
        ret.append("  <tr>");
        ret.append("<td><b>All Packages</b></td>");
        ret.append("<td class=\"value\">" + this.projectData.getNumberOfSourceFiles() + "</td>");
        ret.append(HTMLReport.generateTableColumnsFromData(this.projectData, ccn));
        ret.append("</tr>");
        return ret.toString();
    }

    private String generateTableRowForPackage(PackageData packageData) {
        StringBuffer ret = new StringBuffer();
        String url1 = "frame-summary-" + packageData.getName() + ".html";
        String url2 = "frame-sourcefiles-" + packageData.getName() + ".html";
        double ccn = this.complexity.getCCNForPackage(packageData);
        ret.append("  <tr>");
        ret.append("<td><a href=\"" + url1 + "\" onclick='parent.sourceFileList.location.href=\"" + url2 + "\"'>" + this.generatePackageName(packageData) + "</a></td>");
        ret.append("<td class=\"value\">" + packageData.getNumberOfChildren() + "</td>");
        ret.append(HTMLReport.generateTableColumnsFromData(packageData, ccn));
        ret.append("</tr>");
        return ret.toString();
    }

    private String generateTableRowsForSourceFile(SourceFileData sourceFileData) {
        StringBuffer ret = new StringBuffer();
        String sourceFileName = sourceFileData.getNormalizedName();
        double ccn = this.complexity.getCCNForSourceFile(sourceFileData);
        Iterator iter = sourceFileData.getClasses().iterator();
        while (iter.hasNext()) {
            ClassData classData = (ClassData)iter.next();
            ret.append(this.generateTableRowForClass(classData, sourceFileName, ccn));
        }
        return ret.toString();
    }

    private String generateTableRowForClass(ClassData classData, String sourceFileName, double ccn) {
        StringBuffer ret = new StringBuffer();
        ret.append("  <tr>");
        ret.append("<td><a href=\"" + sourceFileName + ".html\">" + classData.getBaseName() + "</a></td>");
        ret.append(HTMLReport.generateTableColumnsFromData(classData, ccn));
        ret.append("</tr>\n");
        return ret.toString();
    }

    private static String generateTableColumnsFromData(CoverageData coverageData, double ccn) {
        int numLinesCovered = coverageData.getNumberOfCoveredLines();
        int numLinesValid = coverageData.getNumberOfValidLines();
        int numBranchesCovered = coverageData.getNumberOfCoveredBranches();
        int numBranchesValid = coverageData.getNumberOfValidBranches();
        return "<td>" + HTMLReport.generatePercentResult(numLinesCovered, numLinesValid) + "</td><td>" + HTMLReport.generatePercentResult(numBranchesCovered, numBranchesValid) + "</td><td class=\"value\"><span class=\"hidden\">" + ccn + ";</span>" + HTMLReport.getDoubleValue(ccn) + "</td>";
    }

    private static String generatePercentResult(int dividend, int divisor) {
        StringBuffer sb = new StringBuffer();
        sb.append("<table cellpadding=\"0px\" cellspacing=\"0px\" class=\"percentgraph\"><tr class=\"percentgraph\"><td align=\"right\" class=\"percentgraph\" width=\"40\">");
        if (divisor > 0) {
            sb.append(HTMLReport.getPercentValue((double)dividend / (double)divisor));
        } else {
            sb.append(HTMLReport.generateHelpURL("N/A", "Line coverage and branch coverage will appear as \"Not Applicable\" when Cobertura can not find line number information in the .class file.  This happens for stub and skeleton classes, interfaces, or when the class was not compiled with \"debug=true.\""));
        }
        sb.append("</td><td class=\"percentgraph\"><div class=\"percentgraph\">");
        if (divisor > 0) {
            sb.append("<div class=\"greenbar\" style=\"width:" + dividend * 100 / divisor + "px\">");
            sb.append("<span class=\"text\">");
            sb.append(dividend);
            sb.append("/");
            sb.append(divisor);
        } else {
            sb.append("<div class=\"na\" style=\"width:100px\">");
            sb.append("<span class=\"text\">");
            sb.append(HTMLReport.generateHelpURL("N/A", "Line coverage and branch coverage will appear as \"Not Applicable\" when Cobertura can not find line number information in the .class file.  This happens for stub and skeleton classes, interfaces, or when the class was not compiled with \"debug=true.\""));
        }
        sb.append("</span></div></div></td></tr></table>");
        return sb.toString();
    }

    private static String getDoubleValue(double value) {
        DecimalFormat formatter = new DecimalFormat();
        return formatter.format(value);
    }

    private static String getPercentValue(double value) {
        NumberFormat formatter = NumberFormat.getPercentInstance();
        return formatter.format(value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

