/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.Container;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.extend.InitializingBean;
import org.directwebremoting.servlet.ExceptionHandler;
import org.directwebremoting.servlet.NotFoundHandler;
import org.directwebremoting.util.Logger;

public class UrlProcessor
implements Handler,
InitializingBean {
    private String indexHandlerUrl;
    private Map urlMapping = new HashMap();
    private Handler notFoundHandler = new NotFoundHandler();
    private ExceptionHandler exceptionHandler = new ExceptionHandler();
    protected static final Logger log = Logger.getLogger(class$org$directwebremoting$servlet$UrlProcessor == null ? (class$org$directwebremoting$servlet$UrlProcessor = UrlProcessor.class$("org.directwebremoting.servlet.UrlProcessor")) : class$org$directwebremoting$servlet$UrlProcessor);
    static /* synthetic */ Class class$org$directwebremoting$servlet$UrlProcessor;

    public void afterContainerSetup(Container container) {
        Collection beanNames = container.getBeanNames();
        Iterator it = beanNames.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!name.startsWith("url:")) continue;
            Object bean = container.getBean(name);
            if (bean instanceof Handler) {
                this.urlMapping.put(name.substring("url:".length()), bean);
                continue;
            }
            log.error("Discarding non Handler for " + name);
        }
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String pathInfo = request.getPathInfo();
            if (pathInfo == null || pathInfo.length() == 0 || pathInfo.equals("/")) {
                response.sendRedirect(request.getContextPath() + request.getServletPath() + this.indexHandlerUrl);
            } else {
                Iterator it = this.urlMapping.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String url = (String)entry.getKey();
                    if (!pathInfo.startsWith(url)) continue;
                    Handler handler = (Handler)entry.getValue();
                    handler.handle(request, response);
                    return;
                }
                this.notFoundHandler.handle(request, response);
            }
        }
        catch (Exception ex) {
            this.exceptionHandler.setException(ex);
            this.exceptionHandler.handle(request, response);
        }
    }

    public void setIndexHandlerUrl(String indexHandlerUrl) {
        this.indexHandlerUrl = indexHandlerUrl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

