/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.impl.DefaultScriptSession;
import org.directwebremoting.util.Logger;

public class DefaultScriptSessionManager
implements ScriptSessionManager {
    protected static final long DEFAULT_SESSION_CHECK_TIME = 30000L;
    protected PageNormalizer pageNormalizer;
    protected long scriptSessionTimeout = 1800000L;
    protected long scriptSessionCheckTime = 30000L;
    protected long lastSessionCheckAt = System.currentTimeMillis();
    protected final Object sessionLock = new Object();
    protected Map sessionMap = new HashMap();
    protected Map pageSessionMap = new HashMap();
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$impl$DefaultScriptSessionManager == null ? (class$org$directwebremoting$impl$DefaultScriptSessionManager = DefaultScriptSessionManager.class$("org.directwebremoting.impl.DefaultScriptSessionManager")) : class$org$directwebremoting$impl$DefaultScriptSessionManager);
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultScriptSessionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RealScriptSession getScriptSession(String id) {
        DefaultScriptSession session;
        this.maybeCheckTimeouts();
        Object object = this.sessionLock;
        synchronized (object) {
            session = (DefaultScriptSession)this.sessionMap.get(id);
            if (session == null) {
                session = new DefaultScriptSession(id, this);
                this.sessionMap.put(id, session);
            } else {
                session.updateLastAccessedTime();
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageForScriptSession(RealScriptSession scriptSession, String page) {
        String normalizedPage = this.pageNormalizer.normalizePage(page);
        Object object = this.sessionLock;
        synchronized (object) {
            HashSet<RealScriptSession> pageSessions = (HashSet<RealScriptSession>)this.pageSessionMap.get(normalizedPage);
            if (pageSessions == null) {
                pageSessions = new HashSet<RealScriptSession>();
                this.pageSessionMap.put(normalizedPage, pageSessions);
            }
            pageSessions.add(scriptSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getScriptSessionsByPage(String page) {
        String normalizedPage = this.pageNormalizer.normalizePage(page);
        Object object = this.sessionLock;
        synchronized (object) {
            HashSet pageSessions = (HashSet)this.pageSessionMap.get(normalizedPage);
            if (pageSessions == null) {
                pageSessions = new HashSet();
            }
            HashSet reply = new HashSet();
            reply.addAll(pageSessions);
            return reply;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllScriptSessions() {
        Object object = this.sessionLock;
        synchronized (object) {
            HashSet reply = new HashSet();
            reply.addAll(this.sessionMap.values());
            return reply;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidate(RealScriptSession session) {
        Object object = this.sessionLock;
        synchronized (object) {
            RealScriptSession removed = (RealScriptSession)this.sessionMap.remove(session.getId());
            if (!session.equals(removed)) {
                log.error("ScriptSession already removed from manager. session=" + session + " removed=" + removed);
            }
            int removeCount = 0;
            Iterator it = this.pageSessionMap.values().iterator();
            while (it.hasNext()) {
                Set pageSessions = (Set)it.next();
                boolean isRemoved = pageSessions.remove(session);
                if (!isRemoved) continue;
                ++removeCount;
            }
            if (removeCount != 1) {
                log.error("DefaultScriptSessionManager.invalidate(): removeCount=" + removeCount + " when invalidating: " + session);
            }
        }
    }

    protected void maybeCheckTimeouts() {
        long now = System.currentTimeMillis();
        if (now - this.scriptSessionCheckTime > this.lastSessionCheckAt) {
            this.checkTimeouts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        long now = System.currentTimeMillis();
        ArrayList<DefaultScriptSession> timeouts = new ArrayList<DefaultScriptSession>();
        Object object = this.sessionLock;
        synchronized (object) {
            Iterator it = this.sessionMap.values().iterator();
            while (it.hasNext()) {
                long age;
                DefaultScriptSession session = (DefaultScriptSession)it.next();
                if (session.isInvalidated() || (age = now - session.getLastAccessedTime()) <= this.scriptSessionTimeout) continue;
                timeouts.add(session);
            }
        }
        Iterator it = timeouts.iterator();
        while (it.hasNext()) {
            DefaultScriptSession session = (DefaultScriptSession)it.next();
            session.invalidate();
        }
    }

    public long getScriptSessionTimeout() {
        return this.scriptSessionTimeout;
    }

    public void setScriptSessionTimeout(long timeout) {
        this.scriptSessionTimeout = timeout;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setScriptSessionCheckTime(long scriptSessionCheckTime) {
        this.scriptSessionCheckTime = scriptSessionCheckTime;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

